/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_ObjectStream_OuterClass;
import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class TEST_ObjectInputStream_InnerClass_Instanceof
extends Mv_Assert {
    private SAMPLE_ObjectStream_OuterClass outerClassAfter;
    private Object object;
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private byte[] data = new byte[SAMPLE_SerialObject.icDataInt.length];

    public TEST_ObjectInputStream_InnerClass_Instanceof() {
        for (int i = 0; i < SAMPLE_SerialObject.icDataInt.length; ++i) {
            this.data[i] = (byte)SAMPLE_SerialObject.icDataInt[i];
        }
    }

    protected void runTest() {
        this.testInstanceOf();
        this.testPublicInnerClass();
        this.testPrivateInnerClass();
    }

    public void setUp() {
        this.openStream(this.data);
        try {
            this.object = this.ois.readObject();
        }
        catch (Exception e) {
            TEST_ObjectInputStream_InnerClass_Instanceof.fail(e.toString());
        }
    }

    public void tearDown() {
        this.closeStream();
    }

    public void closeStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectInputStream_InnerClass_Instanceof.fail("IO Exception while closing input stream");
        }
    }

    private void openStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectInputStream_InnerClass_Instanceof.fail("openStream> " + ioe.toString());
            return;
        }
    }

    public void testInstanceOf() {
        TEST_ObjectInputStream_InnerClass_Instanceof.assert("read object not an instance of original", this.object instanceof SAMPLE_ObjectStream_OuterClass);
    }

    public void testPublicInnerClass() {
        this.outerClassAfter = (SAMPLE_ObjectStream_OuterClass)this.object;
        TEST_ObjectInputStream_InnerClass_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_OuterClass.PublicInnerClass", this.outerClassAfter.puic instanceof SAMPLE_ObjectStream_OuterClass.PublicInnerClass);
    }

    public void testPrivateInnerClass() {
        this.outerClassAfter = (SAMPLE_ObjectStream_OuterClass)this.object;
        TEST_ObjectInputStream_InnerClass_Instanceof.assert("read object not an instance of SAMPLE_ObjectStream_OuterClass.PrivateInnerClass", this.outerClassAfter.isInstanceOfPrivateInnerClass(this.outerClassAfter.pric));
    }
}

