/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.Junittests.io;

import gnu.testlet.Junittests.io.SAMPLE_SerialObject;
import gnu.testlet.Mv_Assert;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;

public class TEST_ObjectInputStream_InnerClass_Exceptions
extends Mv_Assert {
    private ObjectInputStream ois;
    private ByteArrayInputStream bais;
    private byte[] data;
    private byte[] optionalData;
    private byte[] writeAbortedData;

    public TEST_ObjectInputStream_InnerClass_Exceptions() {
        try {
            int i;
            this.data = new byte[SAMPLE_SerialObject.icDataInt.length];
            for (i = 0; i < SAMPLE_SerialObject.icDataInt.length; ++i) {
                this.data[i] = (byte)SAMPLE_SerialObject.icDataInt[i];
            }
            this.optionalData = new byte[SAMPLE_SerialObject.optionalDataInt.length];
            for (i = 0; i < SAMPLE_SerialObject.optionalDataInt.length; ++i) {
                this.optionalData[i] = (byte)SAMPLE_SerialObject.optionalDataInt[i];
            }
            this.writeAbortedData = new byte[SAMPLE_SerialObject.writeAbortedDataInt.length];
            for (i = 0; i < SAMPLE_SerialObject.writeAbortedDataInt.length; ++i) {
                this.writeAbortedData[i] = (byte)SAMPLE_SerialObject.writeAbortedDataInt[i];
            }
        }
        catch (Exception e) {
            System.out.println("Exception in constructor");
        }
    }

    protected void runTest() {
        th.setclass("Serialization");
        th.checkPoint("EOFException");
        this.testEOFException();
        th.checkPoint("ClassNotFoundException");
        this.testClassNotFoundException();
        th.checkPoint("StreamCorruptedException");
        this.testStreamCorruptedException();
        th.checkPoint("InvalidClassException");
        this.testInvalidClassException();
        th.checkPoint("OptionalDataException");
        this.testOptionalDataException();
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void closeStream() {
        try {
            this.bais.close();
        }
        catch (IOException ioe) {
            TEST_ObjectInputStream_InnerClass_Exceptions.fail("IO Exception while closing input stream");
        }
    }

    private void openStream(byte[] data) {
        try {
            this.bais = new ByteArrayInputStream(data);
            this.ois = new ObjectInputStream(this.bais);
        }
        catch (IOException ioe) {
            TEST_ObjectInputStream_InnerClass_Exceptions.fail("openStream> " + ioe.toString());
            return;
        }
    }

    public void testEOFException() {
        this.openStream(this.data);
        Object obj = null;
        try {
            while (true) {
                obj = this.ois.readObject();
            }
        }
        catch (EOFException eofe) {
            this.closeStream();
            return;
        }
        catch (Exception e) {
            this.closeStream();
            TEST_ObjectInputStream_InnerClass_Exceptions.fail(e.toString());
            this.closeStream();
            TEST_ObjectInputStream_InnerClass_Exceptions.fail("EOFException expected, but not thrown");
            return;
        }
    }

    public void testClassNotFoundException() {
        byte[] data1 = (byte[])this.data.clone();
        data1[9] = 122;
        this.openStream(data1);
        Object obj = null;
        try {
            obj = this.ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            this.closeStream();
            return;
        }
        catch (IOException ioe) {
            this.closeStream();
            TEST_ObjectInputStream_InnerClass_Exceptions.fail(ioe.toString());
            return;
        }
        TEST_ObjectInputStream_InnerClass_Exceptions.fail("ClassNotFoundException expected");
    }

    public void testStreamCorruptedException() {
        byte[] data1 = (byte[])this.data.clone();
        data1[4] = -1;
        this.openStream(data1);
        Object obj = null;
        try {
            obj = this.ois.readObject();
        }
        catch (StreamCorruptedException sce) {
            this.closeStream();
            return;
        }
        catch (Exception e) {
            System.out.println("Exception");
            this.closeStream();
            TEST_ObjectInputStream_InnerClass_Exceptions.fail(e.toString());
            return;
        }
        this.closeStream();
        TEST_ObjectInputStream_InnerClass_Exceptions.fail("StreamCorruptedException expected");
    }

    public void testInvalidClassException() {
        byte[] data1 = (byte[])this.data.clone();
        data1[68] = -1;
        this.openStream(data1);
        Object obj = null;
        try {
            obj = this.ois.readObject();
        }
        catch (InvalidClassException ice) {
            this.closeStream();
            return;
        }
        catch (Exception e) {
            this.closeStream();
            TEST_ObjectInputStream_InnerClass_Exceptions.fail(e.toString());
            return;
        }
        this.closeStream();
        TEST_ObjectInputStream_InnerClass_Exceptions.fail("InvalidClassException expected");
    }

    public void testOptionalDataException() {
        this.openStream(this.optionalData);
        try {
            Object obj = this.ois.readObject();
        }
        catch (OptionalDataException ode) {
            this.closeStream();
            return;
        }
        catch (Exception e) {
            this.closeStream();
            TEST_ObjectInputStream_InnerClass_Exceptions.fail(e.toString());
        }
        this.closeStream();
        TEST_ObjectInputStream_InnerClass_Exceptions.fail("OptionalDataException expected");
    }
}

