/*
 * Decompiled with CFR 0.152.
 */
package JUnitTests;

import gnu.testlet.Mv_Assert;
import java.util.EmptyStackException;
import java.util.Stack;

public class TEST_Stack
extends Mv_Assert {
    public void testStack1() throws Exception {
        Stack stack = new Stack();
        if (!stack.isEmpty()) {
            TEST_Stack.fail("Newly created Stack is empty");
        }
    }

    public void testPush1() throws Exception {
        Object o1 = new Object();
        Object o2 = new Object();
        Stack<Object> stack = new Stack<Object>();
        if (o1 != stack.push(o1)) {
            TEST_Stack.fail("Returned object invalid on empty stack");
        }
        if (o2 != stack.push(o2)) {
            TEST_Stack.fail("Returned object invalid on non empty stack");
        }
    }

    public void testPush2() throws Exception {
        Object o1 = new Object();
        Object o2 = new Object();
        Stack<Object> stack = new Stack<Object>();
        stack.push(o1);
        if (stack.size() <= 0 || stack.elementAt(0) != o1) {
            TEST_Stack.fail("Pushed element is not at the top on an empty stack");
        }
        stack.push(o2);
        if (stack.size() <= 1 || stack.elementAt(1) != o2) {
            TEST_Stack.fail("Pushed element is not at the top on a non-empty stack");
        }
    }

    public void testPop1() throws Exception {
        try {
            Stack stack = new Stack();
            Object e = stack.pop();
        }
        catch (EmptyStackException ese) {
            return;
        }
        TEST_Stack.fail("pop() didn't throw any EmptyStackException on an empty stack");
    }

    public void testPop2() throws Exception {
        block4: {
            Object o1 = new Object();
            Object o2 = new Object();
            boolean expectException = false;
            try {
                Stack<Object> stack = new Stack<Object>();
                stack.push(o1);
                stack.push(o2);
                if (o2 != stack.pop()) {
                    TEST_Stack.fail("Popped element is not the expected one - case #1");
                }
                if (o1 != stack.pop()) {
                    TEST_Stack.fail("Popped element is not the expected one - case #2");
                }
                expectException = true;
                stack.pop();
            }
            catch (EmptyStackException ese) {
                if (expectException) break block4;
                TEST_Stack.fail("Caught unexpected EmptyStackException");
            }
        }
    }

    public void testPeek1() throws Exception {
        try {
            Stack stack = new Stack();
            Object e = stack.peek();
        }
        catch (EmptyStackException ese) {
            return;
        }
        TEST_Stack.fail("peek() didn't throw any EmptyStackException on an empty stack");
    }

    public void testPeek2() throws Exception {
        Object o1 = new Object();
        Object o2 = new Object();
        Stack<Object> stack = new Stack<Object>();
        stack.push(o1);
        if (o1 != stack.peek()) {
            TEST_Stack.fail("peek() didn't return the right object on a one-element stack");
        }
        stack.push(o2);
        if (o2 != stack.peek()) {
            TEST_Stack.fail("peek() didn't return the right object on a two-element stack");
        }
    }

    public void testEmpty1() throws Exception {
        Stack stack = new Stack();
        if (!stack.empty()) {
            TEST_Stack.fail("empty() doesn't return true on an empty stack");
        }
    }

    public void testSearch1() throws Exception {
        Stack<Object> stack = new Stack<Object>();
        if (stack.search(new Object()) != -1) {
            TEST_Stack.fail("search() didn't return -1 on an empty stack");
        }
        stack.push(new Object());
        if (stack.search(new Object()) != -1) {
            TEST_Stack.fail("search() didn't return -1 for an unknown object");
        }
    }

    public void testSearch2() throws Exception {
        Object o1 = new Object();
        Object o2 = new Object();
        Stack<Object> stack = new Stack<Object>();
        stack.push(o1);
        stack.push(o2);
        if (stack.search(o2) != 1) {
            TEST_Stack.fail("search() didn't return 1 for the latest pushed element");
        }
        if (stack.search(o1) != 2) {
            TEST_Stack.fail("search() didn't return 2 for the second latest pushed element");
        }
    }

    public void testSearch3() throws Exception {
        Object o1 = new Object();
        Object o2 = new Object();
        Stack<Object> stack = new Stack<Object>();
        stack.push(o1);
        stack.push(o1);
        stack.push(o2);
        if (stack.search(o1) != 2) {
            TEST_Stack.fail("search() didn't return the right position for an element being pushed() twice on the stack");
        }
    }

    public void testSearch4() throws Exception {
        search_test4_Element e11 = new search_test4_Element(1);
        search_test4_Element e12 = new search_test4_Element(1);
        search_test4_Element e2 = new search_test4_Element(2);
        Stack<search_test4_Element> stack = new Stack<search_test4_Element>();
        stack.push(e11);
        stack.push(e2);
        stack.push(e12);
        if (stack.search(e11) != 1) {
            TEST_Stack.fail("search failed - case #1 - see test code");
        }
        if (stack.search(e2) != 2) {
            TEST_Stack.fail("serach failed - case #2 - see test code)");
        }
    }

    public class search_test4_Element {
        private int id;

        search_test4_Element(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o instanceof search_test4_Element) {
                return ((search_test4_Element)o).id == this.id;
            }
            return false;
        }
    }
}

