/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LayoutUpdate
extends VisualTestImpl
implements ActionListener {
    private static final int ELEMENTSIZE = 20;
    private Panel testPanel;
    private BorderedLabel line2Left;
    private BorderedLabel line2Right;
    private BorderedLabel line4Left;
    private BorderedLabel line4Right;
    private BorderedLabel line6Left;
    private BorderedLabel line6Right;
    private BorderedLabel line8Left;
    private BorderedLabel line8Right;
    private BorderedLabel line10;
    private BorderedLabel line12;
    private BorderedLabel line14Mid;
    private BorderedLabel line16Mid;
    private Button paint18Left;
    private Button paint18Right;
    private BorderedLabel line18Left;
    private BorderedLabel line18Right;
    private Button paint20Right;
    private BorderedLabel line20Left;
    private BorderedLabel line20Right;
    private Button paint22;
    private BorderedLabel line22;
    private Button paint24Mid;
    private BorderedLabel line24Mid;

    public LayoutUpdate() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        Panel buttonsleft = new Panel(new GridLayout(12, 1));
        buttonsleft.add(new Label("two components with Display text", 1));
        Panel line2 = new Panel(new GridLayout(1, 2));
        this.line2Left = new BorderedLabel();
        line2.add(this.line2Left);
        this.line2Right = new BorderedLabel();
        line2.add(this.line2Right);
        buttonsleft.add(line2);
        buttonsleft.add(new Label("two components without Display text", 1));
        Panel line4 = new Panel(new GridLayout(1, 2));
        this.line4Left = new BorderedLabel();
        line4.add(this.line4Left);
        this.line4Right = new BorderedLabel();
        line4.add(this.line4Right);
        buttonsleft.add(line4);
        buttonsleft.add(new Label("First component with Display text", 1));
        buttonsleft.add(new Label("second without", 1));
        Panel line6 = new Panel(new GridLayout(1, 2));
        this.line6Left = new BorderedLabel();
        line6.add(this.line6Left);
        this.line6Right = new BorderedLabel();
        line6.add(this.line6Right);
        buttonsleft.add(line6);
        buttonsleft.add(new Label("First component without, ", 1));
        buttonsleft.add(new Label("second with Display text", 1));
        Panel line8 = new Panel(new GridLayout(1, 2));
        this.line8Left = new BorderedLabel();
        line8.add(this.line8Left);
        this.line8Right = new BorderedLabel();
        line8.add(this.line8Right);
        buttonsleft.add(line8);
        this.add((Component)buttonsleft, "West");
        Panel buttonsright = new Panel(new GridLayout(12, 1));
        buttonsright.add(new Label("one component, directly added", 1));
        buttonsright.add(new Label("with Display function", 1));
        this.line10 = new BorderedLabel();
        buttonsright.add(this.line10);
        buttonsright.add(new Label("one component, directly added", 1));
        buttonsright.add(new Label("without Display function", 1));
        this.line12 = new BorderedLabel();
        buttonsright.add(this.line12);
        buttonsright.add(new Label("Two labels", 1));
        buttonsright.add(new Label("a component, with Display function", 1));
        Panel line14 = new Panel(new GridLayout(1, 3));
        line14.add(new Label("Left label", 0));
        this.line14Mid = new BorderedLabel();
        line14.add(this.line14Mid);
        line14.add(new Label("Right label", 2));
        buttonsright.add(line14);
        buttonsright.add(new Label("Two labels", 1));
        buttonsright.add(new Label("a component, without Display function", 1));
        Panel line16 = new Panel(new GridLayout(1, 3));
        line16.add(new Label("Left label", 0));
        this.line16Mid = new BorderedLabel();
        line16.add(this.line16Mid);
        line16.add(new Label("Right label", 2));
        buttonsright.add(line16);
        this.add((Component)buttonsright, "East");
        Panel buttonsmid = new Panel(new GridLayout(12, 1));
        Panel line17 = new Panel(new GridLayout(1, 2));
        this.paint18Left = new Button("Paint left");
        this.paint18Left.addActionListener(this);
        line17.add(this.paint18Left);
        this.paint18Right = new Button("Paint right");
        this.paint18Right.addActionListener(this);
        line17.add(this.paint18Right);
        buttonsmid.add(line17);
        Panel line18 = new Panel(new GridLayout(1, 2));
        this.line18Left = new BorderedLabel();
        line18.add(this.line18Left);
        this.line18Right = new BorderedLabel();
        line18.add(this.line18Right);
        buttonsmid.add(line18);
        this.paint20Right = new Button("Paint line 20 right");
        this.paint20Right.addActionListener(this);
        buttonsmid.add(this.paint20Right);
        Panel line20 = new Panel(new GridLayout(1, 2));
        this.line20Left = new BorderedLabel();
        line20.add(this.line20Left);
        this.line20Right = new BorderedLabel();
        line20.add(this.line20Right);
        buttonsmid.add(line20);
        this.paint22 = new Button("Paint line 22");
        this.paint22.addActionListener(this);
        buttonsmid.add(this.paint22);
        this.line22 = new BorderedLabel();
        buttonsmid.add(this.line22);
        this.paint24Mid = new Button("Paint line 24 mid");
        this.paint24Mid.addActionListener(this);
        buttonsmid.add(this.paint24Mid);
        Panel line24 = new Panel(new GridLayout(1, 3));
        line24.add(new Label("Left label", 0));
        this.line24Mid = new BorderedLabel();
        line24.add(this.line24Mid);
        line24.add(new Label("Right label", 2));
        buttonsmid.add(line24);
        this.add((Component)buttonsmid, "Center");
        this.displayData();
    }

    public void displayData() {
        this.line2Left.setText("(line 2, left)");
        this.line2Right.setText("(line 2, right)");
        this.line6Left.setText("(line 6, left)");
        this.line8Right.setText("(line 8, right)");
        this.line10.setText("line10");
        this.line14Mid.setText("line14");
        this.line20Left.setText("(line 20, left)");
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.paint18Left) {
            this.line18Left.setText("18 left");
        } else if (source == this.paint18Right) {
            this.line18Right.setText("18 right");
        } else if (source == this.paint20Right) {
            this.line20Right.setText("20 right");
        } else if (source == this.paint22) {
            this.line22.setText("line 22");
        } else if (source == this.paint24Mid) {
            this.line24Mid.setText("24 mid");
        }
    }

    public String getHelpText() {
        return "A GridBagLayout test on the GridBag size calculation by weight:\nThe screen shows a central panel with 3x3 elements ranged using a GridBagLayout. Each element has a central square of20 x 20 pixels that shows its preferred size. \nYou can click an element to select it. The selected element will change color and displayed in the right panel. will appear its name, and weightX, weightY settings\nUsing the (+) and (-) buttons on the left panel you can change the preferred weights of the selected element. This forces the layout to change size. \n\nITEMS TO TEST:\n\n-> Overall grid weights: in the bottom area area watch the weightX and weightY of the selected element Compare to the overall weightX and weightY for the rows and columns and check that the overall weight is equal to the biggest value for the weights of all elements in that row/colomn.\n-> Division of the free widths: also regard the total width of each gridbag column and the 'free' width after subtracting the (uniform) element width and check that the total leftover width is devided amongst the columns proportional to their column weightX.\n-> Division of the free heights: just like above regard the total heights and free heights of each row and make sure that the leftover height is devided amongst the rows proportional to their row weightY.";
    }

    public void start(Panel p, boolean b) {
        this.displayData();
    }

    public void stop(Panel p) {
    }

    class BorderedLabel
    extends Component {
        private String text;

        public BorderedLabel() {
            this.setBackground(Color.lightGray);
            this.text = "";
        }

        private void setText(String newtext) {
            this.text = newtext;
            this.repaint();
        }

        private void setText(int newvalue) {
            this.text = Integer.toString(newvalue);
            this.repaint();
        }

        private void setText(double newvalue) {
            this.text = Double.toString(newvalue);
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(25, 12);
        }

        public Dimension getPreferredSize() {
            return new Dimension(25, 12);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            Dimension d = this.getSize();
            if (d.width > 0 && d.height > 0) {
                g.clearRect(1, 1, d.width - 2, d.height - 2);
                g.setColor(this.getForeground());
                g.drawRect(1, 1, d.width - 2, d.height - 2);
                g.drawString(this.text, 5, d.height / 2 + 3);
            }
        }
    }
}

