/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GridLayoutHorizontal
extends VisualTestImpl
implements ActionListener {
    private Button addTop;
    private Button removeAllTop;
    private Panel Top;
    private int topCount;
    private Button addMid;
    private Button removeAllMid;
    private Panel Mid;
    private int midCount;
    private Button addBottom;
    private Button removeAllBottom;
    private Panel Bottom;
    private int bottomCount;
    private List display;
    private int step = 16;
    private static final int ELEMENTS = 6;

    public GridLayoutHorizontal() {
        this.setLayout(new GridLayout(4, 1));
        Panel screentop = new Panel(new BorderLayout());
        screentop.setBackground(new Color(140, 140, 128));
        screentop.add((Component)new Label("GridLayout(1,1)", 1), "North");
        this.addTop = new Button("add one button");
        this.addTop.setBackground(new Color(140, 155, 128));
        this.addTop.addActionListener(this);
        screentop.add((Component)this.addTop, "West");
        this.removeAllTop = new Button("remove all buttons");
        this.removeAllTop.setBackground(new Color(155, 140, 128));
        this.removeAllTop.addActionListener(this);
        screentop.add((Component)this.removeAllTop, "East");
        this.Top = new Panel(new GridLayout(1, 1));
        this.Top.setBackground(new Color(155, 155, 128));
        screentop.add((Component)this.Top, "Center");
        this.add(screentop);
        Panel screenmid = new Panel(new BorderLayout());
        screenmid.setBackground(new Color(140, 128, 140));
        screenmid.add((Component)new Label("GridLayout(1,3)", 1), "North");
        this.addMid = new Button("add one button");
        this.addMid.setBackground(new Color(140, 128, 155));
        this.addMid.addActionListener(this);
        screenmid.add((Component)this.addMid, "West");
        this.removeAllMid = new Button("remove all buttons");
        this.removeAllMid.setBackground(new Color(155, 128, 140));
        this.removeAllMid.addActionListener(this);
        screenmid.add((Component)this.removeAllMid, "East");
        this.Mid = new Panel(new GridLayout(1, 3));
        this.Mid.setBackground(new Color(155, 128, 155));
        screenmid.add((Component)this.Mid, "Center");
        this.add(screenmid);
        Panel screenbottom = new Panel(new BorderLayout());
        screenbottom.setBackground(new Color(128, 140, 140));
        screenbottom.add((Component)new Label("GridLayout(1,9)", 1), "North");
        this.addBottom = new Button("add one button");
        this.addBottom.setBackground(new Color(128, 140, 155));
        this.addBottom.addActionListener(this);
        screenbottom.add((Component)this.addBottom, "West");
        this.removeAllBottom = new Button("remove all buttons");
        this.removeAllBottom.setBackground(new Color(128, 155, 140));
        this.removeAllBottom.addActionListener(this);
        screenbottom.add((Component)this.removeAllBottom, "East");
        this.Bottom = new Panel(new GridLayout(1, 9));
        this.Bottom.setBackground(new Color(128, 155, 155));
        screenbottom.add((Component)this.Bottom, "Center");
        this.add(screenbottom);
        this.display = new List();
        this.display.setBackground(new Color(155, 155, 155));
        this.display.add("Click on the add-button to add an element to the (1,x) layout");
        this.add(this.display);
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        if (source == this.addTop) {
            this.buildTopButton();
            this.Top.validate();
            this.displayTop("Added new element no." + this.topCount);
        } else if (source == this.removeAllTop) {
            this.Top.removeAll();
            this.Top.validate();
            this.displayTop("removed all elements");
            this.topCount = 0;
        } else if (source.getActionCommand() == "Top") {
            this.Top.remove(source);
            this.Top.validate();
            this.displayTop("removed element " + source.getName());
        } else if (source == this.addMid) {
            this.buildMidButton();
            this.Mid.validate();
            this.displayMid("Added new element no." + this.midCount);
        } else if (source == this.removeAllMid) {
            this.Mid.removeAll();
            this.Mid.validate();
            this.displayMid("removed all elements");
            this.midCount = 0;
        } else if (source.getActionCommand() == "Mid") {
            this.Mid.remove(source);
            this.Mid.validate();
            this.displayMid("removed element " + source.getName());
        } else if (source == this.addBottom) {
            this.buildBottomButton();
            this.Bottom.validate();
            this.displayBottom("Added new element no." + this.topCount);
        } else if (source == this.removeAllBottom) {
            this.Bottom.removeAll();
            this.Bottom.validate();
            this.displayBottom("removed all elements");
            this.bottomCount = 0;
        } else if (source.getActionCommand() == "Bottom") {
            this.Bottom.remove(source);
            this.Bottom.validate();
            this.displayBottom("removed element " + source.getName());
        }
    }

    private void buildTopButton() {
        ++this.topCount;
        Button b = new Button("<" + this.topCount + ">");
        b.setBackground(new Color(128, 155 + this.step * (this.topCount % 6), 128));
        b.setActionCommand("Top");
        b.addActionListener(this);
        this.Top.add(b);
    }

    private void buildMidButton() {
        ++this.midCount;
        Button b = new Button("<" + this.midCount + ">");
        b.setBackground(new Color(155 + this.step * (this.midCount % 6), 128, 128));
        b.setActionCommand("Mid");
        b.addActionListener(this);
        this.Mid.add(b);
    }

    private void buildBottomButton() {
        ++this.bottomCount;
        Button b = new Button("<" + this.bottomCount + ">");
        b.setBackground(new Color(128, 128, 155 + this.step * (this.bottomCount % 6)));
        b.setActionCommand("Bottom");
        b.addActionListener(this);
        this.Bottom.add(b);
    }

    private void displayTop(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add("Top gridlayout(1,1): " + this.Top.getComponentCount() + " elements =>" + message, 0);
    }

    private void displayMid(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add("Mid gridlayout(1,3): " + this.Mid.getComponentCount() + " elements =>" + message, 0);
    }

    private void displayBottom(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add("Bottom gridlayout(1,9): " + this.Bottom.getComponentCount() + " elements =>" + message, 0);
    }

    public String getHelpText() {
        return "A test to verify the horizontal component of Rudolph's GridLayour implementation\nAs GridLayout primarily looks at the vertical component of the grid and then adds as many columns as are needed to display all elements in the given number of lines: the 'c'- component of the GridLayout(r,c) constructor is pretty useless\nthis is all the more visible in an (1,c) Gridlayout with only one row\nThis tests shows three Gridlayouts, respectingly of form (1,1), (1,3) and (1,9). The buttons allow you to add new components to this row, remove them again and clear the whole row\nFOLLOWING THE DEFINITIONS OF A GRIDLAYOUT, REGARDLESS OF THE NUMBER OF COLUMS SPECIFIED, A LAYOUT WITH <n> COMPONENTS WILL SHOW ALL THESE <n> COMPONENTS IN A ROW AND EVERY COMPONENT WILL OCCUPY ONE <n>TH OF THE TOTAL SPACE AVAILABLE";
    }
}

