/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GridLayout
extends VisualTestImpl
implements ActionListener {
    private Button addLeft;
    private Button removeAllLeft;
    private Panel left;
    private int leftCount;
    private Button addRight;
    private Button removeAllRight;
    private Panel right;
    private int rightCount;
    private int step = 16;
    private static final int ELEMENTS = 6;

    public GridLayout() {
        int clear = 155;
        int darker = 155 - this.step;
        this.setBackground(new Color(128, clear, clear));
        this.setLayout(new BorderLayout());
        Panel addcommands = new Panel(new java.awt.GridLayout(1, 2));
        this.addLeft = new Button("add one button");
        this.addLeft.setBackground(new Color(128, darker, clear));
        this.addLeft.addActionListener(this);
        addcommands.add(this.addLeft);
        this.addRight = new Button("add one button");
        this.addRight.setBackground(new Color(128, clear, darker));
        this.addRight.addActionListener(this);
        addcommands.add(this.addRight);
        darker += this.step;
        this.add((Component)addcommands, "North");
        Panel screen = new Panel(new java.awt.GridLayout(1, 2));
        this.left = new Panel(new java.awt.GridLayout(6, 1));
        this.left.setBackground(new Color(128, 128, clear += this.step));
        this.buildLeftButton();
        screen.add(this.left);
        this.right = new Panel(new java.awt.GridLayout(6, 1));
        this.right.setBackground(new Color(128, clear, 128));
        this.buildRightButton();
        screen.add(this.right);
        this.add((Component)screen, "Center");
        Panel removecommands = new Panel(new java.awt.GridLayout(1, 2));
        this.removeAllLeft = new Button("remove all buttons");
        this.removeAllLeft.setBackground(new Color(128, darker += this.step, clear += this.step));
        this.removeAllLeft.addActionListener(this);
        removecommands.add(this.removeAllLeft);
        this.removeAllRight = new Button("remove all buttons");
        this.removeAllRight.setBackground(new Color(128, clear, darker));
        this.removeAllRight.addActionListener(this);
        removecommands.add(this.removeAllRight);
        this.add((Component)removecommands, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        if (source == this.addLeft) {
            this.buildLeftButton();
            this.left.validate();
        } else if (source == this.addRight) {
            this.buildRightButton();
            this.right.validate();
        } else if (source == this.removeAllLeft) {
            this.left.removeAll();
            this.left.validate();
        } else if (source == this.removeAllRight) {
            this.right.removeAll();
            this.right.validate();
        } else if (source.getActionCommand() == "LEFT") {
            this.left.remove(source);
            source = null;
            this.left.validate();
        } else if (source.getActionCommand() == "RIGHT") {
            this.right.remove(source);
            this.right.validate();
        }
    }

    private void buildLeftButton() {
        this.leftCount = this.left.getComponentCount();
        Button b = new Button("LEFT_" + this.leftCount + " (Click to remove)");
        b.setBackground(new Color(128, 128, 128 + this.step * (this.leftCount % 6)));
        b.setActionCommand("LEFT");
        b.setName("LEFT_" + this.leftCount);
        b.addActionListener(this);
        this.left.add(b);
    }

    private void buildRightButton() {
        this.rightCount = this.right.getComponentCount();
        Button b = new Button("Right_" + this.rightCount + " (Click to remove)");
        b.setBackground(new Color(128, 128 + this.step * (this.rightCount % 6), 128));
        b.setActionCommand("RIGHT");
        b.setName("Right_" + this.rightCount);
        b.addActionListener(this);
        this.right.add(b);
    }

    public String getHelpText() {
        return "A test to verify Rudolph's GridLayour implementation\nThe test shows a blue and a green Panel. above each Panel a button <add> allows you to add a button to that panel, below each panel a button <remove all> allows you to remove all buttons from that panel. On startup, every panel has one button\n\nitems to test:\n=> adding a button to a panel using the Container.add(component) function called by the <add> button\n=> removing a button from a panel using Container.remove(component) called by clicking that button\n=> removing all buttons from a panel using Container.removeAll() called by clicking <remove all> \n=> Each panel can contain 6 elements vertically. Adding a 7th element should force the display to appear in two rows while removing this element again should display the remaining elements in one row again";
    }
}

