/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.layout.GridBagLayoutPositions;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;

public class BorderLayoutPositions
extends GridBagLayoutPositions {
    public BorderLayoutPositions() {
        this.setBackground(Color.black);
        this.setForeground(Color.yellow);
        this.setLayout(new BorderLayout());
        Panel main = new Panel(new GridLayout(3, 2));
        Button a = this.locationButton("<A>(NORTH)", Color.red, "BorderLayout.NORTH added first using add()");
        Button b = this.locationButton("<B>(NORTH)", Color.green, "BorderLayout.NORTH, added second using add()");
        Button c = this.locationButton("<C>(EAST)", Color.blue, "BorderLayout.EAST, added third using add()");
        Button d = this.locationButton("<D>(EAST)", Color.yellow, "BorderLayout.EAST, added last using add()");
        Button title = this.locationButton("Reference layout add()", Color.black, "Layout built in sequence <A>,<B>,<C>,<D> using add()");
        main.add(this.buildLayout(title, SMOKE, new BorderLayout(), a, "North", b, "North", c, "East", d, "East"));
        a = this.locationButton("<A>(NORTH)", Color.red, "BorderLayout.NORTH, added first to last place in list using add(-1)");
        b = this.locationButton("<B>(NORTH)", Color.green, "BorderLayout.NORTH, added second to last place in list using add(-1)");
        c = this.locationButton("<C>(EAST)", Color.blue, "BorderLayout.EAST, added third to last place in list using add(-1)");
        d = this.locationButton("<D>(EAST)", Color.yellow, "BorderLayout.EAST, added last to last place in list using add()");
        title = this.locationButton("positioned default by add(-1)", Color.black, "Components added in sequence <A>,<B>,<C>,<D> using add(-1)");
        main.add(this.buildLayout(title, RUST, new BorderLayout(), a, "North", -1, b, "North", -1, c, "East", -1, d, "East", -1));
        a = this.locationButton("<A>(NORTH)", Color.red, "BorderLayout.NORTH, added last using add()");
        b = this.locationButton("<B>(NORTH)", Color.green, "BorderLayout.NORTH, added third using add()");
        c = this.locationButton("<C>(EAST)", Color.blue, "BorderLayout.EAST, added second using add()");
        d = this.locationButton("<D>(EAST)", Color.yellow, "BorderLayout.EAST, added first using add()");
        title = this.locationButton("Inverse layout", Color.black, "Layout built in sequence <D>,<C>,<B>,<A> using add()");
        main.add(this.buildLayout(title, RUST, new BorderLayout(), d, "East", c, "East", b, "North", a, "North"));
        a = this.locationButton("<A>(NORTH)", Color.red, "BorderLayout.NORTH, added first using add(0)");
        b = this.locationButton("<B>(NORTH)", Color.green, "BorderLayout.NORTH, added second to first place in list using add(0)");
        c = this.locationButton("<C>(EAST)", Color.blue, "BorderLayout.EAST, added third to first place in list using add(0)");
        d = this.locationButton("<D>(EAST)", Color.yellow, "BorderLayout.EAST, added fourth to first place in list using add(0)");
        title = this.locationButton("Positioned first by add(0)", Color.black, "Components added in sequence <A>,<B>,<C>,<D>/new added first in list using add(0)");
        main.add(this.buildLayout(title, SMOKE, new BorderLayout(), a, "North", 0, b, "North", 0, c, "East", 0, d, "East", 0));
        a = this.locationButton("<A>(NORTH)", Color.red, "BorderLayout.NORTH, added first using add()");
        b = this.locationButton("<B>(NORTH)", Color.green, "BorderLayout.NORTH, added second using add()");
        c = this.locationButton("<C>(EAST)", Color.blue, "BorderLayout.EAST, added fourth using add()");
        d = this.locationButton("<D>(EAST)", Color.yellow, "BorderLayout.EAST, added third by add() sequence");
        title = this.locationButton("<A>,<B>,<D>,<C> by adding order", Color.black, "Layout built in sequence <A>,<B>,<D>,<C> using add()");
        main.add(this.buildLayout(title, SMOKE, new BorderLayout(), a, "North", b, "North", d, "East", c, "East"));
        a = this.locationButton("<A>(NORTH)", Color.red, "BorderLayout.NORTH, added first to first place in list using add(0)");
        b = this.locationButton("<B>(NORTH)", Color.green, "BorderLayout.NORTH, added second to last place in list using add(-1)");
        c = this.locationButton("<C>(EAST)", Color.blue, "BorderLayout.EAST, added third to to last place in list first in row using add(-1)");
        d = this.locationButton("<D>(EAST)", Color.yellow, "BorderLayout.EAST, added fourth to third place in list using add(2)");
        title = this.locationButton("<D> third by add(2)", Color.black, "Components added in sequence <A>,<B>,<C>,<D> using add(2) to set <D> third in list");
        main.add(this.buildLayout(title, RUST, new BorderLayout(), a, "North", 0, b, "North", -1, c, "East", -1, d, "East", 2));
        this.add((Component)main, "Center");
        this.display = new List(2, false);
        this.display.setForeground(Color.white);
        this.display.add("Click on an item to get more info");
        this.add((Component)this.display, "South");
    }

    public String getHelpText() {
        return "A test to verify Rudolph's implementation of the Container.add(Component, GridBagConstraints, position) form in a BorderLayout :\n\nAs the aim of the BorderLayout is to glue a component to one of the component's borders, this layout only knows five elements:NORTH, SOUTH, EAST, WEST and CENTER. A new element can only be one of these and will be displayed on this element's location\nIf a new element is added to a location for which an element already exists, it replaces that element\n\nThis test shows three rows of two panels. All panels try to place their elements <A> and <B> to the NORTH location and their elements <C> and <D> in the EAST location. As always two elements will be assigned to the same location, the last one addedthrows the first out of the layout and takes its place\nAs in all other position tests, the elements are added in order <A>+<B>+<C>+<D>, order <D>+<C>+<B>+<A> and order <A>+<B>+<D>+<C>respectingly, the left side by changing the order in which the elements are added to the list (using add(element, constraints)), the right one by specifying the order in the add(element, constraints, order) form\n\nAS THE BORDERLAYOUT DISREGARDS THE POSITION IN FAVOR OF THE ORDER OF ADDING, THE TOPLEFT AND ALL RIGHT LAYOUTS SHOULD SHOW THE ELEMENTS<B> and <D> BECAUSE THEY WERE ADDED OVER THE PREVIOUS <A> AND <C>. THE MIDDLE LEFT AND BOTTOM LEFT LAYOUTS SHOULD SHOW THE ELEMENTSADDED LAST: <A>/<C> and <B>/<C> RESPECTINGLY";
    }
}

