/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.event.AWTEventDisplay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class WindowEventDisplay
extends AWTEventDisplay
implements WindowListener {
    protected int displayWidth;
    protected int displayHeight;

    public Dimension getMinimumSize() {
        return new Dimension(this.displayWidth, this.displayHeight);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.displayWidth, this.displayHeight);
    }

    public void windowActivated(WindowEvent evt) {
        this.message = "Window activated: " + WindowEventDisplay.displayWindowShortcut(evt);
        this.repaint();
    }

    public void windowDeactivated(WindowEvent evt) {
        this.message = "Window deactivated: " + WindowEventDisplay.displayWindowShortcut(evt);
        this.repaint();
    }

    public void windowIconified(WindowEvent evt) {
        this.message = "Window iconified: " + WindowEventDisplay.displayWindowShortcut(evt);
        this.repaint();
    }

    public void windowDeiconified(WindowEvent evt) {
        this.message = "Window de-iconified: " + WindowEventDisplay.displayWindowShortcut(evt);
        this.repaint();
    }

    public void windowOpened(WindowEvent evt) {
        this.message = "Window opened: " + WindowEventDisplay.displayWindowShortcut(evt);
        this.repaint();
    }

    public void windowClosing(WindowEvent evt) {
        this.message = "Window closing: " + WindowEventDisplay.displayWindowShortcut(evt);
        this.repaint();
    }

    public void windowClosed(WindowEvent evt) {
        this.message = "Window closed: " + WindowEventDisplay.displayWindowShortcut(evt);
        this.repaint();
    }

    public void update(Graphics g) {
        if (this.frame.width == 0) {
            this.frame.setSize(this.getSize().width - 2, this.getSize().height - 2);
            this.inside.setBounds(5, 5, this.getSize().width - 10, this.getSize().height - 10);
        }
        g.setColor(this.background);
        g.fillRect(1, 1, this.frame.width, this.frame.height);
        g.setColor(this.foreground);
        g.drawRect(this.inside.x, this.inside.y, this.inside.width, this.inside.height);
        g.drawString(this.message, 20, this.inside.height / 2 + 10);
    }

    public static String[] displayWindowEvent(WindowEvent evt) {
        int id;
        Object source = evt.getSource();
        String[] lines = new String[]{source == null ? "evt.getSource() == NULL" : (!(source instanceof Window) ? "non-window source = " + source : (((Component)source).getName() != null ? "getSource() = " + ((Component)source).getName() : "getSource() " + source)), (id = evt.getID()) == 205 ? "event <WINDOW_ACTIVATED>" : (id == 206 ? "event <WINDOW_DEACTIVATED>" : (id == 203 ? "event <WINDOW_ICONIFIED>" : (id == 204 ? "event <WINDOW_DEICONIFIED>" : (id == 200 ? "event <WINDOW_OPENED>" : (id == 201 ? "event <WINDOW_CLOSING>" : (id == 202 ? "event <WINDOW_CLOSED>" : "Unknown WindowEvent ID  (" + id + ')'))))))};
        return lines;
    }

    public static String displayWindowShortcut(WindowEvent evt) {
        Window source = evt.getWindow();
        String line = source == null ? "Source() == <NULL " : (source.getName() != null ? "From <" + source.getName() : "From <" + source);
        int id = evt.getID();
        line = id == 205 ? line + "> : event <WINDOW_ACTIVATED>" : (id == 206 ? line + "> : event <WINDOW_DEACTIVATED>" : (id == 203 ? line + "> : event <WINDOW_ICONIFIED>" : (id == 204 ? line + "> : event <WINDOW_DEICONIFIED>" : (id == 200 ? line + "> : event <WINDOW_OPENED>" : (id == 201 ? line + "> : event <WINDOW_CLOSING>" : (id == 202 ? line + "> : event <WINDOW_CLOSED>" : line + "> : Unknown WindowEvent ID  (" + id + ')'))))));
        return line;
    }

    public WindowEventDisplay(String firstmessage, Color back, Color text, int width, int height) {
        super(firstmessage, back, text);
        this.displayWidth = width;
        this.displayHeight = height;
    }

    public WindowEventDisplay(String firstmessage, Color back, Color text) {
        this(firstmessage, back, text, 70, 25);
    }

    public WindowEventDisplay(Color back, Color text) {
        this("Your WindowEvents displayed HERE", back, text, 70, 25);
    }
}

