/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TextEventTest
extends VisualTestImpl
implements ActionListener,
TextListener {
    private NamedTextField field;
    private NamedTextArea area;
    private Button append;
    private Button insert;
    private Button replace;
    private Button clearArea;
    private Button clearField;
    private int eventNo;
    private List display2;
    private int count = 1;
    static final String WELCOME = "Wellcome to Willy Wonka's wonderful chocolate factory";
    static final String OOMPA = " <Oompa-Loompa> ";

    public TextEventTest() {
        this.setForeground(new Color(80, 32, 32));
        this.setBackground(new Color(128, 64, 64));
        int step = 25;
        int red = 155;
        int shade = 100;
        this.setLayout(new BorderLayout());
        Panel center = new Panel(new BorderLayout());
        Panel texts = new Panel(new BorderLayout());
        this.area = new NamedTextArea("<TextArea>", WELCOME);
        this.area.addTextListener(this);
        this.area.setForeground(new Color(160, 128, 128));
        texts.add((Component)this.area, "Center");
        this.field = new NamedTextField("<TextField>", OOMPA + this.count);
        ++this.count;
        this.field.addTextListener(this);
        this.field.setBackground(new Color(red, shade, shade));
        texts.add((Component)this.field, "South");
        center.add((Component)texts, "Center");
        this.display2 = new List(3, false);
        this.display2.setBackground(new Color(red += step, shade, shade));
        Panel buttons = new Panel(new GridLayout(5, 1));
        this.append = new Button("append text");
        this.append.addActionListener(this);
        this.append.setBackground(new Color(red += step, shade, shade));
        buttons.add(this.append);
        this.insert = new Button("insert text");
        this.insert.addActionListener(this);
        this.insert.setBackground(new Color(red, shade += step, shade));
        buttons.add(this.insert);
        this.replace = new Button("replace selection");
        this.replace.addActionListener(this);
        this.replace.setBackground(new Color(red, shade += step, shade));
        buttons.add(this.replace);
        this.clearArea = new Button("clear area");
        this.clearArea.addActionListener(this);
        this.clearArea.setBackground(new Color(red, shade += step, shade));
        buttons.add(this.clearArea);
        this.clearField = new Button("Clear Field");
        this.clearField.addActionListener(this);
        this.clearField.setBackground(new Color(red, shade += step, shade));
        red += step;
        buttons.add(this.clearField);
        center.add((Component)buttons, "East");
        this.add((Component)center, "Center");
        this.display2.add("Your ActionEvents displayed HERE");
        this.add((Component)this.display2, "South");
        this.eventNo = 1;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.append) {
            this.area.append(OOMPA);
        } else if (source == this.insert) {
            this.area.insert(OOMPA, this.area.getCaretPosition());
        } else if (source == this.replace) {
            this.area.replaceRange(OOMPA, this.area.getSelectionStart(), this.area.getSelectionEnd());
        } else if (source == this.clearArea) {
            this.area.setText(WELCOME);
        } else if (source == this.clearField) {
            this.field.setText(OOMPA + this.count);
            ++this.count;
        }
    }

    public void textValueChanged(TextEvent evt) {
        if (this.display2.getItemCount() > 20) {
            this.display2.removeAll();
        }
        this.display2.add(this.displayTextEventShortcut(evt), 0);
    }

    public void displayMessage(String[] messagestrings) {
        if (this.display2.getItemCount() > 20) {
            this.display2.removeAll();
        }
        for (int i = messagestrings.length - 1; i >= 0; --i) {
            this.display2.add(messagestrings[i], 0);
        }
    }

    public String getHelpText() {
        return "The aim: test the throwing and the correct layout of TextEvents:\n\nThe test: The upper part of the screen consists out of a TextArea and a textField on the left, a series of buttons on the right The lower part shows a list that displays all the textEvents thrown by the field and the area\n\nItems to test:\n- Event generating and catching: both the TextArea aas well as the TextField should throw a TextEvent every time you change the text either by typing in it using the keyboard, or by using one of the buttons on the right.\n- Correct event data: The text event only has two items to check: the source (that must be either <TextArea>  or <TextField>  and the event ID which must be 900 = <TEXT_VALUE_CHANGED>\n\n Current items\n -------------\nAs Wonka doesn't support keyboard events yet, the only way TextEvents can be thrown is through changing the text using the buttons on the right:\n=> button [append text]: appends the text  <Oompa-Loompa>  to the end of the text area.\n=> button [insert text]: inserts the text  <Oompa-Loompa>  into the text area at cursoe position.\n=> button [replace text]: replaces the selected text of the text area by the line <Oompa-Loompa> \n=> button [Clear area]: sets the text of the text area back to Wellcome to Willy Wonka's wonderful chocolate factory\n=> button [Clear field]: sets the text of the text field to  <Oompa-Loompa>  + i where i is an increasing digit";
    }

    public String displayTextEventShortcut(TextEvent evt) {
        String line = "(event no " + this.eventNo + ")";
        ++this.eventNo;
        Object source = evt.getSource();
        line = source == null ? line + "Source() == NULL " : line + "Source() = " + source;
        int id = evt.getID();
        line = id == 900 ? line + " TEXT_VALUE_CHANGED (" + id + ")" : line + " unknown Id (" + id + ")";
        return line;
    }

    class NamedTextField
    extends TextField {
        private String name;

        public NamedTextField(String name, String text) {
            super(text);
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    class NamedTextArea
    extends TextArea {
        private String name;

        public NamedTextArea(String name, String text) {
            super(text, 5, 30, 1);
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

