/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import com.acunia.wonka.test.awt.event.MouseGeneratorComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseListenerTest
extends VisualTestImpl
implements MouseListener,
MouseMotionListener,
CollectsEvents {
    private List display;
    private MouseGeneratorComponent trigger1 = new MouseGeneratorComponent("<COPPER>", MouseGeneratorComponent.COPPER, MouseGeneratorComponent.DARKGREEN, this);
    private MouseGeneratorComponent trigger2;
    private MouseGeneratorComponent trigger3;

    public MouseListenerTest() {
        this.trigger1.addMouseListener(this.trigger1);
        this.trigger1.addMouseMotionListener(this.trigger1);
        this.trigger2 = new MouseGeneratorComponent("<DARK>", MouseGeneratorComponent.DARKSAND, MouseGeneratorComponent.DUSTGREEN, this);
        this.trigger2.addMouseListener(this.trigger2);
        this.trigger2.addMouseListener(this);
        this.trigger2.addMouseMotionListener(this);
        this.trigger2.addMouseMotionListener(this.trigger2);
        this.trigger3 = new MouseGeneratorComponent("<GREEN>", MouseGeneratorComponent.DARKGREEN, MouseGeneratorComponent.COPPER, this);
        this.trigger3.addMouseListener(this);
        this.trigger3.addMouseMotionListener(this);
        this.setLayout(new BorderLayout());
        Panel p = new Panel(new GridLayout(1, 3));
        p.add(this.trigger1);
        p.add(this.trigger2);
        p.add(this.trigger3);
        this.add((Component)p, "Center");
        this.display = new List(6, false);
        this.display.add("See your mouse events here");
        this.add((Component)this.display, "South");
    }

    public void mouseClicked(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "Test impl"));
    }

    public void mouseEntered(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "Test impl"));
    }

    public void mouseExited(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "Test impl"));
    }

    public void mousePressed(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "Test impl"));
    }

    public void mouseReleased(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "Test impl"));
    }

    public void mouseDragged(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "Test impl"));
    }

    public void mouseMoved(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "Test impl"));
    }

    public void displayMessage(String[] message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        if (message.length > 1) {
            this.display.add("..... " + message[1], 0);
        }
        if (message.length > 0) {
            this.display.add(message[0], 0);
        }
    }

    public String getHelpText() {
        return "The test displays three mouse event fields and a list. Click on any of the fields and see a display of the MouseEvent thrown appear in the list below.\n All mouse event fields have a MouseListener and therefor react to the mouse-pressed, mouse-released, mouse-clicked mouse-entered and mouse-exited. (remark that this do not include mouse-moved and mouse-dragged events that are catched by a MouseMotionListener.)\n The mouse events of the left field are catched and handledby the field itself.\n The events of the right field are directly dispatched to the main panel \n The events of the middle field are dispatched both to the main as well as to the field itself.\n\n Items to test:\n --------------\n=> The left field must react to all MouseListener events and show this events on the list as originating from  and catched by the left field\n=> The right field does not react to the mouse events, yet, the events will be displayed in the list as originating from that field and catched by the main testing class\n=> The middle field reacts to the mouse events, and displays eveny event twice: once as thrown and catched by the panel itself and once thrown by the panel and catched by the testing class\n\n current issues:\n --------------\n=> The middle panel does NOT react to mouse events and does NOT throw the <catched by the panel> event. appearantly sending the messages to the main disposes them before they reach the other classes\n=> No the MouseEvent's time is always 0 \n   (SEE THE OTHER ERRORS ON MOUSE-EVENTS IN THE MOUSE-EVENT TEST)\n\n\nPs: the behavior of the event fields to the panels is:" + this.trigger1.getHelpText();
    }

    public String toString() {
        return "MouseEventTest";
    }
}

