/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.KeyDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;

public class KeyMulticastTest
extends VisualTestImpl
implements ActionListener {
    private Button[] add;
    private Button[] remove;
    private EventKeyDisplay[] display;
    static final int LISTENERS = 7;

    public KeyMulticastTest() {
        int step = 13;
        int gray = 96;
        int darkgray = 48;
        this.setLayout(new GridLayout(7, 1));
        Panel[] row = new Panel[7];
        this.add = new Button[7];
        this.display = new EventKeyDisplay[7];
        this.remove = new Button[7];
        for (int i = 0; i < 7; ++i) {
            row[i] = new Panel(new BorderLayout());
            this.add[i] = new Button("Add");
            this.add[i].setBackground(new Color(gray, gray, gray));
            this.add[i].addActionListener(this);
            row[i].add((Component)this.add[i], "West");
            this.display[i] = new EventKeyDisplay("Listener_" + i, new Color(darkgray, darkgray, darkgray), new Color(gray, gray, gray + 16), Color.white);
            row[i].add((Component)this.display[i], "Center");
            this.remove[i] = new Button("remove");
            this.remove[i].setBackground(new Color(gray, gray, gray + 32));
            this.remove[i].addActionListener(this);
            row[i].add((Component)this.remove[i], "East");
            gray += step;
            darkgray += step;
            this.add(row[i]);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        boolean found = false;
        Object source = evt.getSource();
        for (int i = 0; i < 7 && !found; ++i) {
            int j;
            if (source == this.add[i]) {
                for (j = 0; j < 7; ++j) {
                    this.display[j].addKeyListener(this.display[i]);
                }
                this.display[i].displayMessage("<" + this.display[i] + "> Listener added. press <remove> to remove it again");
                found = true;
                continue;
            }
            if (source != this.remove[i]) continue;
            for (j = 0; j < 7; ++j) {
                this.display[j].removeKeyListener(this.display[i]);
            }
            this.display[i].displayMessage("<" + this.display[i] + "> Listener removed. press <add> to add it again");
            found = true;
        }
    }

    public String getHelpText() {
        return "The aim: test the throwing of KeyEvents through the AWTEventMulticaster functions:\n\nThe screen consists out of 7 KeyDisplay panels. Each of this panels is flanked by an <add> and a <remove> button.\nEvery time a key is pressed, released or typed, the panel that currently has the focus receives a key event. Every other panel that has a key listener for this panel will receive the key event through the listener interface functionality\n(A panel that has the focus is shown in a darker color)\n Using the Add/Delete buttons next to the panels you can add to that panel a KeyListener to all the panels on the screen, (including the selected panel itself)and delete it again. Upon receipt of a key event (through its listeners if added), that panel will display a short description of the event received\n.(Adding and removing is done by calls to the static AWTEventMulticaster.Add()and -remove() functions)\n\n Items to test : \n -------------\n => Pressing <add> for a panel and subsequently clicking on one of the panels. On the newly selected panel, as well as on all other previously selected panels, you should see a key event for the key typed and the panel currently active\n => Pressing <remove> for a panel and subsequently clicking a button you should see the KeyEvents no longer displayed on that panel, nor on the panels previously deselected, yet still displayed on the other panels still selected\n => Pressing <add> for the same panel over and over again, nothing should happen as a panel can not be added twice\n => Pressing <remove> for the same panel over and over again, or pressing <remove> on a panel to which no listener is added yet nothing should happen as a panel can not be removed twice\n \n ps. as the Add and remove routines have a slightly different algorithm for the first and second listener then for all subsequent listeners, specially check the behavior when \n    - adding the first panel, adding the second panel, adding the third panel\n    - removing the third-last panel, removing the second-last panel, removing the last panel\n    - giving a remove-command when no panels are selected\n Disclaimer : No panels were harmed during the making of this test.";
    }

    private class EventKeyDisplay
    extends KeyDisplay
    implements KeyListener,
    FocusListener {
        protected Color active;
        protected Color passive;
        protected String name;

        public EventKeyDisplay(String name, Color active, Color passive, Color text) {
            super(name, passive, text);
            this.active = active;
            this.passive = passive;
            this.name = name;
            this.addFocusListener(this);
        }

        public String toString() {
            return this.name;
        }

        public void focusGained(FocusEvent evt) {
            this.background = this.active;
            this.message = this.name + " (active)";
            this.repaint();
        }

        public void focusLost(FocusEvent evt) {
            this.background = this.passive;
            this.message = this.name + " (lost focus)";
            this.repaint();
        }
    }
}

