/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import com.acunia.wonka.test.awt.event.ItemDisplay;
import com.acunia.wonka.test.awt.event.MouseGeneratorComponent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ItemEventTest
extends VisualTestImpl
implements ItemListener,
CollectsEvents {
    private Checkbox box1;
    private Checkbox box2;
    private Checkbox radio1;
    private Checkbox radio2;
    private List single;
    private List multiple;
    private ItemGeneratorComponent itemGenerator;
    private ItemDisplay display1;
    private List display2;

    public ItemEventTest() {
        this.setForeground(new Color(108, 56, 32));
        this.setBackground(new Color(220, 220, 128));
        int step = 25;
        int red = 155;
        int green = 155;
        this.setLayout(new BorderLayout());
        this.display1 = new ItemDisplay(new Color(255, 255, 64), this.getForeground());
        this.setLayout(new BorderLayout());
        Panel boxpanel = new Panel(new GridLayout(2, 2));
        CheckboxGroup group = new CheckboxGroup();
        this.box1 = new Checkbox("box1", true);
        this.box1.addItemListener(this.display1);
        this.box1.addItemListener(this);
        this.box1.setBackground(new Color(red, green, 64));
        this.box2 = new Checkbox("box2", false);
        this.box2.addItemListener(this.display1);
        this.box2.addItemListener(this);
        this.box2.setBackground(new Color(red += step, green, 64));
        this.radio1 = new Checkbox("radio1", true, group);
        this.radio1.addItemListener(this.display1);
        this.radio1.addItemListener(this);
        this.radio1.setBackground(new Color(red, green += step, 64));
        this.radio2 = new Checkbox("radio2", false, group);
        this.radio2.addItemListener(this.display1);
        this.radio2.addItemListener(this);
        this.radio2.setBackground(new Color(red += step, green, 64));
        green += step;
        boxpanel.add(this.radio1);
        boxpanel.add(this.box1);
        boxpanel.add(this.radio2);
        boxpanel.add(this.box2);
        this.add((Component)boxpanel, "North");
        Panel center = new Panel(new BorderLayout());
        Panel lists = new Panel(new GridLayout(1, 3));
        this.single = new List(5, false);
        this.single.setBackground(new Color(140, 96, 170));
        this.single.addItemListener(this.display1);
        this.single.addItemListener(this);
        this.single.setBackground(new Color(red, green, 64));
        this.multiple = new List(5, true);
        this.multiple.setBackground(new Color(200, 112, 160));
        this.multiple.addItemListener(this.display1);
        this.multiple.addItemListener(this);
        this.multiple.setBackground(new Color(red += step, green, 64));
        green += step;
        for (int i = 1; i <= 6; ++i) {
            this.single.add("Single_" + i);
            this.multiple.add("Multiple" + i);
        }
        this.itemGenerator = new ItemGeneratorComponent("<PointItems>", new Color(red, green, 64), this.getForeground(), this);
        this.itemGenerator.addItemListener(this.display1);
        this.itemGenerator.addItemListener(this);
        lists.add(this.single);
        lists.add(this.itemGenerator);
        lists.add(this.multiple);
        center.add((Component)lists, "Center");
        center.add((Component)this.display1, "South");
        this.add((Component)center, "Center");
        this.display2 = new List(3, false);
        this.display2.add("Your ItemEvents displayed HERE");
        this.add((Component)this.display2, "South");
    }

    public void itemStateChanged(ItemEvent evt) {
        String[] messagestrings = ItemDisplay.displayItemEvent(evt);
        if (this.display2.getItemCount() > 40) {
            this.display2.removeAll();
        }
        for (int i = messagestrings.length - 1; i >= 0; --i) {
            this.display2.add(messagestrings[i], 0);
        }
    }

    public void displayMessage(String[] messagestrings) {
        if (this.display2.getItemCount() > 40) {
            this.display2.removeAll();
        }
        for (int i = messagestrings.length - 1; i >= 0; --i) {
            this.display2.add(messagestrings[i], 0);
        }
    }

    public String getHelpText() {
        return "The aim: test the throwing and the correct layout of ItemEvents:\n\nThe test: The upper part of the screen consists out of:\n- Two grouped checkboxes and two independent checkboxes\n- a single selection list and a multiple selection list\n- an implementation of the event field, overridden to throw an ItemEvents every time the mouse is pressed and every time it is released\nAll of this components have an item listener linked to both the lower list and the event panelThe lower part consists out of an event panel and a list both displaying the item events they get from the components above\n\nItems to test:\n- Event generating and catching: selecting or deselecting the checkboxes, selecting or deselecting an item on the lists,clicking or releasing a point on the grid.. all should throw an ItemEvent, displayed BOTH in the event panel as in the lower list\n- Correct event data: Every event is analysed and displayed in four lines in the lower list:\n   => first line: the object generating the event: the checkbox, list or event field clicked\n   => second line: the item of that list generating the event\n       ... for a Checkbox : this is the checkbox itself (Displayed on the screen is its label)\n       ... for a List : this is a String representing the text of the item currently clicked       ... for the event field : this is a Point giving the current mouse position in grid coordinates (you should see a text equal to Point.toString() for this particular point )   => third line: the state of that item: selected or deselected\n   => fourth line: the object list of all selected objects of that list\n       ... for a Checkbox : If selected, the list contains one element: the checkbox label, if not selected, the list is empty\n       ... for a single selection List : If an item is selected, it should contain this item's text string. If not it is empty\n       ... for a multiple selection List : The object list contains th string representation of all elements currently selected (when no item is selected, it is empty) \n       ... for the event field : By layout the list ALWAYS contains two Points instances representing the clicked Point both in grid as in screen coordinates \n- grouped checkbox: when selecting a new checkbox of the group, you also deselect the previous selection. Nevertheless you must only throw ONE event: that the new one is selected. Consequently a group NEVER throws an event where the state of the item is <deselected>. All group events need to display in line 3: <getStareChanged() = SELECTED> i\n- single selection lists: when selecting a new item, you automatically also deselect the old one. Yet, you only get one message telling that the new item is selected, without caring about the previous item now deselected. (the only way to get an item==<deselected> message is by clicking the selected item, deliberately deselecting it.)\n \n the Choice-class also throwing an ItemEvent is not covered here for reasons of it not being implemented yet in Wonka\n";
    }

    class ItemGeneratorComponent
    extends MouseGeneratorComponent
    implements MouseListener,
    ItemSelectable {
        private ItemListener multiListener;

        public ItemGeneratorComponent(String componentname, Color back, Color front, CollectsEvents parentinstance) {
            super(componentname, back, front, parentinstance);
            this.addMouseListener(this);
            this.multiListener = null;
        }

        public void addItemListener(ItemListener newlistener) {
            this.multiListener = AWTEventMulticaster.add(this.multiListener, newlistener);
        }

        public void removeItemListener(ItemListener oldlistener) {
            this.multiListener = AWTEventMulticaster.remove(this.multiListener, oldlistener);
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
            this.currentColor = this.currentColor > 0 ? --this.currentColor : colors.length - 1;
            this.repaint();
        }

        public void mousePressed(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            this.gridPoint.y = -this.gridPoint.y;
            this.connected = true;
            if (this.multiListener != null) {
                this.multiListener.itemStateChanged(new ItemEvent(this, 701, this.gridPoint, 1));
            }
            this.repaint();
        }

        public void mouseReleased(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            this.gridPoint.y = -this.gridPoint.y;
            this.connected = false;
            if (this.multiListener != null) {
                this.multiListener.itemStateChanged(new ItemEvent(this, 701, this.gridPoint, 2));
            }
            this.repaint();
        }

        public Object[] getSelectedObjects() {
            Object[] points = new Object[]{this.gridPoint, this.screenPoint};
            return points;
        }
    }
}

