/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.event.AWTEventDisplay;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ItemDisplay
extends AWTEventDisplay
implements ItemListener {
    public String getHelpText() {
        return "Displays a panel with a short text about the ItemEvent received.";
    }

    public void itemStateChanged(ItemEvent evt) {
        this.message = ItemDisplay.displayItemShortcut(evt);
        this.repaint();
    }

    public static String[] displayItemEvent(ItemEvent evt) {
        String[] lines = new String[4];
        Object source = evt.getSource();
        int id = evt.getID();
        if (source == null) {
            lines[0] = "evt.getSource() == NULL";
        } else if (source instanceof Checkbox) {
            lines[0] = "getSource()=" + ((Checkbox)source).getLabel();
            lines[0] = lines[0] + (id == 701 ? "ITEM_STATE_CHANGED " + id : "UNKNOWN " + id);
        } else {
            lines[0] = "getSource()= " + source;
            lines[0] = lines[0] + (id == 701 ? "ITEM_STATE_CHANGED " + id : "UNKNOWN " + id);
        }
        source = evt.getItem();
        lines[1] = source == null ? "getItem() == NULL" : (source instanceof Checkbox ? "getItem() = " + ((Checkbox)source).getLabel() : "getItem() = " + source.toString());
        lines[2] = evt.getStateChange() == 1 ? "getStateChange() = SELECTED (" + evt.getStateChange() + ')' : (evt.getStateChange() == 2 ? "getStateChange() = DESELECTED (" + evt.getStateChange() + ')' : "(unknown state: evt.getStateChange() = " + evt.getStateChange() + ')');
        ItemSelectable selectable = evt.getItemSelectable();
        if (selectable == null) {
            lines[3] = "getItemSelectable() == NULL";
        } else if (selectable.getSelectedObjects() == null) {
            lines[3] = "getItemSelectable():no selections";
        } else {
            Object[] selection = selectable.getSelectedObjects();
            lines[3] = "selections {";
            int i = 0;
            while (i < selection.length) {
                lines[3] = lines[3] + ' ' + selection[i];
                ++i;
            }
            lines[3] = lines[3] + '}';
        }
        return lines;
    }

    public static String displayItemShortcut(ItemEvent evt) {
        Object source = evt.getSource();
        String line = source == null ? "From Source NULL " : (source instanceof Checkbox ? "From " + ((Checkbox)source).getLabel() : "From " + source);
        source = evt.getItem();
        line = source == null ? line + ": Item NULL" : line + ": Item " + source.toString();
        int state = evt.getStateChange();
        line = state == 1 ? line + " SELECTED" : (state == 2 ? line + " DESELECTED" : line + "(unknown state)");
        return line;
    }

    public ItemDisplay(String startmessage, Color back, Color fore) {
        super(startmessage, back, fore);
    }

    public ItemDisplay(Color back, Color fore) {
        super("Your ItemEvents displayed HERE", back, fore);
    }
}

