/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.AdjustmentDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class AdjustmentMulticastTest
extends VisualTestImpl
implements ActionListener {
    private Button[] add;
    private Button[] remove;
    private AdjustmentDisplay[] display;
    private NamedScrollbar generator;
    static final int LISTENERS = 5;
    private Button ten;
    private Button fifty;
    private Button twofifty;

    public AdjustmentMulticastTest() {
        this.setForeground(new Color(108, 56, 32));
        this.setBackground(new Color(64, 160, 96));
        int step = 20;
        int green = 155 - step;
        int blue = 155 - step;
        this.setLayout(new BorderLayout());
        Panel width = new Panel(new GridLayout(1, 3));
        this.ten = new Button("width 10");
        this.ten.addActionListener(this);
        this.ten.setBackground(new Color(64, green, blue));
        width.add(this.ten);
        this.fifty = new Button("width 50");
        this.fifty.addActionListener(this);
        this.fifty.setBackground(new Color(64, green += step, blue));
        width.add(this.fifty);
        this.twofifty = new Button("width 250");
        this.twofifty.addActionListener(this);
        this.twofifty.setBackground(new Color(64, green, blue += step));
        width.add(this.twofifty);
        this.add((Component)width, "North");
        this.generator = new NamedScrollbar("<main scrollbar>", 10);
        this.add((Component)this.generator, "Center");
        Panel listeners = new Panel(new GridLayout(5, 1));
        Panel[] row = new Panel[5];
        this.add = new Button[5];
        this.display = new AdjustmentDisplay[5];
        this.remove = new Button[5];
        for (int i = 0; i < 5; ++i) {
            row[i] = new Panel(new BorderLayout());
            this.display[i] = new AdjustmentDisplay("Press <add> to add a listener to this panel", new Color(64, green, blue), new Color(128, 50, 80));
            row[i].add((Component)this.display[i], "Center");
            this.add[i] = new Button("Add");
            this.add[i].setBackground(new Color(64, green += step, blue));
            this.add[i].addActionListener(this);
            row[i].add((Component)this.add[i], "West");
            this.remove[i] = new Button("Remove");
            this.remove[i].setBackground(new Color(64, green, blue += step));
            this.remove[i].addActionListener(this);
            row[i].add((Component)this.remove[i], "East");
            listeners.add(row[i]);
        }
        this.add((Component)listeners, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        boolean found = false;
        Object source = evt.getSource();
        for (int i = 0; i < 5 && !found; ++i) {
            if (source == this.add[i]) {
                this.generator.addAdjustmentListener(this.display[i]);
                this.display[i].displayMessage("Listener added. press <remove> to remove it again");
                found = true;
                continue;
            }
            if (source != this.remove[i]) continue;
            this.generator.removeAdjustmentListener(this.display[i]);
            this.display[i].displayMessage("Listener removed. press <add> to add it again");
            found = true;
        }
        if (!found) {
            if (source == this.ten) {
                this.generator.setNewMaximum(10);
            } else if (source == this.fifty) {
                this.generator.setNewMaximum(50);
            } else if (source == this.twofifty) {
                this.generator.setNewMaximum(250);
            }
        }
    }

    public void displayMessage(String[] messagestrings) {
    }

    public String getHelpText() {
        return "The aim: test the throwing of AdjustmentEvents through the AWTEventMulticaster functions:\n\nThe screen consists out a central scrollbar, three <width> buttons and 5 AdjustmentDisplay panels. Each of this panels is flanked by an <add> and a <remove> button.\nThe scrollbar throws an AdjustmentEvent every time the position of its scrollbox is changed, either by pressing the up and down buttons, by clicking on the field before or after the scrollbox, or by dragging the box with the mouse.\n Using the width buttons, you can set the scrollbox' width to either ten, fifty or two hundred and fifty units. Using the <add> and <remove> buttons, you can add an ItemListener to a panel in order to get the ItemEvents displayed on that panel, or remove the listener from that panel again\n.(Adding and removing is done by calls to the static AWTEventMulticaster.Add()and -remove() functions\n)\n Items to test : \n -------------\n => Pressing <add> for a panel and subsequently clicking in the event field to check if the AdjustmentEvent is displayed on the newly selected panel, as well as on all other previously selected panels\n => Pressing <remove> for a panel and subsequently clicking in the event field to check if the event is no longer displayed on that panel, nor on the panels previously deselected, yet remains displayed on all other panels still selected\n => Pressing <add> for the same panel over and over again to see that the panel is not added twice\n => Pressing <remove> for the same panel over and over again, or pressing <remove> on a panel to which no listener is added yet to check that a panel is not removed twice\n => SPEED CHECK: set the scrollbar width to the maximum and drag the scrollbox with the mouse. Check if the response time to the continuous stream of AdjustmentEvents thrown through the Multicaster is not slowing down other operations \n ps. as the Add and remove routines have a slightly different algorithm for the first and second listener then for all subsequent listeners, specially check the behavior when \n    - adding the first panel, adding the second panel, adding the third panel\n    - removing the third-last panel, removing the second-last panel, removing the last panel\n    - giving a remove-command when no panels are selected";
    }

    class NamedScrollbar
    extends Scrollbar {
        String name;

        public NamedScrollbar(String name, int maximum) {
            super(0, 0, 5, 0, maximum);
            this.name = name;
        }

        public void setNewMaximum(int newmax) {
            int newval = this.getValue() * newmax / this.getMaximum();
            this.setValues(newval, 5, 0, newmax);
        }

        public String toString() {
            return this.name;
        }
    }
}

