/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.ActionDisplay;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import com.acunia.wonka.test.awt.event.MouseGeneratorComponent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ActionEventTest
extends VisualTestImpl
implements ActionListener,
CollectsEvents {
    private Button button1;
    private Button button2;
    private TextField text1;
    private TextField text2;
    private List single;
    private List multiple;
    private ActionGeneratorComponent actionGenerator;
    private ActionDisplay display1;
    private List display2;

    public ActionEventTest() {
        this.setForeground(new Color(80, 32, 40));
        this.setBackground(new Color(160, 64, 96));
        int step = 25;
        int red = 155;
        int blue = 155;
        this.display1 = new ActionDisplay(new Color(255, 64, 255), this.getForeground());
        this.setLayout(new BorderLayout());
        Panel boxpanel = new Panel(new GridLayout(2, 2));
        this.button1 = new Button("Button1");
        this.button1.addActionListener(this.display1);
        this.button1.addActionListener(this);
        this.button1.setBackground(new Color(red, 64, blue));
        this.button2 = new Button("Button2");
        this.button2.addActionListener(this.display1);
        this.button2.addActionListener(this);
        this.button2.setBackground(new Color(red += step, 64, blue));
        this.text1 = new TextField("textfield no.1");
        this.text1.addActionListener(this.display1);
        this.text1.addActionListener(this);
        this.text1.setBackground(new Color(red, 64, blue += step));
        this.text2 = new TextField("textfield no.2");
        this.text2.addActionListener(this.display1);
        this.text2.addActionListener(this);
        this.text2.setBackground(new Color(red += step, 64, blue));
        blue += step;
        boxpanel.add(this.button1);
        boxpanel.add(this.button2);
        boxpanel.add(this.text1);
        boxpanel.add(this.text2);
        this.add((Component)boxpanel, "North");
        Panel center = new Panel(new BorderLayout());
        Panel lists = new Panel(new GridLayout(1, 3));
        this.single = new List(5, false);
        this.single.setBackground(new Color(170, 140, 96));
        this.single.addActionListener(this.display1);
        this.single.addActionListener(this);
        this.single.setBackground(new Color(red, 64, blue));
        this.multiple = new List(5, true);
        this.multiple.setBackground(new Color(160, 200, 112));
        this.multiple.addActionListener(this.display1);
        this.multiple.addActionListener(this);
        this.multiple.setBackground(new Color(red += step, 64, blue));
        blue += step;
        for (int i = 1; i <= 6; ++i) {
            this.single.add("Single_" + i);
            this.multiple.add("Multiple" + i);
        }
        this.actionGenerator = new ActionGeneratorComponent("<PointActions>", new Color(red, 64, blue), this.getForeground(), this);
        this.actionGenerator.addActionListener(this.display1);
        this.actionGenerator.addActionListener(this);
        lists.add(this.single);
        lists.add(this.actionGenerator);
        lists.add(this.multiple);
        center.add((Component)lists, "Center");
        center.add((Component)this.display1, "South");
        this.add((Component)center, "Center");
        this.display2 = new List(3, false);
        this.display2.add("Your ActionEvents displayed HERE");
        this.add((Component)this.display2, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        String[] messagestrings = ActionDisplay.displayActionEvent(evt);
        if (this.display2.getItemCount() > 40) {
            this.display2.removeAll();
        }
        for (int i = messagestrings.length - 1; i >= 0; --i) {
            this.display2.add(messagestrings[i], 0);
        }
    }

    public void displayMessage(String[] messagestrings) {
        if (this.display2.getItemCount() > 40) {
            this.display2.removeAll();
        }
        for (int i = messagestrings.length - 1; i >= 0; --i) {
            this.display2.add(messagestrings[i], 0);
        }
    }

    public String getHelpText() {
        return "The aim: test the throwing and the correct layout of ActionEvents:\n\nThe test: The upper part of the screen consists out of:\n- Two buttons and two text fields\n- a single selection list and a multiple selection list\n- an implementation of the event field, overridden to throw an ActionEvent every time the mouse is pressed and every time it is released\nAll of this components have an item listener linked to both the lower list and the event panelThe lower part consists out of an event panel and a list both displaying the item events they get from the components above\n\nItems to test:\n- Event generating and catching: clicking the buttons, double-clicking an item on the lists, pressing <enter> on the textfields andpressing or releasing a point on the grid all should throw an ActionEvent, displayed BOTH in the event panel as well as in the lower list\n   => check if the events are thrown and are shown on both the panel and the list- Correct event data: Every event is analysed and displayed in three lines in the lower list:\n   => first line: the object generating the event: the button, textfield, list or event field clicked\n   Note that for the event field, the throwing object is NOT the field itself, but the point on the grid that is clicked/released\n   => first line: also the ID number of the event thrown\n THIS NUMBER MUST CORRESPOND TO <ActionEvent.ACTION_PERFORMED> == 1001\n   => second line: the event's action command (as per Actionevent.getActioncommand() )\n     this command must be a String of the following contents\n       ... for the Buttons: the button's label       ... for the TextFields: the field's current text       ... for the Lists: the name String of the item clicked       ... for the event field: the color of the field   => third line: event's modifier integer, and an indication wether this includes one or more of the following action modifiers: <shift-key>-pressed, <controll-key>-pressed, <alt-key>-pressed and/or <meta-key>-pressed\n\n Current items\n -------------\nAs Wonka doesn't support keyboard events yet, the textfields can't throw ActionEvents.\nFor the same reason, the modifier value will always be <0 = no key pressed>\n Ps: The MenuItem, that also should throw an ActionEvent when clicked id not covered in this test, for reason of it not being implemented in Wonka yet.";
    }

    class ActionGeneratorComponent
    extends MouseGeneratorComponent
    implements MouseListener {
        transient ActionListener multiListener;

        public ActionGeneratorComponent(String componentname, Color back, Color front, CollectsEvents parentinstance) {
            super(componentname, back, front, parentinstance);
            this.addMouseListener(this);
            this.multiListener = null;
        }

        public void addActionListener(ActionListener newlistener) {
            this.multiListener = AWTEventMulticaster.add(this.multiListener, newlistener);
        }

        public void removeActionListener(ActionListener oldlistener) {
            this.multiListener = AWTEventMulticaster.remove(this.multiListener, oldlistener);
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
            this.currentColor = this.currentColor > 0 ? --this.currentColor : colors.length - 1;
            this.repaint();
        }

        public void mousePressed(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            this.gridPoint.y = -this.gridPoint.y;
            this.connected = true;
            if (this.multiListener != null) {
                this.multiListener.actionPerformed(new ActionEvent(this.gridPoint, 1001, colornames[this.currentColor]));
            }
            this.repaint();
        }

        public void mouseReleased(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            this.gridPoint.y = -this.gridPoint.y;
            this.connected = false;
            if (this.multiListener != null) {
                this.multiListener.actionPerformed(new ActionEvent(this.gridPoint, 1001, colornames[this.currentColor]));
            }
            this.repaint();
        }
    }
}

