/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Window;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class WindowTest1
extends VisualTestImpl {
    StatusLabel status;
    char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public WindowTest1() {
        this.setLayout(new BorderLayout());
        Panel p = new Panel(new GridLayout(5, 5));
        for (int i = 0; i < this.chars.length; ++i) {
            Label l = new Label(new Character(this.chars[i]).toString(), 1);
            l.addMouseListener(new MouseHandler(l));
            p.add(l);
        }
        this.add((Component)p, "Center");
        this.status = new StatusLabel("status: no messages");
        this.add((Component)this.status, "South");
    }

    public String getHelpText() {
        return "bwa! hah!";
    }

    class PopupWindow
    extends Window {
        final Font f = new Font("Courier", 0, 40);
        static final int w = 50;
        static final int h = 50;
        Label l;

        PopupWindow(Frame frame, Label l) {
            super(frame);
            Point p = l.getLocationOnScreen();
            this.l = l;
            this.setSize(50, 50);
            this.setLocation(p.x, p.y);
            this.setVisible(true);
        }

        public void paint(Graphics g) {
            System.out.println("label " + this.l);
            g.setColor(Color.red);
            g.setFont(this.f);
            FontMetrics fm = g.getFontMetrics();
            g.drawRect(0, 0, 49, 49);
            g.drawString(this.l.getText(), (50 - fm.stringWidth(this.l.getText())) / 2, 50 - (fm.getHeight() - fm.getAscent() / 2));
        }
    }

    class StatusLabel
    extends Label {
        StatusLabel(String string) {
            super(string);
        }

        public void setText(String string) {
            super.setText(string);
            System.out.println(string);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        PopupWindow pw;
        Label l;

        MouseHandler(Label l) {
            this.l = l;
        }

        public void mousePressed(MouseEvent event) {
            Label l = (Label)event.getSource();
            WindowTest1.this.status.setText("pressed mouse: " + l);
            this.pw = new PopupWindow(WindowTest1.this.vt.getFrame(), l);
            this.pw.addWindowListener(new WindowHandler());
        }

        public void mouseReleased(MouseEvent event) {
            Label l = (Label)event.getSource();
            WindowTest1.this.status.setText("released mouse: " + l);
            this.pw.dispose();
        }
    }

    class WindowHandler
    implements WindowListener {
        WindowHandler() {
        }

        public void windowOpened(WindowEvent event) {
            WindowTest1.this.status.setText("status: window opened");
        }

        public void windowClosing(WindowEvent event) {
            WindowTest1.this.status.setText("status: window closing");
        }

        public void windowClosed(WindowEvent event) {
            WindowTest1.this.status.setText("status: window closed");
        }

        public void windowIconified(WindowEvent event) {
            WindowTest1.this.status.setText("status: window iconified");
        }

        public void windowDeiconified(WindowEvent event) {
            WindowTest1.this.status.setText("status: window deiconified");
        }

        public void windowActivated(WindowEvent event) {
            WindowTest1.this.status.setText("status: window activated");
        }

        public void windowDeactivated(WindowEvent event) {
            WindowTest1.this.status.setText("status: window deactivated");
        }
    }
}

