/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt;

import com.acunia.wonka.test.awt.VTELogger;
import com.acunia.wonka.test.awt.VisualTest;
import com.acunia.wonka.test.awt.VisualTestEngine;
import java.awt.Label;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimerThread
implements Runnable,
MouseListener {
    private static final long MAX_TIME = 600000L;
    private static final long MIN_TIME = 10000L;
    private long report_interval;
    private VisualTestEngine vte;
    private Label info;
    private boolean stop;
    private long total;
    private boolean show_memory;
    private long lastLog;
    private long starttime;

    public void mouseClicked(MouseEvent event) {
        this.show_memory = 1 - this.show_memory;
        this.info.invalidate();
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void stop() {
        this.stop = true;
    }

    private final String status() {
        String msg = "TimerThread autorun status: \n";
        msg = msg + "\tcompleted " + this.vte.runCount + " runs in ";
        long millis = System.currentTimeMillis() - this.starttime;
        msg = msg + millis + " ms = ";
        int sex = (int)(millis / 1000L);
        int seconds = sex % 60;
        int minutes = (sex - seconds) / 60 % 60;
        int hours = (sex - seconds - minutes * 60) / 3600 % 24;
        int days = sex / 3600 / 24;
        if (days > 0) {
            msg = msg + days + " days, ";
        }
        if (hours > 0) {
            msg = msg + hours + " hours, ";
        }
        if (minutes > 0) {
            msg = msg + minutes + " minutes, ";
        }
        msg = msg + seconds + " seconds.\n";
        msg = msg + "\tcurrently testing " + this.vte.getCurrentTest();
        return msg;
    }

    public void run() {
        this.starttime = System.currentTimeMillis();
        while (!this.stop) {
            try {
                Thread.sleep(500L);
                long free = Runtime.getRuntime().freeMemory();
                String stats = this.show_memory ? "memory: " + (this.total - free) + " / " + this.total + " bytes" : "round trip time: " + this.vte.getRoundTrip() + " ms";
                this.info.setText(stats);
                this.info.invalidate();
                if (!this.vte.autorun) continue;
                long time = System.currentTimeMillis();
                if (time > this.lastLog + this.report_interval) {
                    VisualTest vt = this.vte.getCurrentTest();
                    if (vt != null) {
                        this.vte.log(this.status() + "\n\t" + stats, vt);
                    }
                    this.lastLog = time;
                }
                this.setInterval(free);
            }
            catch (Exception e) {
                e.printStackTrace();
                VTELogger.reportException("TimerThread: exception occured", e, true);
            }
        }
    }

    private final void setInterval(long free) {
        float factor = (float)free / (float)this.total;
        if (factor > 0.6f) {
            this.report_interval = 600000L;
        } else {
            this.report_interval = (int)((1.0f + factor) * factor * factor * factor * 600000.0f);
            if (this.report_interval < 10000L) {
                this.report_interval = 10000L;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.report_interval = 600000L;
        this.stop = false;
        this.total = Runtime.getRuntime().totalMemory();
        this.show_memory = true;
    }

    public TimerThread(VisualTestEngine vte, Label i, ThreadGroup tg) {
        this.this();
        this.vte = vte;
        this.info = i;
        this.info.addMouseListener(this);
        Thread t = new Thread(tg, this, "VisualTestEngine Timer Thread");
        t.setPriority(8);
        t.start();
    }
}

