/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Rectangle;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class RectangleContains
extends VisualTestImpl
implements MouseListener,
MouseMotionListener {
    Rectangle target;
    Rectangle surround;
    Rectangle bounds;
    Point lastClick;
    boolean inside;

    public RectangleContains() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.target = new Rectangle();
        this.surround = new Rectangle();
        this.bounds = new Rectangle();
        this.lastClick = new Point();
        this.inside = false;
    }

    public String getHelpText() {
        return "Tests the functions Rectangle.Contains(Point), Rectangle.contains(Rectangle), Rectangle.translate(dx,dy) and Rectangle.add(Point)\n\nOn startup, the screen shows a blue field and a green rectangle with a white border. Click and drag the mouse and compare the responses on the screen to the expected behavior : \n => Rectangle.contains(Point): when pressing the mouse button inside the rectangle, the rectangle should change color (to red)\n => Rectangle.translate(dx,dy): when pressing the mouse button inside the rectangle and then dragging it, the rectangle should follow the movements of the mouse.\n => Rectangle.contains(Rectangle): On correct behavior of this function, it should be impossible to drag the rectangle out of the blue field\n => Rectangle.add(Point): when pressing the mouse button outside of the rectangle, the white frame will be enlarged so that it contains the mouse position. Dragging the mouse, the frame will grow continuously to keep the mouse inside. (Note that it will only grow, not schrink)";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public String getLogInfo(Panel p, boolean b) {
        return "no logging info !";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public void showTest() {
    }

    public void hideTest() {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (this.target.contains(event.getPoint())) {
            this.inside = true;
            this.lastClick.setLocation(event.getPoint());
        } else {
            this.surround.add(event.getPoint());
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent event) {
        if (this.bounds.contains(this.target)) {
            this.surround.setBounds(this.target);
        } else {
            this.target.setBounds(this.surround);
        }
        this.inside = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent event) {
        if (this.inside) {
            this.target.translate(event.getX() - this.lastClick.x, event.getY() - this.lastClick.y);
            if (this.bounds.contains(this.target)) {
                this.surround.setBounds(this.target);
                this.lastClick.setLocation(event.getPoint());
            } else {
                this.target.setBounds(this.surround);
            }
            this.repaint();
        } else {
            this.surround.add(event.getPoint());
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void update(Graphics g) {
        if (this.bounds.width == 0) {
            this.bounds.setBounds(5, 5, this.getSize().width - 10, this.getSize().height - 10);
            this.target.setBounds(5 + 2 * this.bounds.width / 5, 5 + 2 * this.bounds.height / 5, this.bounds.width / 5, this.bounds.height / 5);
            this.surround.setBounds(this.target);
        }
        g.setColor(Color.blue);
        g.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        g.setColor(this.inside ? Color.red : Color.green);
        g.fillRect(this.target.x, this.target.y, this.target.width, this.target.height);
        g.setColor(Color.white);
        g.drawRect(this.surround.x, this.surround.y, this.surround.width, this.surround.height);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public static void main(String[] args) {
        new RectangleContains();
    }
}

