/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.List;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Writer;

public class ReplaceListTest
extends VisualTestImpl
implements ActionListener {
    private List redList;
    private List blueList;
    private Button toRed;
    private Button toBlue;
    private List display;
    private String logString;

    public ReplaceListTest() {
        this.setBackground(new Color(225, 225, 64));
        this.setLayout(new BorderLayout());
        Panel main = new Panel(new GridLayout(1, 2));
        this.redList = new List(7, false);
        this.blueList = new List(7, false);
        this.redList.setBackground(new Color(255, 128, 128));
        this.blueList.setBackground(new Color(128, 128, 255));
        for (int i = 1; i <= 10; ++i) {
            this.redList.add("Red list item No." + i);
            this.blueList.add("BLUE LIST ITEM NUMBER " + i);
        }
        main.add(this.redList);
        main.add(this.blueList);
        this.add((Component)main, "Center");
        Panel buttons = new Panel(new GridLayout(1, 2));
        this.toBlue = new Button("Copy to blue ==>");
        this.toBlue.setBackground(new Color(192, 64, 64));
        this.toBlue.addActionListener(this);
        this.toRed = new Button("<== Copy to red");
        this.toRed.setBackground(new Color(64, 64, 192));
        this.toRed.addActionListener(this);
        buttons.add(this.toBlue);
        buttons.add(this.toRed);
        this.add((Component)buttons, "North");
        this.display = new List(3, false);
        this.display.add("click on the copy button of a list");
        this.display.add("to copy the selected item of this list");
        this.display.add("over the selected item of the other list");
        this.add((Component)this.display, "South");
        this.logString = new String("Logging messages from List.ReplaceListTest\n");
    }

    public void actionPerformed(ActionEvent evt) {
        int redpos = this.redList.getSelectedIndex();
        String redselect = this.redList.getSelectedItem();
        int bluepos = this.blueList.getSelectedIndex();
        String blueselect = this.blueList.getSelectedItem();
        if (evt.getSource() == this.toBlue) {
            if (redselect == null) {
                this.displayMessage("FAIL: no red selection to copy, select one first");
            } else {
                this.displayMessage("Blue selection = <" + blueselect + "> at position" + bluepos);
                this.displayMessage("Red selection = <" + redselect + "> at position" + redpos);
                this.blueList.replaceItem(redselect, bluepos);
            }
            this.displayMessage("Replacing blue selection by red selection");
        } else {
            if (blueselect == null) {
                this.displayMessage("FAIL: no blue selection to copy, select one first");
            } else {
                this.displayMessage("Red selection = <" + redselect + "> at position" + redpos);
                this.displayMessage("Blue selection = <" + blueselect + "> at position" + bluepos);
                this.redList.replaceItem(blueselect, redpos);
            }
            this.displayMessage("Replacing red selection by blue selection");
        }
    }

    private void displayMessage(String message) {
        if (this.display.getItemCount() > 20) {
            this.display.removeAll();
        }
        this.display.add(message, 0);
        this.logString = this.logString + message + "\n";
    }

    public Panel getPanel() {
        return this;
    }

    public String getTitle() {
        return "ListTest : single selections";
    }

    public String getHelpText() {
        return "A test on replacing a list element by another using List.replaceItem(String newitem, int pos).\nThe test shows a red list and a blue list with a red and blue <copy> button on top\nPressing the red button replaced the selected element of the blue lidt with that of the red list and vice versa";
    }

    public void log(Panel p, Writer w) throws IOException {
        w.write(this.logString);
        this.logString = "";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }
}

