/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageObserver;

public class ImageObserverTest
extends VisualTestImpl
implements ActionListener,
ItemListener {
    Button load;
    Button checkWidth;
    Button prepareImage;
    Button resizeImage;
    Button checkImage;
    Button redrawImage;
    Checkbox toCanvas;
    Checkbox toMain;
    Checkbox toList;
    Checkbox toNull;
    ImageComponent canvas;
    String imagename;
    Image image;
    ImageObserver observer;
    ImageList display;

    public ImageObserverTest() {
        this.setLayout(new BorderLayout());
        this.display = new ImageList();
        this.display.add("Observer ImageUpdate() dispayed here");
        this.add((Component)this.display, "South");
        this.canvas = new ImageComponent();
        this.observer = this.canvas;
        this.add((Component)this.canvas, "Center");
        Panel actions = new Panel(new GridLayout(10, 1));
        this.load = new Button("(re)load image");
        this.load.addActionListener(this);
        actions.add(this.load);
        this.prepareImage = new Button("prepare image");
        this.prepareImage.addActionListener(this);
        actions.add(this.prepareImage);
        this.resizeImage = new Button("resize image");
        this.resizeImage.addActionListener(this);
        actions.add(this.resizeImage);
        this.checkWidth = new Button("get width");
        this.checkWidth.addActionListener(this);
        actions.add(this.checkWidth);
        this.checkImage = new Button("check image");
        this.checkImage.addActionListener(this);
        actions.add(this.checkImage);
        this.redrawImage = new Button("redraw");
        this.redrawImage.addActionListener(this);
        actions.add(this.redrawImage);
        CheckboxGroup g = new CheckboxGroup();
        this.toMain = new Checkbox("Observer to main ", false, g);
        this.toMain.addItemListener(this);
        actions.add(this.toMain);
        this.toCanvas = new Checkbox("Observer to canvas", true, g);
        this.toCanvas.addItemListener(this);
        actions.add(this.toCanvas);
        this.toList = new Checkbox("Observer to display List", false, g);
        this.toList.addItemListener(this);
        actions.add(this.toList);
        this.toNull = new Checkbox("Observer to null", false, g);
        this.toNull.addItemListener(this);
        actions.add(this.toNull);
        this.add((Component)actions, "East");
        String path = System.getProperty("property.path", "/test");
        this.imagename = path + "/lena1.png";
        this.image = null;
        this.show();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.load) {
            this.image = Toolkit.getDefaultToolkit().getImage(this.imagename);
            this.canvas.setImage(this.image);
            this.printData("reloaded image <" + this.imagename + ">");
        } else if (source == this.checkWidth && this.image != null) {
            this.printData("image.getwidth() returns " + this.image.getWidth(this.observer));
        } else if (source == this.prepareImage && this.image != null) {
            this.printData("prepareImage() returns " + this.canvas.prepareImage(this.image, this.observer));
        } else if (source == this.resizeImage && this.image != null) {
            int width = this.image.getWidth(this.observer);
            int height = this.image.getHeight(this.observer);
            if (width > 2 && height > 2) {
                this.image = this.image.getScaledInstance(width /= 2, height /= 2, 1);
                this.printData("rescaled image to new size (" + width + ", " + height + ")");
                this.canvas.setImage(this.image);
            } else {
                this.printData("rescaling image (" + width + ", " + height + "): image too small to rescale any further");
            }
        } else if (source == this.checkImage && this.image != null) {
            int check = this.canvas.checkImage(this.image, this.observer);
            this.printData("checkImage() returns " + check, check);
        } else if (source == this.redrawImage) {
            this.printData("repainting image <" + this.imagename + ">");
            this.canvas.repaint();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.toCanvas) {
            this.printData("ImageObserver is the image canvas");
            this.observer = this.canvas;
        } else if (source == this.toMain) {
            this.printData("ImageObserver is main application");
            this.observer = this;
        } else if (source == this.toList) {
            this.printData("ImageObserver is display list");
            this.observer = this.display;
        } else if (source == this.toNull) {
            this.printData("ImageObserver is <null>");
            this.observer = null;
        }
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        boolean result = super.imageUpdate(img, flags, x, y, w, h);
        this.printData("main application: imageUpdate(x=" + x + ",y=" + y + ",w=" + w + ",h=" + h + ") returns " + result, flags);
        return result;
    }

    private void printData(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        System.out.println(text);
        this.display.add(text, 0);
    }

    private void printData(String line1, int line2) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        String text = "Flags: ";
        if ((line2 & 0x40) > 0) {
            text = text + "<ERROR> ";
        }
        if ((line2 & 0x80) > 0) {
            text = text + "<ABORT> ";
        }
        if ((line2 & 1) > 0) {
            text = text + "<WIDTH> ";
        }
        if ((line2 & 2) > 0) {
            text = text + "<HEIGHT> ";
        }
        if ((line2 & 4) > 0) {
            text = text + "<PROPERTIES> ";
        }
        if ((line2 & 8) > 0) {
            text = text + "<SOMEBITS> ";
        }
        if ((line2 & 0x10) > 0) {
            text = text + "<FRAMEBITS> ";
        }
        if ((line2 & 0x20) > 0) {
            text = text + "<ALLBITS> ";
        }
        System.out.println(line1);
        System.out.println(text);
        this.display.add(text, 0);
        this.display.add(line1, 0);
    }

    public String getHelpText() {
        return "Test on the throwing of imageUpdate-functions to an ImageObserver for png-images loaded from file:\nThe screen consists out of a display area, a message list and a number of buttons. Clicking one of the buttons triggers the manipulation of an Image object and shows on the list all imageUpdate-functions received by the ImageObserver selected\nThe button options are:\n-> build image: Loads a given png-file (lena1.png) and builds an Image with its data (it isn't shown yet however, this is done by the 'repaint()' button)\n-> resize image: constructs a new image out of the current one by rescaling it to half the size (calling Image.getScaledInstance())\n-> prepare image: sends a call Component.PrepareImage(Image, ImageObserver) to prepare the Image for display and maps all imageUpdate calls to the given ImageObserver\n-> get width: checks for the curent Image width (by calling Image.getWidth(ImageObserver)  ) and maps all imageUpdate calls to the given ImageObserver\n-> Check image: checks for the status of the curent Image (by calling Component.checkImage(Image, ImageObserver)  ) and maps all imageUpdate calls to the given ImageObserver\n-> repaint image: sends a Component.repaint() signal that triggers a painting of the component (using Graphics.drawImage(Image, position, ImageObserver) All imageUpdate calls are mapped to the given ImageObserver\n\n By means of the radiobuttons, you can change the ImageObserver desired to: \n-> the main application itself\n-> the image window\n-> the list\n-> NULL";
    }

    class ImageList
    extends List {
        public ImageList() {
            super(3, true);
        }

        public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
            boolean result = super.imageUpdate(img, flags, x, y, w, h);
            ImageObserverTest.this.printData("Display list: imageUpdate(x=" + x + ",y=" + y + ",w=" + w + ",h=" + h + ") returns " + result, flags);
            return result;
        }
    }

    class ImageComponent
    extends Component {
        Image componentImage = null;

        public void setImage(Image img) {
            this.componentImage = img;
        }

        public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
            boolean result = super.imageUpdate(img, flags, x, y, w, h);
            ImageObserverTest.this.printData("Image panel: imageUpdate(x=" + x + ",y=" + y + ",w=" + w + ",h=" + h + ") returns " + result, flags);
            return result;
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (this.componentImage != null) {
                ImageObserverTest.this.printData("repainting component Image size = (" + this.componentImage.getWidth(ImageObserverTest.this.observer) + ", " + this.componentImage.getHeight(ImageObserverTest.this.observer) + ")");
                g.clearRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.drawImage(this.componentImage, 0, 0, ImageObserverTest.this.observer);
            }
        }
    }
}

