/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.GridBagLayout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class MinimumSizeGrid
extends VisualTestImpl {
    private static final int LAMPWIDTH = 30;
    private static final int LAMPHEIGHT = 30;
    private List display;

    public MinimumSizeGrid() {
        int gray = 96;
        this.setLayout(new BorderLayout());
        this.setForeground(Color.white);
        this.setBackground(new Color(gray, gray, gray));
        gray += 32;
        this.display = new List(2, false);
        this.display.add("Observer ImageUpdate() dispayed here");
        this.add((Component)this.display, "South");
        Panel panels = new Panel(new GridLayout(1, 2));
        Panel left = new Panel(new GridLayout(1, 4));
        left.setBackground(Color.black);
        Panel right = new Panel(new GridLayout(4, 1));
        right.setBackground(Color.white);
        TrafficLightComponent tnone = new TrafficLightComponent("Vertical GridBagLayout, No size definitions", new Color(gray, gray, gray));
        RainbowComponent rnone = new RainbowComponent("Horizontal GridBagLayout, No size definitions", new Color(gray, gray, gray));
        left.add(tnone);
        right.add(rnone);
        MinTrafficLight tmin = new MinTrafficLight("Vertical GridBagLayout with defined minimum size", new Color(gray += 32, gray, gray));
        MinRainbow rmin = new MinRainbow("Horizontal GridBagLayout with defined minimum size", new Color(gray, gray, gray));
        left.add(tmin);
        right.add(rmin);
        PrefTrafficLight tpref = new PrefTrafficLight("Vertical GridBagLayout with defined preferred size", new Color(gray += 32, gray, gray));
        PrefRainbow rpref = new PrefRainbow("Horizontal GridBagLayout with defined preferred size", new Color(gray, gray, gray));
        left.add(tpref);
        right.add(rpref);
        MaxTrafficLight tmax = new MaxTrafficLight("Vertical GridBagLayout with defined maximum size", new Color(gray += 32, gray, gray));
        MaxRainbow rmax = new MaxRainbow("Horizontal GridBagLayout with defined maximum size", new Color(gray, gray, gray));
        left.add(tmax);
        right.add(rmax);
        gray += 32;
        panels.add(left);
        panels.add(right);
        this.add((Component)panels, "Center");
    }

    private void displayMessage(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        System.out.println(text);
        this.display.add(text, 0);
    }

    public String getHelpText() {
        return "A test to verify Rudolph's GridBagLayout implementation\nThe main screen is devided into a left and a right part. In each part a gridlayout shows four Component elements\nThese elements consist out of three colored rectangles (graphic Components) either in a vertical or a horizontal row. The left part of the screen shows a four-in-a-row grid displaying four vertical elements, side by side, the right panel shows a four vertical layer grid, every layer showing a horizontal element.For all four elements of a panel, a different subclass of the elements is used, each defining a minimum, maximum or preferred size. The defined size is the smallest size showing all three rectangles, ergo rectangle width and three times rectangle height for the vertical element and three times rectangle width/one time rectangle height for the horizontal one.\n-> for the first element, the elements has NO minimum, maximum or preferred size at all\n-> for the second element, the elements has a minimum size defined\n-> for the third element, the element has a preferred size defined\n-> for the fourth element, the element has a maximum size defined\nClicking on one of the element, shows the type, layout and size definition for that element in the list below";
    }

    public static void main(String[] args) {
        MinimumSizeGrid tf = new MinimumSizeGrid();
        tf.show();
    }

    static /* synthetic */ void access$200(MinimumSizeGrid x0, String x1) {
        x0.displayMessage(x1);
    }

    class FillComponent
    extends Component {
        private Dimension bounds;
        private Rectangle innerRect;
        private int middle;
        private String name;
        private Color background;

        public FillComponent(String parent, int width, int height, Color back) {
            this.background = back;
            this.name = parent;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ FillComponent this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent evt) {
                    MinimumSizeGrid.access$200(FillComponent.access$100(this.this$1), FillComponent.access$000(this.this$1));
                }
            });
            this.bounds = new Dimension();
            this.innerRect = new Rectangle(0, 0, width - 4, height - 4);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (!this.bounds.equals(this.getSize())) {
                this.bounds.setSize(this.getSize());
                this.innerRect.setLocation((this.bounds.width - this.innerRect.width) / 2, (this.bounds.height - this.innerRect.height) / 2);
                this.middle = this.getSize().height / 2;
            }
            g.setColor(this.background);
            g.fillRect(1, 1, this.bounds.width - 1, this.bounds.height - 1);
            g.setColor(this.getBackground());
            g.drawRect(this.innerRect.x + 2, this.innerRect.y + 2, this.innerRect.width - 4, this.innerRect.height - 4);
            g.drawLine(this.innerRect.x, this.innerRect.y, this.innerRect.x + this.innerRect.width, this.innerRect.y + this.innerRect.height);
            g.drawLine(this.innerRect.x, this.innerRect.y + this.innerRect.height, this.innerRect.x + this.innerRect.width, this.innerRect.y);
        }

        static /* synthetic */ String access$000(FillComponent x0) {
            return x0.name;
        }

        static /* synthetic */ MinimumSizeGrid access$100(FillComponent x0) {
            return x0.MinimumSizeGrid.this;
        }
    }

    class PrefRainbow
    extends RainbowComponent {
        public PrefRainbow(String name, Color background) {
            super(name, background);
        }

        public Dimension getPreferredSize() {
            return new Dimension(90, 30);
        }
    }

    class MaxRainbow
    extends RainbowComponent {
        public MaxRainbow(String name, Color background) {
            super(name, background);
        }

        public Dimension getMaximumSize() {
            return new Dimension(90, 30);
        }
    }

    class MinRainbow
    extends RainbowComponent {
        public MinRainbow(String name, Color background) {
            super(name, background);
        }

        public Dimension getMinimumSize() {
            return new Dimension(90, 30);
        }
    }

    class RainbowComponent
    extends Panel {
        protected FillComponent red;
        protected FillComponent green;
        protected FillComponent blue;

        public RainbowComponent(String name, Color background) {
            this.setBackground(background);
            this.red = new FillComponent(name, 30, 30, Color.red);
            this.green = new FillComponent(name, 30, 30, Color.green);
            this.blue = new FillComponent(name, 30, 30, Color.blue);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.add((Component)this.red, gbc);
            this.add((Component)this.green, gbc);
            this.add((Component)this.blue, gbc);
        }
    }

    class PrefTrafficLight
    extends TrafficLightComponent {
        public PrefTrafficLight(String name, Color background) {
            super(name, background);
        }

        public Dimension getPreferredSize() {
            return new Dimension(30, 90);
        }
    }

    class MaxTrafficLight
    extends TrafficLightComponent {
        public MaxTrafficLight(String name, Color background) {
            super(name, background);
        }

        public Dimension getMaximumSize() {
            return new Dimension(30, 90);
        }
    }

    class MinTrafficLight
    extends TrafficLightComponent {
        public MinTrafficLight(String name, Color background) {
            super(name, background);
        }

        public Dimension getMinimumSize() {
            return new Dimension(30, 90);
        }
    }

    class TrafficLightComponent
    extends Panel {
        protected FillComponent red;
        protected FillComponent yellow;
        protected FillComponent green;

        public TrafficLightComponent(String name, Color background) {
            this.setBackground(background);
            this.red = new FillComponent(name, 30, 30, Color.red);
            this.yellow = new FillComponent(name, 30, 30, Color.yellow);
            this.green = new FillComponent(name, 30, 30, Color.green);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            this.add((Component)this.red, gbc);
            this.add((Component)this.yellow, gbc);
            this.add((Component)this.green, gbc);
        }
    }
}

