/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.GridBagLayout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LunaticLayout
extends VisualTestImpl
implements ActionListener {
    private List display;

    public LunaticLayout() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        this.add((Component)new Label("GridBagLayout demo...", 1), "North");
        Panel testpanel = new Panel(new GridBagLayout());
        testpanel.setBackground(Color.black);
        this.makeButton(testpanel, "1", 0, 0, 3, 2, 1.0, 0.0);
        this.makeButton(testpanel, "2", 3, 0, 1, 3, 0.5, 0.0);
        this.makeButton(testpanel, "3", 4, 0, 3, 1, 1.0, 0.5);
        this.makeButton(testpanel, "4", 5, 1, 1, 1, 1.0, 1.0);
        this.makeButton(testpanel, "5", 4, 1, 1, 4, 1.0, 1.0);
        this.makeButton(testpanel, "6", 0, 2, 1, 2, 0.5, 1.0);
        this.makeButton(testpanel, "7", 2, 2, 1, 1, 2.0, 1.0);
        this.makeButton(testpanel, "8", 6, 1, 1, 3, 1.0, 1.0);
        this.makeButton(testpanel, "9", 1, 3, 3, 2, 2.0, 0.0);
        this.makeButton(testpanel, "10", 5, 3, 1, 1, 1.0, 0.0);
        this.makeButton(testpanel, "11", 5, 4, 2, 1, 1.0, 1.0);
        this.add((Component)testpanel, "Center");
        this.display = new List(3, false);
        this.display.add("Click on a GridbagLayout button to see its constraints HERE");
        this.add((Component)this.display, "South");
    }

    public void makeButton(Container cont, String label, int x, int y, int w, int h, double wx, double wy) {
        GridBagLayout gbl = (GridBagLayout)cont.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.gridheight = h;
        c.weightx = wx;
        c.weighty = wy;
        Button comp = new Button(x + "," + y + ";" + w + "," + h);
        comp.setActionCommand("Button <" + label + "> Position=(" + x + "," + y + ") size=(" + w + "," + h + ") weight=(" + wx + ", " + wy + ")");
        comp.addActionListener(this);
        comp.setBackground(new Color(x * 40, 100, y * 40));
        cont.add((Component)comp, c);
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        this.displayMessage("Pressed : " + source.getActionCommand());
    }

    public void displayMessage(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(message, 0);
    }

    public String getHelpText() {
        return "You should see a gridbag of 7 columns by 5 rows. The coordinates x and y and dimension w and h should be visible as a label on 10 buttons (disgard the right column of vte buttons). The buttons should carry the following labels: \n    0,0;3,2 \n    3,0;1,3 \n    4,0;3,1 \n    5,1;1,1 \n    4,1;1,4 \n    2,2;1,1 \n    6,1;1,3 \n    1,3;3,2 \n    5,3;1,1 \n    5,4;2,1 \nand should be positioned and sized accordingly. Some Buttons may have a width or height that looks thinner than expected. This is because weights are assigned to each row and each column. These are the column weights: \n     0(.5) 1(0) 2(2) 3(.5) 4(1) 5(1) 6(1) \n and the row weights: \n    0(.5) 1(1) 2(1) 3(.0) 4(1)";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    class SizedPanel
    extends Panel {
        private int preferredWidth;
        private int preferredHeight;

        public SizedPanel(int w, int h, Color back, LayoutManager manager) {
            super(manager);
            this.preferredWidth = w;
            this.preferredHeight = h;
            this.setBackground(back);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }
    }
}

