/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.GridBagLayout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Button;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GridWidth
extends VisualTestImpl
implements ActionListener {
    GridBagLayout gbl = new GridBagLayout();

    public GridWidth() {
        this.setLayout(this.gbl);
        int n = 1;
        this.makeButton("1", 1, 1, n++);
        this.makeButton("1", 0, 1, 1, 1, n++);
        this.makeButton("1", 1, 1, n++);
        this.makeButton("1", 1, 2, 1, 1, n++);
        this.makeButton("RELATIVE", -1, 1, n++);
        this.makeButton("REMAINDER", 0, 1, n++);
        this.makeButton("1", 1, 2, n++);
        this.makeButton("1", 1, 1, n++);
        this.makeButton("1", 1, 2, n++);
        this.makeButton("REMAINDER", 0, 1, n++);
        this.makeButton("1", 1, 1, n++);
        this.makeButton("1", 1, 1, n++);
        this.makeButton("REMAINDER", -1, 5, 0, 2, n++);
        this.makeButton("1", 1, 1, n++);
        this.makeButton("1", 1, 1, n++);
        this.makeButton("1", 1, 2, n++);
        this.makeButton("1", 1, 1, n++);
        this.makeButton("RELATIVE", -1, 1, n++);
        this.makeButton("REMAINDER", 0, 1, n++);
    }

    void makeButton(String label, int w, int h, int n) {
        Button b = new Button(label + ", " + n);
        MyConstraints c = new MyConstraints();
        c.id = n;
        c.gridwidth = w;
        c.gridheight = h;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.gbl.setConstraints(b, c);
        if (w == 0 || h == 0) {
            b.setBackground(Color.red);
        } else if (w == -1 || h == -1) {
            b.setBackground(new Color(255, 0, 255));
        } else {
            b.setBackground(new Color(0, (h + 4) * 40, 100));
        }
        this.add(b);
        b.addActionListener(this);
    }

    void makeButton(String label, int x, int y, int w, int h, int n) {
        MyConstraints c = new MyConstraints();
        c.id = n;
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.gridheight = h;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        Button b = new Button(label + ", " + n);
        if (w == 0 || h == 0) {
            b.setBackground(Color.yellow);
        } else {
            b.setBackground(new Color(0, 100, (h / 2 + 3) * 50));
        }
        this.add(b);
        b.addActionListener(this);
        this.gbl.setConstraints(b, c);
    }

    public void actionPerformed(ActionEvent evt) {
        Button b = (Button)evt.getSource();
        MyConstraints gbc = (MyConstraints)this.gbl.getConstraints(b);
        if (gbc.gridwidth != 0 && gbc.gridwidth != -1) {
            if (++gbc.gridwidth > 4) {
                gbc.gridwidth = 1;
            }
            this.gbl.setConstraints(b, gbc);
            b.setLabel("" + gbc.gridwidth + ", " + gbc.id);
            this.invalidate();
            this.validate();
        }
    }

    public String getHelpText() {
        return "The test shows a panel of buttons, laid out with a gridbag layoutmanager. The panel is divided in cells by a grid of 7 columns by 8 rows. Rows 3, 4 and 7 are invisible since their weights are 0.0. (row and column numbers start with 0). The width of a column is determined by the button having the widest label in that column. \nThe label of a button is composed of its 'width' - multiples of 1 cell width - and the number of the button in the sequence of adding buttons to the panel. \nYou should see 19 buttons arranged as in the following table: \n\n_1__3__5__5__5__5__6 \n_2_____7__8__9_10_10 \n____4__7_____9_11_12 \n13_13_13_13_13_13_13 \n14_15_16_17_18_18_19 \n\nBlue buttons have absolute coordinates, as defined by the values of their 'gridx' and 'gridy' GridBagConstraints. All blue buttons are one row high. \nGreen buttons have no absolute coordinates and are positioned relative to previously added components (of lower sequence number). Most Buttons are 1 row high. Buttons 7, 9 and 16 are 2 rows high (row 7 has weight 0.0)\nRemark that the relative position of buttons is not influenced by the presence of buttons on rows that are higher than the current row (buttons 3 and 5).\n Red buttons have relative position and terminate a row of buttons (their constraint 'gridwidth' has value GridBagConstratnts.REMAINDER). \nThe yellow button also is a row terminator but it has an absolute y coordinate: it is positioned on row 5 though it terminates row 2  (row 3 and 4 have zero weight)\nPurple buttons have a 'gridwidth' constraint of value GridBagConstraints.RELATIVE. \nAn additional feature of this test is that a blue or green button's width is increased by one grid cell when it is pressed. A button can attain a maximum width of 4. The panel's layout is recalculated and repainted each time a button is pressed.Remark that, on the column next to the button you are trying to widthen, and on a row different from the row of that button, another button must start. Otherwise the new column has weight 0.0 and the button will not become 'visibly' wider. ";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    class MyConstraints
    extends GridBagConstraints {
        int id = 0;

        MyConstraints() {
        }

        public Object clone() {
            MyConstraints c = (MyConstraints)super.clone();
            c.id = this.id;
            return c;
        }
    }
}

