/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.GridBagLayout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class GridBagSizes
extends VisualTestImpl
implements ActionListener {
    private Panel testPanel;
    private FillComponent currentElement;
    private BorderedLabel number;
    private BorderedLabel preferedX;
    private BorderedLabel preferedY;
    private BorderedLabel sizeX;
    private BorderedLabel sizeY;
    private BorderedLabel spareX;
    private BorderedLabel spareY;
    private BorderedLabel colLeft;
    private BorderedLabel colMid;
    private BorderedLabel colRight;
    private BorderedLabel rowLeft;
    private BorderedLabel rowMid;
    private BorderedLabel rowRight;
    private Button increaseX;
    private Button decreaseX;
    private Button increaseY;
    private Button decreaseY;

    public GridBagSizes() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        Panel buttons = new Panel(new GridLayout(12, 1));
        buttons.add(new Label("Preferred width  ", 1));
        Panel split2 = new Panel(new GridLayout(1, 3));
        this.decreaseX = new Button("-");
        this.decreaseX.addActionListener(this);
        split2.add(this.decreaseX);
        this.preferedX = new BorderedLabel(Color.white);
        split2.add(this.preferedX);
        this.increaseX = new Button("+");
        this.increaseX.addActionListener(this);
        split2.add(this.increaseX);
        buttons.add(split2);
        Panel split3 = new Panel(new GridLayout(1, 2));
        split3.add(new Label("Actual ", 2));
        this.sizeX = new BorderedLabel(Color.lightGray);
        split3.add(this.sizeX);
        buttons.add(split3);
        Panel split4 = new Panel(new GridLayout(1, 2));
        split4.add(new Label("Leftover ", 2));
        this.spareX = new BorderedLabel(Color.lightGray);
        split4.add(this.spareX);
        buttons.add(split4);
        buttons.add(new Label("Total colunm widths", 1));
        Panel split8 = new Panel(new GridLayout(1, 3));
        this.colLeft = new BorderedLabel(Color.lightGray);
        split8.add(this.colLeft);
        this.colMid = new BorderedLabel(Color.lightGray);
        split8.add(this.colMid);
        this.colRight = new BorderedLabel(Color.lightGray);
        split8.add(this.colRight);
        buttons.add(split8);
        buttons.add(new Label("Preferred height  ", 1));
        Panel split5 = new Panel(new GridLayout(1, 3));
        this.decreaseY = new Button("-");
        this.decreaseY.addActionListener(this);
        split5.add(this.decreaseY);
        this.preferedY = new BorderedLabel(Color.white);
        split5.add(this.preferedY);
        this.increaseY = new Button("+");
        this.increaseY.addActionListener(this);
        split5.add(this.increaseY);
        buttons.add(split5);
        Panel split6 = new Panel(new GridLayout(1, 2));
        split6.add(new Label("Actual ", 2));
        this.sizeY = new BorderedLabel(Color.lightGray);
        split6.add(this.sizeY);
        buttons.add(split6);
        Panel split7 = new Panel(new GridLayout(1, 2));
        split7.add(new Label("Leftover ", 2));
        this.spareY = new BorderedLabel(Color.lightGray);
        split7.add(this.spareY);
        buttons.add(split7);
        buttons.add(new Label("Total row heights", 1));
        Panel split9 = new Panel(new GridLayout(1, 3));
        this.rowLeft = new BorderedLabel(Color.lightGray);
        split9.add(this.rowLeft);
        this.rowMid = new BorderedLabel(Color.lightGray);
        split9.add(this.rowMid);
        this.rowRight = new BorderedLabel(Color.lightGray);
        split9.add(this.rowRight);
        buttons.add(split9);
        this.add((Component)buttons, "East");
        Panel right = new Panel(new BorderLayout());
        Panel split1 = new Panel(new GridLayout(1, 5));
        split1.add(new Label("GridBag", 2));
        split1.add(new Label("Layout demo", 0));
        split1.add(new Label("Element : ", 2));
        this.number = new BorderedLabel(Color.lightGray);
        split1.add(this.number);
        split1.add(new Label());
        right.add((Component)split1, "North");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.testPanel = new Panel(gbl);
        this.testPanel.setBackground(new Color(200, 200, 120));
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        for (int i = 0; i < 3; ++i) {
            gbc.gridy = i;
            for (int j = 0; j < 3; ++j) {
                gbc.gridx = j;
                this.currentElement = new FillComponent("No." + (3 * i + j) + "  (" + j + ", " + i + ")", Color.white, new Color(i * 48, 100, j * 48));
                this.testPanel.add(this.currentElement);
                gbl.setConstraints(this.currentElement, gbc);
            }
        }
        right.add((Component)this.testPanel, "Center");
        right.add((Component)new Label("All elements have equal weights : weightx = weighty = 1.0", 1), "South");
        this.add((Component)right, "Center");
        this.displayData(this.currentElement);
        this.currentElement.inverse(true);
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        boolean succeeded = false;
        if (source == this.increaseX) {
            succeeded = this.currentElement.updateSize(10, 0);
        } else if (source == this.decreaseX) {
            succeeded = this.currentElement.updateSize(-10, 0);
        } else if (source == this.increaseY) {
            succeeded = this.currentElement.updateSize(0, 10);
        } else if (source == this.decreaseY) {
            succeeded = this.currentElement.updateSize(0, -10);
        }
        if (succeeded) {
            this.testPanel.invalidate();
            this.testPanel.validate();
            this.displayData(this.currentElement);
        }
    }

    public void displayData(FillComponent target) {
        this.number.setText(target.getName());
        this.preferedX.setText(target.getPreferredSize().width);
        this.preferedY.setText(target.getPreferredSize().height);
        this.sizeX.setText(target.getActualSize().width);
        this.sizeY.setText(target.getActualSize().height);
        this.spareX.setText(target.getActualSize().width - target.getPreferredSize().width);
        this.spareY.setText(target.getActualSize().height - target.getPreferredSize().height);
        GridBagLayout toscan = (GridBagLayout)this.testPanel.getLayout();
        int[][] dimensions = toscan.getLayoutDimensions();
        if (dimensions[0].length >= 3 && dimensions[1].length >= 3) {
            this.colLeft.setText(dimensions[0][0]);
            this.colMid.setText(dimensions[0][1]);
            this.colRight.setText(dimensions[0][2]);
            this.rowLeft.setText(dimensions[1][0]);
            this.rowMid.setText(dimensions[1][1]);
            this.rowRight.setText(dimensions[1][2]);
        }
    }

    public String getHelpText() {
        return "A GridBagLayout test on the GridBag size calculation :\nThe screen shows a central panel with 3x3 elements ranged using a GridBagLayout. The central rectangle of each element shows its preferred size.\nYou can click an element to select it. The selected element will change color and displayed in the right panel. will appear its name, actual size, preferred size, and the difference between these two sizes\nAlso, using the (+) and (-) buttons on the left panel you can change the preferred width and height of an element. This forces the layout to change size. The width of each colomn and the height of each row will be displayed, just as well \n\nITEMS TO TEST:\n\n-> division of the free width: All elements are added with the same horizontal and vertical weights weightx = weighty = 1.0 This means that the 'left-over' space from the layout (the part of the elements between the inner rectangle and the border) is devided equally between the rows.\nclicking the different elements and regarding their size definitions,you can check this";
    }

    public void start(Panel p, boolean b) {
        this.currentElement.repaint();
        this.displayData(this.currentElement);
    }

    public void stop(Panel p) {
    }

    static /* synthetic */ FillComponent access$300(GridBagSizes x0) {
        return x0.currentElement;
    }

    static /* synthetic */ FillComponent access$302(GridBagSizes x0, FillComponent x1) {
        x0.currentElement = x1;
        return x0.currentElement;
    }

    class FillComponent
    extends Component {
        private Dimension bounds;
        private Rectangle innerRect;
        private int middle;
        private String name;
        private Color background;
        private Color foreground;
        private boolean inversed;

        public FillComponent(String parent, Color fore, Color back) {
            this(parent, fore, back, 20, 20);
        }

        public FillComponent(String parent, Color fore, Color back, int w, int h) {
            this.foreground = fore;
            this.background = back;
            this.inversed = false;
            this.name = parent;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ FillComponent this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent evt) {
                    GridBagSizes.access$300(FillComponent.access$200(this.this$1)).inverse(false);
                    GridBagSizes.access$302(FillComponent.access$200(this.this$1), (FillComponent)evt.getSource());
                    FillComponent.access$200(this.this$1).displayData(GridBagSizes.access$300(FillComponent.access$200(this.this$1)));
                    this.this$1.inverse(true);
                }
            });
            this.bounds = new Dimension();
            this.innerRect = new Rectangle(0, 0, w, h);
        }

        public String getName() {
            return this.name;
        }

        public void inverse(boolean newvalue) {
            this.inversed = newvalue;
            this.repaint();
        }

        public void setSize(int w, int h) {
            this.innerRect = new Rectangle(0, 0, w, h);
            this.repaint();
        }

        public boolean updateSize(int dx, int dy) {
            boolean allowed = true;
            if (this.innerRect.width + dx > 0) {
                this.innerRect.width += dx;
            } else {
                allowed = false;
            }
            if (this.innerRect.height + dy > 0) {
                this.innerRect.height += dy;
            } else {
                allowed = false;
            }
            this.repaint();
            return allowed;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getActualSize() {
            return this.bounds;
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            this.bounds.setSize(this.getSize());
            this.innerRect.setLocation((this.bounds.width - this.innerRect.width) / 2, (this.bounds.height - this.innerRect.height) / 2);
            g.setColor(this.inversed ? this.foreground : this.background);
            g.fillRect(1, 1, this.bounds.width - 2, this.bounds.height - 2);
            g.setColor(this.inversed ? this.background : this.foreground);
            g.drawRect(this.innerRect.x + 2, this.innerRect.y + 2, this.innerRect.width - 4, this.innerRect.height - 4);
            g.drawRect(this.innerRect.x, this.innerRect.y, this.innerRect.width - 1, this.innerRect.height - 1);
            g.drawLine(this.innerRect.x, this.innerRect.y, this.innerRect.x + this.innerRect.width, this.innerRect.y + this.innerRect.height);
            g.drawLine(this.innerRect.x, this.innerRect.y + this.innerRect.height, this.innerRect.x + this.innerRect.width, this.innerRect.y);
        }

        static /* synthetic */ GridBagSizes access$200(FillComponent x0) {
            return x0.GridBagSizes.this;
        }
    }

    class BorderedLabel
    extends Component {
        private String text;
        private Color background;
        private Color foreground;

        public BorderedLabel() {
            this.text = "";
        }

        public BorderedLabel(Color backcolor) {
            this.setBackground(backcolor);
            this.text = "";
        }

        public BorderedLabel(Color textcolor, Color backcolor) {
            this.setBackground(backcolor);
            this.setForeground(textcolor);
            this.text = "";
        }

        private void setText(String newtext) {
            this.text = newtext;
            this.repaint();
        }

        private void setText(int newvalue) {
            this.text = Integer.toString(newvalue);
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(35, 12);
        }

        public Dimension getPreferredSize() {
            return new Dimension(35, 12);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            Dimension d = this.getSize();
            g.clearRect(1, 1, d.width - 2, d.height - 2);
            g.setColor(this.getForeground());
            g.drawRect(1, 1, d.width - 2, d.height - 2);
            g.drawString(this.text, 5, d.height / 2 + 3);
        }
    }
}

