/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.GridBagLayout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DynamicLayout
extends VisualTestImpl
implements ActionListener {
    private List display;
    private Panel testPanel;
    private Button currentElement;
    private Button remove;
    private Button undo;
    private Button reset;
    private Button getLayout;
    private Checkbox none;
    private Checkbox horizontal;
    private Checkbox vertical;
    private Checkbox both;

    public DynamicLayout() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        this.add((Component)new Label("GridBagLayout demo...", 1), "North");
        Panel buttons = new Panel(new GridLayout(9, 1));
        CheckboxGroup layouts = new CheckboxGroup();
        this.none = new Checkbox("fill NONE", false, layouts);
        buttons.add(this.none);
        this.horizontal = new Checkbox("fill HORIZONTAL", true, layouts);
        buttons.add(this.horizontal);
        this.vertical = new Checkbox("fill VERTICAL", true, layouts);
        buttons.add(this.vertical);
        this.both = new Checkbox("fill BOTH", true, layouts);
        buttons.add(this.both);
        this.reset = new Button("(Re)Build layout");
        this.reset.addActionListener(this);
        buttons.add(this.reset);
        this.getLayout = new Button("Print layout data");
        this.getLayout.addActionListener(this);
        buttons.add(this.getLayout);
        buttons.add(new Label());
        this.remove = new Button("Remove current");
        this.remove.addActionListener(this);
        buttons.add(this.remove);
        this.undo = new Button("Undo remove");
        this.undo.addActionListener(this);
        this.undo.setEnabled(false);
        buttons.add(this.undo);
        this.add((Component)buttons, "East");
        this.display = new List(3, false);
        this.display.add("Click on a GridbagLayout button to see its constraints HERE");
        this.add((Component)this.display, "South");
        this.testPanel = new Panel(new GridBagLayout());
        this.testPanel.setBackground(new Color(200, 200, 120));
        this.invokeLunaticLayout(this.testPanel);
        this.add((Component)this.testPanel, "Center");
    }

    private void invokeLunaticLayout(Container cont) {
        this.makeButton(cont, "No.01", 0, 0, 3, 2, 1.0, 0.0);
        this.makeButton(cont, "No.02", 3, 0, 1, 3, 0.5, 0.0);
        this.makeButton(cont, "No.03", 4, 0, 3, 1, 1.0, 0.5);
        this.makeButton(cont, "No.04", 5, 1, 1, 1, 1.0, 1.0);
        this.makeButton(cont, "No.05", 4, 1, 1, 4, 1.0, 1.0);
        this.makeButton(cont, "No.06", 0, 2, 1, 3, 0.5, 1.0);
        this.makeButton(cont, "No.07", 2, 2, 1, 1, 2.0, 1.0);
        this.makeButton(cont, "No.08", 6, 1, 1, 3, 1.0, 1.0);
        this.makeButton(cont, "No.09", 1, 3, 3, 2, 2.0, 0.0);
        this.makeButton(cont, "No.10", 5, 3, 1, 1, 1.0, 0.0);
        this.makeButton(cont, "No.11", 5, 4, 2, 1, 1.0, 1.0);
        cont.validate();
        this.currentElement = null;
    }

    public void makeButton(Container cont, String label, int x, int y, int w, int h, double wx, double wy) {
        GridBagLayout gbl = (GridBagLayout)cont.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = this.none.getState() ? 0 : (this.horizontal.getState() ? 2 : (this.vertical.getState() ? 3 : 1));
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.gridheight = h;
        c.weightx = wx;
        c.weighty = wy;
        Button comp = new Button(label);
        comp.setActionCommand("Button " + label + " Position=(" + x + "," + y + ") size=(" + w + "," + h + ") weight=(" + wx + ", " + wy + ")");
        comp.addActionListener(this);
        comp.setFont(new Font("courP14", 0, 14));
        comp.setBackground(new Color(x * 40, 100, y * 40));
        comp.setForeground(Color.black);
        cont.add((Component)comp, c);
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        if (source == this.remove) {
            if (this.currentElement != null) {
                this.testPanel.remove(this.currentElement);
                this.testPanel.validate();
            }
            this.displayMessage("Removed : " + this.currentElement.getActionCommand());
            this.remove.setEnabled(false);
            this.undo.setEnabled(true);
        } else if (source == this.undo) {
            if (this.currentElement != null) {
                this.testPanel.add(this.currentElement);
                this.testPanel.validate();
            }
            this.displayMessage("added : " + this.currentElement.getActionCommand());
            this.remove.setEnabled(true);
            this.undo.setEnabled(false);
        } else if (source == this.getLayout) {
            this.displayGridLayout();
        } else if (source == this.reset) {
            this.testPanel.removeAll();
            this.invokeLunaticLayout(this.testPanel);
            this.remove.setEnabled(false);
            this.undo.setEnabled(false);
            this.displayMessage("(Re)Built layout");
        } else {
            this.inverseButton(this.currentElement);
            this.inverseButton(source);
            this.displayMessage("Pressed : " + source.getActionCommand());
            this.currentElement = source;
            this.remove.setEnabled(true);
            this.undo.setEnabled(false);
        }
    }

    private void displayGridLayout() {
        GridBagLayout toscan = (GridBagLayout)this.testPanel.getLayout();
        int[][] dimensions = toscan.getLayoutDimensions();
        double[][] weights = toscan.getLayoutWeights();
        if (dimensions == null) {
            this.displayMessage("GridBagLayout Dimensions returned NULL");
        } else if (weights == null) {
            this.displayMessage("GridBagLayout Weights returned NULL");
        } else {
            int i;
            String message = "...for: " + dimensions[1].length + " rows: { ";
            if (dimensions[1].length > 0) {
                message = message + dimensions[1][0] + "(" + weights[1][0];
            }
            for (i = 1; i < dimensions[1].length; ++i) {
                message = message + "),  " + dimensions[1][i] + "(" + weights[1][i];
            }
            this.displayMessage(message + ") }");
            message = "Grid data for: " + dimensions[0].length + " columns: { ";
            if (dimensions[0].length > 0) {
                message = message + dimensions[0][0] + "(" + weights[0][0];
            }
            for (i = 1; i < dimensions[1].length; ++i) {
                message = message + "),  " + dimensions[0][i] + "(" + weights[0][i];
            }
            this.displayMessage(message + ") }");
        }
    }

    private void inverseButton(Button target) {
        if (target != null) {
            Color c1 = target.getBackground();
            Color c2 = target.getForeground();
            target.setForeground(c1);
            target.setBackground(c2);
        }
    }

    private void displayLayouts(GridBagLayout grid) {
        String displayline = "Horizontal grid (pixels/weight)={";
        this.display.add(displayline + "}", 0);
    }

    public void displayMessage(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(message, 0);
    }

    public String getHelpText() {
        return "You should see a gridbag of 7 columns by 5 rows. The coordinates x and y and dimension w and h should be visible as a label on 10 buttons (disgard the right column of vte buttons). The buttons should carry the following labels: \n    0,0;3,2 \n    3,0;1,3 \n    4,0;3,1 \n    5,1;1,1 \n    4,1;1,4 \n    2,2;1,1 \n    6,1;1,3 \n    1,3;3,2 \n    5,3;1,1 \n    5,4;2,1 \nand should be positioned and sized accordingly.\nClick on a button to see its data in the list below.\nThe <Print layout data> button shows the widths and weights of all rows and columns used.\nThe <remove> button removes the currently selected button from the list, the <undo> button adds it again.Like that you can see the change in layout both visually as well as in the row/coulnms grid\nThe <(re)build> button rebuilds the layout in its original form its fill policy given by the buttons above:no filling, horizontal, vertical or both";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }
}

