/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics.dottedtext;

import com.acunia.wonka.test.awt.Graphics.dottedtext.Arial_10_0;
import com.acunia.wonka.test.awt.Graphics.dottedtext.DotArray;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;

public class PixelDisplay
extends Canvas
implements Runnable {
    public static final int DIRECTION_LEFT_RIGHT = 0;
    public static final int DIRECTION_RIGHT_LEFT = 1;
    public static final int DIRECTION_UP_DOWN = 2;
    public static final int DIRECTION_DOWN_UP = 3;
    private boolean showBorder;
    private boolean goOn;
    public Thread runner;
    private int startColumn = 0;
    private int startRow = 0;
    private DotArray array;
    private int dotSize = 10;
    private Color activeFG = new Color(0xFFFF00);
    private Color inactiveFG = new Color(65280);
    private int delay = 200;
    private int pauseAtStart = 500;
    private int shiftDirection = 1;
    private Color shadowUp = new Color(100, 100, 100);
    private Color shadowDown = new Color(200, 200, 200);
    private boolean[][] previous = null;

    public void setDotSize(int size) {
        this.dotSize = size;
    }

    public void setBgColor(Color color) {
    }

    public void setActiveColor(Color color) {
        this.activeFG = color;
    }

    public void setInactiveColor(Color color) {
        this.inactiveFG = color;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setPauseAtStart(int start) {
        this.pauseAtStart = start;
    }

    public void setShowBorder(boolean show) {
        this.showBorder = show;
    }

    public void setShadowUp(Color color) {
        this.shadowUp = color;
    }

    public void setShadowDown(Color color) {
        this.shadowDown = color;
    }

    public void setShiftDirection(int direction) {
        this.shiftDirection = direction;
    }

    public int getDotSize() {
        return this.dotSize;
    }

    public Color getBgColor() {
        return null;
    }

    public Color getActiveColor() {
        return this.activeFG;
    }

    public Color getInactiveColor() {
        return this.inactiveFG;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getPauseAtStart() {
        return this.pauseAtStart;
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public int getShiftDirection() {
        return this.shiftDirection;
    }

    public Color getShadowUp() {
        return this.shadowUp;
    }

    public Color getShadowDown() {
        return this.shadowDown;
    }

    public PixelDisplay(DotArray array) {
        this.setBackground(Color.lightGray);
        this.setShowBorder(true);
        this.array = array;
    }

    public void start() {
        if (this.runner == null) {
            this.startRow = 0;
            this.startColumn = 0;
            this.goOn = true;
            this.runner = new Thread((Runnable)this, "PixelDisplay Thread");
            this.runner.start();
        }
    }

    public void stop() {
        this.goOn = false;
    }

    public void run() {
        while (this.goOn) {
            switch (this.shiftDirection) {
                case 1: {
                    this.startColumn += 4;
                    if (this.startColumn <= this.array.getArray()[0].length) break;
                    this.startColumn = 0;
                    try {
                        Thread.sleep(this.pauseAtStart);
                    }
                    catch (Exception e) {}
                    break;
                }
                case 0: {
                    this.startColumn -= 2;
                    if (this.startColumn >= 0) break;
                    this.startColumn = this.array.getArray()[0].length - 1;
                    try {
                        Thread.sleep(this.pauseAtStart);
                    }
                    catch (Exception e) {}
                    break;
                }
                case 3: {
                    this.startRow += 2;
                    if (this.startRow <= this.array.getArray().length) break;
                    this.startRow = 0;
                    try {
                        Thread.sleep(this.pauseAtStart);
                    }
                    catch (Exception e) {}
                    break;
                }
                case 2: {
                    this.startRow -= 2;
                    if (this.startRow >= 0) break;
                    this.startRow = this.array.getArray().length - 1;
                    try {
                        Thread.sleep(this.pauseAtStart);
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception exception) {}
        }
        this.runner = null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Image offscreen = this.createImage(this.getWidth(), this.getHeight());
        this.paintOffscreen(offscreen.getGraphics());
        g.drawImage(offscreen, 0, 0, null);
    }

    public void paintOffscreen(Graphics g) {
        this.paintInit(g);
    }

    public void paintInit(Graphics g) {
        boolean y = false;
        int maxWidth = (this.getWidth() - 2) / (this.dotSize + 1);
        int maxHeight = (this.getHeight() - 2) / (this.dotSize + 1);
        this.previous = new boolean[maxHeight + 1][maxWidth + 1];
        try {
            int r = this.startRow;
            for (int ri = 0; ri < maxHeight; ++ri) {
                if (r >= this.array.getArray().length) {
                    r = 0;
                }
                int c = this.startColumn;
                for (int ci = 0; ci < maxWidth; ++ci) {
                    if (c >= this.array.getArray()[r].length) {
                        c = 0;
                    }
                    this.previous[ri][ci] = this.array.getArray()[r][c];
                    if (this.array.getArray()[r][c]) {
                        g.setColor(this.activeFG);
                        g.fillRect(1 + ci * (this.dotSize + 1), 1 + ri * (this.dotSize + 1), this.dotSize, this.dotSize);
                    }
                    ++c;
                }
                ++r;
            }
            if (this.showBorder) {
                g.setColor(this.shadowUp);
                g.drawLine(0, 0, 0, this.getHeight() - 1);
                g.drawLine(0, 0, this.getWidth() - 1, 0);
                g.setColor(this.shadowDown);
                g.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
                g.drawLine(this.getWidth() - 1, this.getHeight() - 1, this.getWidth() - 1, 0);
                g.setColor(Color.red);
            }
        }
        catch (Exception e) {
            this.stop();
        }
    }

    public void paintLoop(Graphics g) {
        boolean y = false;
        int maxWidth = (this.getWidth() - 2) / (this.dotSize + 1);
        int maxHeight = (this.getHeight() - 2) / (this.dotSize + 1);
        if (maxWidth + 1 != this.previous[0].length || maxHeight + 1 != this.previous.length) {
            this.paintInit(g);
        } else {
            try {
                int r = this.startRow;
                for (int ri = 0; ri < maxHeight; ++ri) {
                    if (r >= this.array.getArray().length) {
                        r = 0;
                    }
                    int c = this.startColumn;
                    for (int ci = 0; ci < maxWidth; ++ci) {
                        if (c >= this.array.getArray()[r].length) {
                            c = 0;
                        }
                        if (this.array.getArray()[r][c] != this.previous[ri][ci]) {
                            this.previous[ri][ci] = this.array.getArray()[r][c];
                            if (this.array.getArray()[r][c]) {
                                g.setColor(this.activeFG);
                                g.fillRect(1 + ci * (this.dotSize + 1), 1 + ri * (this.dotSize + 1), this.dotSize, this.dotSize);
                            } else {
                                g.setColor(this.inactiveFG);
                                g.fillRect(1 + ci * (this.dotSize + 1), 1 + ri * (this.dotSize + 1), this.dotSize, this.dotSize);
                            }
                        }
                        ++c;
                    }
                    ++r;
                }
                if (this.showBorder) {
                    g.setColor(this.shadowUp);
                    g.drawLine(0, 0, 0, this.getHeight() - 1);
                    g.drawLine(0, 0, this.getWidth() - 1, 0);
                    g.setColor(this.shadowDown);
                    g.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
                    g.drawLine(this.getWidth() - 1, this.getHeight() - 1, this.getWidth() - 1, 0);
                }
            }
            catch (Exception e) {
                System.out.println("pad was stopped");
                this.stop();
            }
        }
    }

    public DotArray getDotArray() {
        return this.array;
    }

    public void setDotArray(DotArray array) {
        this.array = array;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 20);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getMinimumSize().width, this.getMinimumSize().height);
    }

    public static void main(String[] args) {
        DotArray da = new DotArray(200, 70);
        da.drawString("Studio Brussel", 5, 0, new Arial_10_0());
        Frame f = new Frame();
        f.setLayout(new BorderLayout());
        f.setSize(300, 200);
        PixelDisplay pd = new PixelDisplay(da);
        pd.setShiftDirection(3);
        pd.setDelay(800);
        f.add((Component)pd, "Center");
        f.setLocation(20, 20);
        f.show();
        pd.start();
    }
}

