/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Writer;

public class FillPoly
extends VisualTestImpl
implements ActionListener,
ItemListener {
    private static final Color[] COLORS = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, new Color(96, 96, 255), new Color(0, 0, 128), new Color(128, 0, 128)};
    private static final int VINCINITY = 7;
    private PolygonPanel blackboard = new PolygonPanel();
    private Button addBefore;
    private Button addAfter;
    private Button delete;
    private Button mode;
    private Checkbox fillNative;
    private Checkbox fillDemo;

    public FillPoly() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.blackboard, "Center");
        CheckboxGroup group = new CheckboxGroup();
        Panel buttonrow = new Panel(new GridLayout(2, 3));
        this.addBefore = new Button("Add point (before)");
        this.addBefore.addActionListener(this);
        buttonrow.add(this.addBefore);
        this.addAfter = new Button("Add point (after)");
        this.addAfter.addActionListener(this);
        buttonrow.add(this.addAfter);
        this.delete = new Button("Delete point");
        this.delete.addActionListener(this);
        buttonrow.add(this.delete);
        this.mode = new Button(this.blackboard.isFillMode() ? "draw" : "fill");
        this.mode.addActionListener(this);
        buttonrow.add(this.mode);
        this.fillNative = new Checkbox("Native fill", group, true);
        this.fillNative.addItemListener(this);
        buttonrow.add(this.fillNative);
        this.fillDemo = new Checkbox("Demo fill", group, false);
        this.fillDemo.addItemListener(this);
        buttonrow.add(this.fillDemo);
        this.add((Component)buttonrow, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addBefore) {
            this.blackboard.addPoint(true);
        }
        if (evt.getSource() == this.addAfter) {
            this.blackboard.addPoint(false);
        } else if (evt.getSource() == this.delete) {
            this.blackboard.delete();
        } else if (evt.getSource() == this.mode) {
            this.blackboard.swapFillMode();
            this.mode.setLabel(this.blackboard.isFillMode() ? "draw" : "fill");
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        this.blackboard.setNativeFill(this.fillNative.getState());
    }

    public void log(Panel p, Writer w, boolean b) throws IOException {
        w.write("DrawOffset ");
    }

    public String getHelpText() {
        return "Polygon filling demonstration\n\nThe main 'drawing board' allows you to draw an ontline of a geometrical figure. The button lower right button (showing 'fill') allows you to draw this figure as a filled polygon. (After filling the button's text changes to 'draw' and pressing this button a second time will display the outlines of the figure again) \n\n The checkboxes <fill native> and <fill demo> allow you to select wether you want to use the native Graphic.fillPolygon() or the test's own demo filling algorithm \n\nYou can form the figure by :\n=> Clicking one of its corner points and dragging  it to a new position\n=> Pressing <add point(before)> and <add point(after)> to add a new corner point before or after the current selected one\n=> Pressing <delete point> to delete the current corner point";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        new FillPoly();
    }

    private void fillPolygonDemo(int[] pointx, int[] pointy, int size, Graphics g) {
        int firstpoint;
        int[] nextpoint = new int[size];
        int[] linestarts = new int[size];
        int[] linestops = new int[size];
        int[] nodes = new int[size];
        int[] nextnode = new int[size];
        int currentpoint = firstpoint = this.sortIncreasing(pointy, nextpoint, size);
        int numberoflines = 0;
        int linepiece = 0;
        do {
            int i;
            int next;
            int scanstart = pointy[currentpoint];
            int scanstop = pointy[nextpoint[currentpoint]];
            int previous = currentpoint > 0 ? currentpoint - 1 : size - 1;
            int n = next = currentpoint < size - 1 ? currentpoint + 1 : 0;
            if (pointy[previous] > pointy[currentpoint]) {
                linestarts[numberoflines] = currentpoint;
                linestops[numberoflines++] = previous;
            } else if (pointy[previous] < pointy[currentpoint]) {
                i = 0;
                while (linestarts[i] != previous || linestops[i] != currentpoint) {
                    ++i;
                }
                linestarts[i] = linestarts[--numberoflines];
                linestops[i] = linestops[numberoflines];
            }
            if (pointy[next] > pointy[currentpoint]) {
                linestarts[numberoflines] = currentpoint;
                linestops[numberoflines++] = next;
            } else if (pointy[next] < pointy[currentpoint]) {
                i = 0;
                while (linestarts[i] != next || linestops[i] != currentpoint) {
                    ++i;
                }
                linestarts[i] = linestarts[--numberoflines];
                linestops[i] = linestops[numberoflines];
            }
            g.setColor(COLORS[linepiece % 7]);
            for (int scanline = scanstart; scanline < scanstop; ++scanline) {
                for (i = 0; i < numberoflines; ++i) {
                    nodes[i] = pointx[linestarts[i]];
                    if (scanline <= pointy[linestarts[i]]) continue;
                    int n2 = i;
                    nodes[n2] = nodes[n2] + (pointx[linestops[i]] - pointx[linestarts[i]]) * (scanline - pointy[linestarts[i]]) / (pointy[linestops[i]] - pointy[linestarts[i]]);
                }
                previous = this.sortIncreasing(nodes, nextnode, numberoflines);
                while (previous >= 0) {
                    next = nextnode[previous];
                    g.drawLine(nodes[previous], scanline, nodes[next], scanline);
                    previous = nextnode[next];
                }
            }
            ++linepiece;
        } while (nextpoint[currentpoint = nextpoint[currentpoint]] >= 0);
        g.setColor(Color.black);
        g.drawPolygon(pointx, pointy, size);
    }

    private int sortIncreasing(int[] value, int[] order, int size) {
        int first = 0;
        order[first] = -1;
        for (int i = 1; i < size; ++i) {
            if (value[i] <= value[first]) {
                order[i] = first;
                first = i;
                continue;
            }
            int previous = first;
            while (order[previous] >= 0 && value[order[previous]] <= value[i]) {
                previous = order[previous];
            }
            order[i] = order[previous];
            order[previous] = i;
        }
        return first;
    }

    private void fillPolygon(int[] pointx, int[] pointy, int size, Graphics g) {
        int[] nextpoint = new int[size];
        int[] linestarts = new int[size];
        int[] linestops = new int[size];
        int[] nodes = new int[size];
        int[] nextnode = new int[size];
        int numberoflines = 0;
        int currentpoint = this.sortIncreasing(pointy, nextpoint, size);
        int scanstart = pointy[currentpoint];
        do {
            int i;
            int next;
            int scanstop = pointy[nextpoint[currentpoint]];
            int previous = currentpoint > 0 ? currentpoint - 1 : size - 1;
            int n = next = currentpoint < size - 1 ? currentpoint + 1 : 0;
            if (pointy[previous] > pointy[currentpoint]) {
                linestarts[numberoflines] = currentpoint;
                linestops[numberoflines++] = previous;
            } else if (pointy[previous] < pointy[currentpoint]) {
                i = 0;
                while (linestarts[i] != previous || linestops[i] != currentpoint) {
                    ++i;
                }
                linestarts[i] = linestarts[--numberoflines];
                linestops[i] = linestops[numberoflines];
            }
            if (pointy[next] > pointy[currentpoint]) {
                linestarts[numberoflines] = currentpoint;
                linestops[numberoflines++] = next;
            } else if (pointy[next] < pointy[currentpoint]) {
                i = 0;
                while (linestarts[i] != next || linestops[i] != currentpoint) {
                    ++i;
                }
                linestarts[i] = linestarts[--numberoflines];
                linestops[i] = linestops[numberoflines];
            }
            for (int scanline = scanstart; scanline < scanstop; ++scanline) {
                for (i = 0; i < numberoflines; ++i) {
                    nodes[i] = pointx[linestarts[i]];
                    if (scanline <= pointy[linestarts[i]]) continue;
                    int n2 = i;
                    nodes[n2] = nodes[n2] + (pointx[linestops[i]] - pointx[linestarts[i]]) * (scanline - pointy[linestarts[i]]) / (pointy[linestops[i]] - pointy[linestarts[i]]);
                }
                previous = this.sortIncreasing(nodes, nextnode, numberoflines);
                while (previous >= 0) {
                    next = nextnode[previous];
                    g.drawLine(nodes[previous], scanline, nodes[next], scanline);
                    previous = nextnode[next];
                }
            }
            currentpoint = nextpoint[currentpoint];
            scanstart = scanstop;
        } while (nextpoint[currentpoint] >= 0);
    }

    class PolygonPanel
    extends Container
    implements MouseListener,
    MouseMotionListener {
        private int[] pointx = new int[]{2, 7, 1, 5, 6};
        private int[] pointy = new int[]{2, 3, 4, 1, 5};
        private int currentPoint;
        private boolean fill = false;
        private boolean nativeFill = true;
        private Dimension viewport = new Dimension();

        public PolygonPanel() {
            this.viewport.setSize(9, 6);
            this.currentPoint = -1;
            this.fill = false;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void addPoint(boolean before) {
            if (this.currentPoint <= 0 && before) {
                this.addPoint(this.pointx.length, (this.pointx[this.pointx.length - 1] + this.pointx[0]) / 2, (this.pointy[this.pointx.length - 1] + this.pointy[0]) / 2);
            } else if (this.currentPoint <= 0) {
                this.addPoint(1, (this.pointx[1] + this.pointx[0]) / 2, (this.pointy[1] + this.pointy[0]) / 2);
            } else if (this.currentPoint == this.pointx.length - 1 && !before) {
                this.addPoint(this.pointx.length, (this.pointx[this.pointx.length - 1] + this.pointx[0]) / 2, (this.pointy[this.pointx.length - 1] + this.pointy[0]) / 2);
            } else if (before) {
                this.addPoint(this.currentPoint, (this.pointx[this.currentPoint] + this.pointx[this.currentPoint - 1]) / 2, (this.pointy[this.currentPoint] + this.pointy[this.currentPoint - 1]) / 2);
            } else {
                this.addPoint(this.currentPoint + 1, (this.pointx[this.currentPoint] + this.pointx[this.currentPoint + 1]) / 2, (this.pointy[this.currentPoint] + this.pointy[this.currentPoint + 1]) / 2);
            }
        }

        public void delete() {
            if (this.currentPoint >= 0 && this.pointx.length > 2) {
                this.delete(this.currentPoint);
            }
        }

        public boolean isFillMode() {
            return this.fill;
        }

        public void swapFillMode() {
            this.fill = !this.fill;
            this.repaint();
        }

        public void setNativeFill(boolean mode) {
            this.nativeFill = mode;
            if (this.fill) {
                this.repaint();
            }
        }

        private void addPoint(int pos, int x, int y) {
            int i;
            int[] newx = new int[this.pointx.length + 1];
            int[] newy = new int[this.pointx.length + 1];
            for (i = 0; i < pos; ++i) {
                newx[i] = this.pointx[i];
                newy[i] = this.pointy[i];
            }
            newx[pos] = x;
            newy[pos] = y;
            for (i = pos; i < this.pointx.length; ++i) {
                newx[i + 1] = this.pointx[i];
                newy[i + 1] = this.pointy[i];
            }
            this.pointx = newx;
            this.pointy = newy;
            this.currentPoint = pos;
            this.repaint();
        }

        private void delete(int pos) {
            int i;
            int[] newx = new int[this.pointx.length - 1];
            int[] newy = new int[this.pointx.length - 1];
            for (i = 0; i < pos; ++i) {
                newx[i] = this.pointx[i];
                newy[i] = this.pointy[i];
            }
            for (i = pos; i < newx.length; ++i) {
                newx[i] = this.pointx[i + 1];
                newy[i] = this.pointy[i + 1];
            }
            this.pointx = newx;
            this.pointy = newy;
            this.currentPoint = -1;
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            boolean redraw = false;
            if (this.currentPoint >= 0 && !this.checkPointClicked(x, y, this.currentPoint)) {
                this.currentPoint = -1;
                redraw = true;
            }
            for (int i = 0; i < this.pointx.length && this.currentPoint < 0; ++i) {
                if (!this.checkPointClicked(x, y, i)) continue;
                this.currentPoint = i;
                redraw = true;
            }
            if (redraw) {
                this.repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.currentPoint < 0) {
                return;
            }
            this.pointx[this.currentPoint] = e.getX();
            this.pointy[this.currentPoint] = e.getY();
            this.repaint();
        }

        private boolean checkPointClicked(int x, int y, int pointno) {
            return (x -= this.pointx[pointno]) > -7 && x < 7 && (y -= this.pointy[pointno]) > -7 && y < 7;
        }

        private void setScreen(Dimension newscreen) {
            System.out.println("Setting new screensize to <" + newscreen.width + ", " + newscreen.height + ">");
            for (int i = 0; i < this.pointx.length; ++i) {
                this.pointx[i] = this.pointx[i] * newscreen.width / this.viewport.width;
                this.pointy[i] = this.pointy[i] * newscreen.height / this.viewport.height;
            }
            this.viewport.setSize(newscreen);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (!this.viewport.equals(this.getSize())) {
                this.setScreen(this.getSize());
            }
            g.setColor(Color.white);
            g.fillRect(1, 1, this.viewport.width - 2, this.viewport.height - 2);
            g.setColor(Color.black);
            g.drawRect(2, 2, this.viewport.width - 4, this.viewport.height - 4);
            if (this.fill && this.nativeFill) {
                g.setColor(Color.blue);
                g.fillPolygon(this.pointx, this.pointy, this.pointy.length);
            } else if (this.fill) {
                FillPoly.this.fillPolygonDemo(this.pointx, this.pointy, this.pointy.length, g);
            } else {
                for (int i = 0; i < this.pointx.length; ++i) {
                    g.setColor(Color.black);
                    for (int j = 1; j < this.pointx.length; ++j) {
                        g.drawLine(this.pointx[j], this.pointy[j], this.pointx[j - 1], this.pointy[j - 1]);
                    }
                    g.drawLine(this.pointx[this.pointx.length - 1], this.pointy[this.pointx.length - 1], this.pointx[0], this.pointy[0]);
                    if (i == this.currentPoint) {
                        g.setColor(Color.red);
                        g.drawLine(this.pointx[i] - 3, this.pointy[i] - 3, this.pointx[i] + 3, this.pointy[i] + 3);
                        g.drawLine(this.pointx[i] - 3, this.pointy[i] + 3, this.pointx[i] + 3, this.pointy[i] - 3);
                        g.drawLine(this.pointx[i] - 5, this.pointy[i], this.pointx[i] + 5, this.pointy[i]);
                        g.drawLine(this.pointx[i], this.pointy[i] - 5, this.pointx[i], this.pointy[i] + 5);
                        continue;
                    }
                    g.setColor(i > 0 ? Color.black : Color.blue);
                    g.drawLine(this.pointx[i] - 5, this.pointy[i], this.pointx[i] + 5, this.pointy[i]);
                    g.drawLine(this.pointx[i], this.pointy[i] - 5, this.pointx[i], this.pointy[i] + 5);
                }
            }
        }
    }
}

