/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;

public class DriveCar
extends VisualTestImpl {
    public String getHelpText() {
        return "To be successful, this test should show a white background, a red moving Corvette with awhite label \"ACUNIA\" on it, the Corvette should move diagonally from the upper right corner of your screen, to its lower left corner. The car disappears bit by bit at the left border of the screen, and then re-appears bit by bit at the right border.";
    }

    public Panel getPanel(VisualTester vte) {
        this.vt = vte;
        return new Place(this.getBounds().width, this.getBounds().height, Color.white);
    }

    public void start(Panel p, boolean autorun) {
        try {
            new Thread((Runnable)((Place)p), "DriveCar Thread").start();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void stop(Panel p) {
        try {
            ((Place)p).stop = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new DriveCar();
    }

    class Place
    extends Panel
    implements Runnable {
        Image bgBuffer = null;
        Image carImage = null;
        Graphics g1 = null;
        int x = 0;
        int y = 10000;
        int xo = 0;
        int yo = 0;
        boolean stop = false;

        Place(int width, int height, Color background) {
            this.setSize(width, height);
            this.setBackground(background);
            String path = System.getProperty("property.path", "/test");
            this.carImage = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(path + "/car-image.png"));
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            int w = this.carImage.getWidth(null);
            int h = this.carImage.getHeight(null);
            if (this.bgBuffer == null || this.bgBuffer.getWidth(null) != w || this.bgBuffer.getHeight(null) != h) {
                this.bgBuffer = this.createImage(w, h);
                if (this.bgBuffer != null) {
                    this.g1 = this.bgBuffer.getGraphics();
                    this.g1.clearRect(0, 0, w, h);
                    g.clearRect(0, 0, this.getBounds().width, this.getBounds().height);
                }
            }
            if (this.bgBuffer != null) {
                g.drawImage(this.bgBuffer, this.xo, this.yo, this.xo + w - 1, this.yo + h - 1, 0, 0, w - 1, h - 1, null);
                g.drawImage(this.carImage, this.x, this.y, null);
            }
        }

        public void run() {
            int xb = 0;
            int yb = 0;
            int xStep = -4;
            int yStep = 1;
            int xe = 0;
            int xtest = 400;
            try {
                while (xb == 0 || xe == 0 || xtest != xb) {
                    if (xb != 0) {
                        xtest = xb;
                    }
                    Thread.sleep(100L);
                    xb = this.getBounds().width - 1;
                    yb = 0;
                    xe = -this.carImage.getWidth(null);
                }
                this.x = xb;
                this.y = yb;
                while (!this.stop) {
                    this.repaint();
                    Thread.sleep(40L);
                    this.xo = this.x;
                    this.yo = this.y;
                    this.x += xStep;
                    this.y += yStep;
                    if (this.x > xe) continue;
                    this.x = xb;
                    this.y = yb;
                }
            }
            catch (Exception e) {
                System.out.println("caught unwanted Exception " + e);
                e.printStackTrace();
            }
        }
    }
}

