/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.Component.PaintComponent;
import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ComponentUpdateBackground
extends VisualTestImpl
implements ActionListener {
    private ImplicitPaintComponent panelImplicit;
    private ExplicitGetPaintComponent panelExplicitGet;
    private ExplicitSetPaintComponent panelExplicitSet;
    private Button background;
    private Checkbox backgroundImplicit;
    private Checkbox backgroundExplicitGet;
    private Checkbox backgroundExplicitSet;
    private Checkbox backgroundAll;
    private Checkbox alsoRepaint;
    private int currentBackground;
    private List display;

    public ComponentUpdateBackground() {
        this.setLayout(new BorderLayout());
        this.currentBackground = 0;
        this.setBackground(PaintComponent.MIDCOLORS[0]);
        this.setForeground(PaintComponent.CONTRASTCOLORS[0]);
        this.display = new List(5, false);
        this.display.add("click on the background button");
        this.display.add("to see the paint() -and update() events");
        this.display.add("when changing the background of the selected panels");
        this.add((Component)this.display, "South");
        Panel top = new Panel(new GridLayout(2, 4));
        top.add(new Label());
        this.background = new Button("change background()...");
        this.background.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
        this.background.addActionListener(this);
        top.add(this.background);
        top.add(new Label());
        this.alsoRepaint = new Checkbox("also repaint()");
        top.add(this.alsoRepaint);
        this.backgroundImplicit = new Checkbox("Implicit panel");
        top.add(this.backgroundImplicit);
        this.backgroundExplicitGet = new Checkbox("Explicit get");
        top.add(this.backgroundExplicitGet);
        this.backgroundExplicitSet = new Checkbox("Explicit set");
        top.add(this.backgroundExplicitSet);
        this.backgroundAll = new Checkbox("whole screen");
        top.add(this.backgroundAll);
        this.add((Component)top, "North");
        Panel components = new Panel(new GridLayout(1, 3));
        this.panelImplicit = new ImplicitPaintComponent("framework background");
        this.panelImplicit.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
        components.add(this.panelImplicit);
        this.panelExplicitGet = new ExplicitGetPaintComponent("getBackground()");
        this.panelExplicitGet.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
        components.add(this.panelExplicitGet);
        this.panelExplicitSet = new ExplicitSetPaintComponent("setBackground()");
        this.panelExplicitSet.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
        components.add(this.panelExplicitSet);
        this.add((Component)components, "Center");
    }

    public void actionPerformed(ActionEvent evt) {
        this.display.removeAll();
        this.display.add("Sending setBackground()-command to selected components");
        if (this.alsoRepaint.getState()) {
            this.display.add("also sending repaint() command");
        }
        this.currentBackground = (this.currentBackground + 1) % PaintComponent.COLORCOUNT;
        if (this.backgroundAll.getState()) {
            this.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
            this.setForeground(PaintComponent.CONTRASTCOLORS[this.currentBackground]);
            if (this.alsoRepaint.getState()) {
                this.repaint();
            }
        } else {
            this.background.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
            this.background.setForeground(PaintComponent.CONTRASTCOLORS[this.currentBackground]);
        }
        if (this.backgroundImplicit.getState()) {
            this.panelImplicit.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
            if (this.alsoRepaint.getState()) {
                this.panelImplicit.repaint();
            }
        }
        if (this.backgroundExplicitGet.getState()) {
            this.panelExplicitGet.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
            if (this.alsoRepaint.getState()) {
                this.panelExplicitGet.repaint();
            }
        }
        if (this.backgroundExplicitSet.getState()) {
            this.panelExplicitSet.setBackground(PaintComponent.MIDCOLORS[this.currentBackground]);
            if (this.alsoRepaint.getState()) {
                this.panelExplicitSet.repaint();
            }
        }
        this.display.repaint();
    }

    public String getHelpText() {
        return "A test on the interaction between the update() and paint() commands when changing the background of a component\n Three components in the center area receive paint() and update() commands. On a paint() command they draw a dark rectangle on the screen and in that display the number of updates and paints up to now. On an update command, they do the same, but for a lighter screen rectangle.\nAround the rectangle there is a border that should be painted in the current component's background color.\n(The colors change in order of the colors of the rainbow: red-orange-yellow-green-blue-indigo-violet... and then red again)\nThe <background> keys changes the background of selected components. The checkboxes allow you to specify of which components the background will be changed: the left, middle, right component, or the whole test frame.\nWith the repaint-checkbox, you can also set a repaint-command to the components selected.\nThe three display components vary in the way they paint their background:\n -> The left implicit panel does not paint the background at all, but leaves the painting to the framework\n -> The center getBackground panel explicitly paints the screen in the color retrieved by a call to getBackground() -> The center setBackground panel explicitly catches the setBackground() comand and stores the new background color as a separate variable. When painting or updating, it explicitly paints the screen in that colorTry various combinations of changing the background color and repainting and regard the calls to update() and paint() displayed in the list below";
    }

    class ExplicitSetPaintComponent
    extends PaintComponent {
        private Color screenBackground = this.getBackground();

        public ExplicitSetPaintComponent(String text) {
            super(text, ComponentUpdateBackground.this.display);
        }

        public void setBackground(Color newbackground) {
            this.screenBackground = newbackground;
            ComponentUpdateBackground.this.display.add(this.name + ": set background to " + newbackground);
        }

        protected boolean paintArea(Color background, Color foreground, Graphics g) {
            boolean calculated = false;
            if (this.frameRect.width <= 0) {
                this.frameRect.setBounds(0, 0, this.getSize().width, this.getSize().height);
                calculated = true;
            }
            g.setColor(this.screenBackground);
            g.fillRect(0, 0, this.frameRect.width - 1, this.frameRect.height - 1);
            g.setColor(background);
            g.fillRect(5, 5, this.frameRect.width - 10, this.frameRect.height - 10);
            g.setColor(foreground);
            g.drawString(this.name, 10, 20);
            g.drawString("updates " + this.updateCount, 10, 35);
            g.drawString("paints = " + this.paintCount, 10, 50);
            return calculated;
        }
    }

    class ExplicitGetPaintComponent
    extends PaintComponent {
        public ExplicitGetPaintComponent(String text) {
            super(text, ComponentUpdateBackground.this.display);
        }

        public void setBackground(Color newbackground) {
            super.setBackground(newbackground);
            ComponentUpdateBackground.this.display.add(this.name + ": set background to " + newbackground);
        }

        protected boolean paintArea(Color background, Color foreground, Graphics g) {
            boolean calculated = false;
            if (this.frameRect.width <= 0) {
                this.frameRect.setBounds(0, 0, this.getSize().width, this.getSize().height);
                calculated = true;
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.frameRect.width - 1, this.frameRect.height - 1);
            g.setColor(background);
            g.fillRect(5, 5, this.frameRect.width - 10, this.frameRect.height - 10);
            g.setColor(foreground);
            g.drawString(this.name, 10, 20);
            g.drawString("updates " + this.updateCount, 10, 35);
            g.drawString("paints = " + this.paintCount, 10, 50);
            return calculated;
        }
    }

    class ImplicitPaintComponent
    extends PaintComponent {
        public ImplicitPaintComponent(String text) {
            super(text, ComponentUpdateBackground.this.display);
        }

        public void setBackground(Color newbackground) {
            super.setBackground(newbackground);
            ComponentUpdateBackground.this.display.add(this.name + ": set background to " + newbackground);
        }
    }
}

