/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.Component.PaintComponent;
import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ComponentUpdate
extends VisualTestImpl
implements ActionListener {
    private InnerComponent innerComponent;
    private InnerPaintComponent paintComponent;
    private Button repaint;
    private List display;

    public void actionPerformed(ActionEvent evt) {
        this.display.removeAll();
        this.display.add("Sending repaint()-command without bounds for whole screen");
        this.innerComponent.repaint();
        this.paintComponent.repaint();
    }

    private final void displayMessage(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(message, 0);
    }

    public String getHelpText() {
        return "A test on the interaction between the update() and paint() commands in different situations\n The main part of this test are the two central Components. To refresh the content of the components, a paint() and an update() function are implemented, both painting the current clipping bound in a background color and also displaying the number of paints and updates made:\nWith each paint() or update() the background color changes along the colors of the rainbow (red, orange, yellow....) Paint commands display white text on dark colors, update-commands black text on light colors. Like this it is possible to see wether the clipping area is being paint()-ed or update()-ed \n(If the clipping bound is <NULL>, it is being replaced by the complete screen)\n\nThere are two display component. One derived from Component, the other from an extern class PaintComponent. For some reason the Sunsdk always sends a call tp paint() to the external PaintComponent, even on a call to repaint() when the inner component receives a call to update()";
    }

    public void main(String[] args) {
        Frame main = new Frame("Component paint test");
        main.setSize(400, 234);
        main.add(new ComponentUpdate());
        main.show();
    }

    public ComponentUpdate() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(16, 16, 48));
        this.setForeground(Color.white);
        Panel top = new Panel(new FlowLayout());
        this.repaint = new Button("repaint()...");
        this.repaint.addActionListener(this);
        top.add(this.repaint);
        this.add((Component)top, "North");
        this.display = new List(5, false);
        this.add((Component)this.display, "South");
        Panel components = new Panel(new GridLayout(1, 2));
        this.innerComponent = new InnerComponent();
        components.add(this.innerComponent);
        this.paintComponent = new InnerPaintComponent();
        components.add(this.paintComponent);
        this.add((Component)components, "Center");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class InnerComponent
    extends Panel {
        protected Rectangle bounds;
        protected int updateCount = 0;
        protected int paintCount = 0;
        protected Rectangle frameRect = new Rectangle();

        public void paint(Graphics g) {
            ComponentUpdate.this.display.add("Inner class: Received call to paint()");
            ++this.paintCount;
            if (this.paintArea(PaintComponent.DARKCOLORS[(this.paintCount - 1) % PaintComponent.COLORCOUNT], Color.white, g)) {
                ComponentUpdate.this.display.add("Inner class: on paint() calculated sizes");
            }
            ComponentUpdate.this.display.add("Inner class: paint() executed, total paints = " + this.paintCount);
        }

        public void update(Graphics g) {
            ComponentUpdate.this.display.add("Inner class: Received call to update()");
            ++this.updateCount;
            if (this.paintArea(PaintComponent.LIGHTCOLORS[(this.updateCount - 1) % PaintComponent.COLORCOUNT], Color.black, g)) {
                ComponentUpdate.this.display.add("Inner class: on update() calculated sizes");
            }
            ComponentUpdate.this.display.add("Inner class: update() executed, total updates = " + this.updateCount);
        }

        private final boolean paintArea(Color background, Color foreground, Graphics g) {
            this.bounds = g.getClipBounds();
            boolean calculated = false;
            if (this.frameRect.width <= 0) {
                this.frameRect.setBounds(0, 0, this.getSize().width, this.getSize().height);
                calculated = true;
            }
            if (this.bounds == null) {
                this.bounds = this.frameRect;
                ComponentUpdate.this.display.add("NULL bounds: Reverting to full screen (0, 0, " + this.bounds.width + ", " + this.bounds.height + ')');
            } else {
                ComponentUpdate.this.display.add("bounds (" + this.bounds.x + ", " + this.bounds.y + ", " + this.bounds.width + ", " + this.bounds.height + ')');
            }
            g.setColor(background);
            g.fillRect(5, 5, this.frameRect.width - 10, this.frameRect.height - 10);
            g.setColor(foreground);
            g.drawString("Paint component:", 10, 20);
            g.drawString("updates " + this.updateCount, 10, 35);
            g.drawString("paints = " + this.paintCount, 10, 50);
            return calculated;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class InnerPaintComponent
    extends PaintComponent {
        private Rectangle bounds;

        protected boolean paintArea(Color background, Color foreground, Graphics g) {
            this.bounds = g.getClipBounds();
            boolean calculated = false;
            if (this.frameRect.width <= 0) {
                this.frameRect.setBounds(0, 0, this.getSize().width, this.getSize().height);
                calculated = true;
            }
            if (this.bounds == null) {
                this.bounds = this.frameRect;
                ComponentUpdate.this.display.add("NULL bounds: Reverting to full screen (0, 0, " + this.bounds.width + ", " + this.bounds.height + ')');
            } else {
                ComponentUpdate.this.display.add("bounds (" + this.bounds.x + ", " + this.bounds.y + ", " + this.bounds.width + ", " + this.bounds.height + ')');
            }
            g.setColor(background);
            g.fillRect(5, 5, this.frameRect.width - 10, this.frameRect.height - 10);
            g.setColor(foreground);
            g.drawString("Paint component:", 10, 20);
            g.drawString("updates " + this.updateCount, 10, 35);
            g.drawString("paints = " + this.paintCount, 10, 50);
            return calculated;
        }

        public InnerPaintComponent() {
            super("PaintComponent", ComponentUpdate.this.display);
        }
    }
}

