/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ComponentRepaint2
extends VisualTestImpl
implements MouseListener {
    private CustomComponent c1;
    private CustomComponent c2;
    private CustomComponent c3;

    public ComponentRepaint2() {
        this.setLayout(new BorderLayout());
        Panel p1 = new Panel();
        p1.setLayout(null);
        p1.setBackground(Color.black);
        this.c1 = new CustomComponent(new Color(255, 0, 0));
        this.c2 = new CustomComponent(new Color(255, 255, 0));
        this.c3 = new CustomComponent(new Color(0, 255, 0));
        p1.add(this.c1);
        p1.add(this.c2);
        p1.add(this.c3);
        this.c1.setBounds(10, 10, 50, 50);
        this.c2.setBounds(50, 30, 50, 50);
        this.c3.setBounds(90, 50, 50, 50);
        this.c1.addMouseListener(this);
        this.c2.addMouseListener(this);
        this.c3.addMouseListener(this);
        Label l1 = new Label("  How it is...");
        l1.setForeground(Color.white);
        l1.setBackground(Color.black);
        Panel p3 = new Panel();
        p3.setLayout(new BorderLayout());
        p3.add((Component)p1, "Center");
        p3.add((Component)l1, "North");
        Label l2 = new Label("  And how it should be...");
        l2.setForeground(Color.white);
        l2.setBackground(Color.black);
        ReferenceComponent r = new ReferenceComponent();
        Panel p4 = new Panel();
        p4.setLayout(new BorderLayout());
        p4.add((Component)r, "Center");
        p4.add((Component)l2, "North");
        Panel p2 = new Panel();
        p2.setLayout(new GridLayout(1, 3));
        Button b1 = new Button("Repaint Red");
        Button b2 = new Button("Repaint Yellow");
        Button b3 = new Button("Repaint Green");
        p2.add(b1);
        p2.add(b2);
        p2.add(b3);
        b1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentRepaint2.this.c1.repaint();
            }
        });
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentRepaint2.this.c2.repaint();
            }
        });
        b3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentRepaint2.this.c3.repaint();
            }
        });
        this.add((Component)p2, "South");
        this.add((Component)p3, "Center");
        this.add((Component)p4, "East");
        new Thread(){

            public void run() {
                try {
                    4.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ComponentRepaint2.this.c2.repaint();
            }
        }.start();
    }

    public String getHelpText() {
        return "This is a test for repainting overlapping components.\nNormally the left and the right set of squares should look exactly the same.\nThe set on the left is built with Components, the set on the right is drawn on a Graphics.\nBy pressing the buttons you can trigger repaints of the squares on the left.\nThey should always remain overlapping as the squares on the right\n";
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.getSource() == this.c1) {
            this.c1.setHighlight(true);
        } else if (event.getSource() == this.c2) {
            this.c2.setHighlight(true);
        } else if (event.getSource() == this.c3) {
            this.c3.setHighlight(true);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.getSource() == this.c1) {
            this.c1.setHighlight(false);
        } else if (event.getSource() == this.c2) {
            this.c2.setHighlight(false);
        } else if (event.getSource() == this.c3) {
            this.c3.setHighlight(false);
        }
    }

    public class ReferenceComponent
    extends Component {
        public void paint(Graphics g) {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(new Color(0, 255, 0));
            g.fillRect(90, 50, 50, 50);
            g.setColor(new Color(255, 255, 0));
            g.fillRect(50, 30, 50, 50);
            g.setColor(new Color(255, 0, 0));
            g.fillRect(10, 10, 50, 50);
        }

        public Dimension getPreferredSize() {
            return new Dimension(150, 100);
        }
    }

    public class CustomComponent
    extends Component {
        private Color color;
        private boolean highlight;

        public CustomComponent(Color color) {
            this.color = color;
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            if (this.highlight) {
                g.setColor(this.color.darker().darker());
            } else {
                g.setColor(this.color);
            }
            g.fillRect(0, 0, size.width, size.height);
        }

        public void setHighlight(boolean mode) {
            this.highlight = mode;
            this.repaint();
        }
    }
}

