/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Choice;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ChoiceTest
extends VisualTestImpl
implements ActionListener,
ItemListener {
    private TextField newItem;
    private Button addButton;
    private Choice items;
    private Label selection;
    private Button removeButton;
    private int selectedIndex;
    private static final int ITEMCOUNT = 10;
    private static final String ITEMNAME = "item";

    public ChoiceTest() {
        this(10, ITEMNAME);
    }

    public ChoiceTest(int itemcount, String itemname) {
        this.setLayout(new BorderLayout());
        Panel top = new Panel(new GridLayout(2, 1));
        this.newItem = new TextField();
        top.add(this.newItem);
        this.addButton = new Button("add this");
        this.addButton.addActionListener(this);
        top.add(this.addButton);
        this.add((Component)top, "North");
        this.items = new Choice();
        this.items.addItemListener(this);
        this.add((Component)this.items, "Center");
        Panel bottom = new Panel(new GridLayout(2, 1));
        this.selection = new Label("No selection made yet");
        this.selectedIndex = -1;
        bottom.add(this.selection);
        this.removeButton = new Button("remove this");
        this.removeButton.addActionListener(this);
        bottom.add(this.removeButton);
        this.add((Component)bottom, "South");
        for (int i = 0; i < itemcount; ++i) {
            this.items.add(itemname + "_" + i);
        }
    }

    public String getHelpText() {
        return "A test for class 'Choice'. The central part of the panel shows a Choice that can be expanded by pressing its right button. At the top of the panel, a textfield allows you to enter the label of a new element for the choice. The new element can be added by pressing the button labeled 'add this', below the textfield.At the bottom of the panel another button labeled 'remove this' allows to remove the selected element from the choice. The selected element is indicated in the central part of the panel, above the 'remove' button.";
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addButton && this.newItem.getText() != "") {
            this.items.add(this.newItem.getText());
        } else if (evt.getSource() == this.removeButton && this.selectedIndex >= 0) {
            this.items.remove(this.selectedIndex);
            this.selectedIndex = -1;
            this.items.select(-1);
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        this.selectedIndex = this.items.getSelectedIndex();
        this.selection.setText((evt.getStateChange() == 1 ? "selected :" : "deselected :") + evt.getItem());
    }
}

