/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Button;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.ActionDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ActionCommandTest
extends VisualTestImpl
implements ActionListener,
ItemListener {
    static final Color DARKRED = new Color(128, 32, 32);
    static final Color DARKGREEN = new Color(32, 128, 32);
    static final Color DARKBLUE = new Color(32, 32, 128);
    static final String RED = "<RED>";
    static final String BLUE = "<BLUE>";
    static final String GREEN = "<GREEN>";
    private Button clickme;
    private Checkbox setRed;
    private Checkbox setGreen;
    private Checkbox setBlue;
    private Checkbox setNULL;
    private TextField commandDisplay;
    private List eventDisplay;

    public ActionCommandTest() {
        this.setBackground(new Color(64, 64, 64));
        this.setForeground(Color.white);
        this.setLayout(new BorderLayout());
        this.clickme = new Button("Click Me");
        this.clickme.addActionListener(this);
        this.add((Component)this.clickme, "Center");
        Panel radio = new Panel(new GridLayout(6, 1));
        CheckboxGroup group = new CheckboxGroup();
        this.setRed = new Checkbox("setActionCommand(<RED>)", false, group);
        this.setRed.addItemListener(this);
        radio.add(this.setRed);
        this.setGreen = new Checkbox("setActionCommand(<GREEN>)", false, group);
        this.setGreen.addItemListener(this);
        radio.add(this.setGreen);
        this.setBlue = new Checkbox("setActionCommand(<BLUE>)", false, group);
        this.setBlue.addItemListener(this);
        radio.add(this.setBlue);
        this.setNULL = new Checkbox("setActionCommand(NULL)", true, group);
        this.setNULL.addItemListener(this);
        radio.add(this.setNULL);
        radio.add(new Label("getActionCommand returns :", 1));
        this.commandDisplay = new TextField(this.clickme.getActionCommand());
        radio.add(this.commandDisplay);
        this.add((Component)radio, "East");
        this.eventDisplay = new List(3, false);
        this.eventDisplay.setBackground(new Color(180, 180, 112));
        this.eventDisplay.add("Your ActionEvents displayed HERE");
        this.add((Component)this.eventDisplay, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        String[] messagestrings = ActionDisplay.displayActionEvent(evt);
        this.eventDisplay.removeAll();
        for (int i = messagestrings.length - 1; i >= 0; --i) {
            this.eventDisplay.add(messagestrings[i], 0);
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.setRed) {
            this.clickme.setActionCommand(RED);
            this.clickme.setBackground(DARKRED);
        } else if (source == this.setGreen) {
            this.clickme.setActionCommand(GREEN);
            this.clickme.setBackground(DARKGREEN);
        } else if (source == this.setBlue) {
            this.clickme.setActionCommand(BLUE);
            this.clickme.setBackground(DARKBLUE);
        } else {
            this.clickme.setActionCommand(null);
            this.clickme.setBackground(this.getBackground());
        }
        this.commandDisplay.setText(this.clickme.getActionCommand());
    }

    public String getHelpText() {
        return "The aim: test the setting and retrieving of a button's Action command:\n\nThe test:\n => Use the radio buttons on the right to set the button's action command to <red>, <green> and <blue> respectingly using the function < Button.setActionCommand() >:\n Directly afterwards the test makes a call to < Button.getActionCommand() > to display the new action command on the text area\n => click the button to throw an ActionPerformed() event and see the contents of that call's ActionEvent in the list below.\n\nItems to test:\n => the action command in the text box should match the strings <RED>, <GREEN> or <BLUE> set by the setActionCommand() function or should match the button's label 'Click me' if setActioncommand(null) was called\n => Also the contents of the text box should be returned in line two of the list as a result of ActionEvent.getActioncommand() every time the button is clicked (and a new ActionEvent is thrown)";
    }
}

