/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt;

import com.acunia.wonka.test.awt.VTELogger;
import com.acunia.wonka.test.awt.VisualTestEngine;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AutoRunner
implements Runnable {
    private boolean stop;
    private boolean exit;
    private long runtime;
    private long sleep;
    private VisualTestEngine vte;

    public void stop() {
        System.out.println("Stopping autorun");
        this.stop = true;
    }

    public void run() {
        if (this.sleep < 0L) {
            this.benchMark();
        }
        try {
            while (!this.stop) {
                this.vte.nextAuto();
                try {
                    Thread.sleep(this.sleep);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this.runtime == 0L || this.runtime >= System.currentTimeMillis()) continue;
                if (this.exit && !this.stop) {
                    System.out.println("Autorun timeout expired --> shutting down VTE");
                    VTELogger.logMessage("Autorun timeout expired --> shutting down VTE", true);
                    System.exit(0);
                }
                this.stop = true;
            }
            this.vte.stop();
        }
        catch (Throwable t) {
            this.vte.autorun = false;
            VTELogger.reportException("AutoRunner: Autorun thread is stopped due to exception", t, true);
        }
        VTELogger.logMessage("stopping autorun ...", true);
    }

    public void benchMark() {
        long time = System.currentTimeMillis();
        int count = 0;
        int testNeeded = (int)(-this.sleep);
        try {
            while (!this.stop && count < testNeeded) {
                this.vte.nextAuto();
                ++count;
            }
        }
        catch (Throwable t) {
            VTELogger.reportException("AutoRunner: Autorun thread benchMark is stopped due to exception", t, true);
        }
        this.vte.autorun = false;
        long endtime = System.currentTimeMillis() - time;
        String report = "stopping benchMark ...\nran " + count + " tests (needed " + testNeeded + ")\ntime elapsed = " + endtime;
        System.out.println(report);
        VTELogger.logMessage(report, true);
    }

    private final /* synthetic */ void this() {
        this.stop = false;
    }

    public AutoRunner(VisualTestEngine vte, long sleep, long runtime, boolean exitAferAutorun) {
        this.this();
        this.vte = vte;
        this.sleep = sleep;
        this.runtime = runtime;
        this.exit = exitAferAutorun;
        if (runtime != 0L) {
            this.runtime = System.currentTimeMillis() + runtime * 60L * 1000L;
        }
        Thread t = new Thread(VisualTestEngine.tg, this, sleep < 0L ? "AutoRunner -- benchMark" : "AutoRunner");
        t.setPriority(6);
        t.start();
        VTELogger.logMessage("starting Autorun ...\n", false);
    }
}

