/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class NoLayout
extends VisualTestImpl
implements ActionListener {
    Panel flow1 = new Panel();
    Panel nolo1 = new Panel();
    Panel flow2 = new Panel();
    Panel nolo2 = new Panel();

    public NoLayout() {
        this.flow1.setLayout(new FlowLayout());
        this.nolo1.setLayout(null);
        this.flow2.setLayout(new FlowLayout());
        this.nolo2.setLayout(null);
        this.flow1.setFont(new Font("helvR12", 0, 12));
        this.nolo1.setFont(new Font("helvR12", 0, 12));
        this.flow2.setFont(new Font("helvB20", 1, 20));
        this.nolo2.setFont(new Font("helvB20", 1, 20));
        this.addComp1("Button", new Button("Button"));
        this.addComp1("TextArea", new Button("TextArea"));
        this.addComp1("List", new Button("List"));
        this.addComp2("Button", new Button("Button"), 1, 1, 60, 40);
        this.addComp2("TextArea", new Button("TextArea"), 65, 1, 60, 40);
        this.addComp2("List", new Button("List"), 129, 1, 60, 40);
        this.setLayout(new GridLayout(4, 1));
        this.add(this.flow1);
        this.add(this.flow2);
        this.add(this.nolo1);
        this.add(this.nolo2);
    }

    void addComp1(String label, Component c) {
        Button a = new Button(label);
        Button b = new Button(label);
        this.flow1.add(a);
        this.flow2.add(b);
        a.addActionListener(this);
        b.addActionListener(this);
    }

    void addComp2(String label, Component c, int x, int y, int w, int h) {
        Button a = new Button(label);
        Button b = new Button(label);
        a.setBounds(x, y, w, h);
        b.setBounds(x, y, w, h);
        this.nolo1.add(a);
        this.nolo2.add(b);
        a.addActionListener(this);
        b.addActionListener(this);
    }

    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
    }

    public String getHelpText() {
        return "The program shows, in default gray colors, a grid flow of four rows, one column. Each row containing three buttons, labeled \"Button\", \"TextArea\" and \"List\". The two upper rows of buttons use a flow layout, for the two lower rows, a \"null\" layout manager was set. One should see that the buttons of row 1 and 2 are arranged symmetrically around the center of these rows, while the buttons of row 3 and 4 are left aligned. The size of the buttons of row 1 and 2 was set automatically, while the size of the buttons in row 3 and 4 had to be set manually. We forgot, on purpose, to resize the buttons of row 4 for the bigger font. As a result the labels of the first two buttons are partially visible.";
    }
}

