/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.layout.GridLayoutPositions;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;

public class FlowLayoutPositions
extends GridLayoutPositions {
    public FlowLayoutPositions() {
        this.setBackground(Color.black);
        this.setForeground(Color.yellow);
        this.setLayout(new BorderLayout());
        Panel main = new Panel(new GridLayout(3, 2));
        Button a = this.locationButton("<A>", Color.red, "element <A> added first by position of add()");
        Button b = this.locationButton("<B>", Color.green, "element <B> added second by position of add()");
        Button c = this.locationButton("<C>", Color.blue, "element <C> added third by position of add()");
        Button d = this.locationButton("<D>", Color.yellow, "element <D> added last by position of add()");
        Button title = this.locationButton("Reference layout add()", Color.black, "Layout built in sequence <A>,<B>,<C>,<D> using add()");
        main.add(this.buildLayout(title, SMOKE, new FlowLayout(), a, b, c, d));
        a = this.locationButton("<A>", Color.red, "element <A> added first to last place in list using add(-1)");
        b = this.locationButton("<B>", Color.green, "element <B> added second to last place in list using add(-1)");
        c = this.locationButton("<C>", Color.blue, "element <C> added third to last place in list using add(-1)");
        d = this.locationButton("<D>", Color.yellow, "element <D> added last to last place in list using add()");
        title = this.locationButton("positioned default by add(-1)", Color.black, "Components added in sequence <A>,<B>,<C>,<D> using add(-1)");
        main.add(this.buildLayout(title, RUST, new FlowLayout(), a, -1, b, -1, c, -1, d, -1));
        a = this.locationButton("<A>", Color.red, "element <A> added last by position of add()");
        b = this.locationButton("<B>", Color.green, "element <B> added third by position of add()");
        c = this.locationButton("<C>", Color.blue, "element <C> added second by position of add()");
        d = this.locationButton("<D>", Color.yellow, "element <D> added first by position of add()");
        title = this.locationButton("Inverse layout", Color.black, "Layout built in sequence <D>,<C>,<B>,<A> using add()");
        main.add(this.buildLayout(title, RUST, new FlowLayout(), d, c, b, a));
        a = this.locationButton("<A>", Color.red, "element <A> added first using add(0)");
        b = this.locationButton("<B>", Color.green, "element <B> added second  to (then) first place in list using add(0)");
        c = this.locationButton("<C>", Color.blue, "element <C> added third to (then) first place in list using add(0)");
        d = this.locationButton("<D>", Color.yellow, "element <D> added fourth to (then) first place in list using add(0)");
        title = this.locationButton("Positioned first by add(0)", Color.black, "Components added in sequence <A>,<B>,<C>,<D>/new added first in list using add(0)");
        main.add(this.buildLayout(title, SMOKE, new FlowLayout(), a, 0, b, 0, c, 0, d, 0));
        a = this.locationButton("<A>", Color.red, "element <A> added first by position of add()");
        b = this.locationButton("<B>", Color.green, "element <B> added second by position of add()");
        c = this.locationButton("<C>", Color.blue, "element <C> added fourth by position of add()");
        d = this.locationButton("<D>", Color.yellow, "element <D> added third by add() sequence");
        title = this.locationButton("<A>,<B>,<D>,<C> by adding order", Color.black, "Layout built in sequence <A>,<B>,<D>,<C> using add()");
        main.add(this.buildLayout(title, SMOKE, new FlowLayout(), a, b, d, c));
        a = this.locationButton("<A>", Color.red, "element <A> added first to first place in list using add(0)");
        b = this.locationButton("<B>", Color.green, "element <B> added second to second place in list using add(1)");
        c = this.locationButton("<C>", Color.blue, "element <C> added third to third place using add(2), moved up when adding <D>");
        d = this.locationButton("<D>", Color.yellow, "element <D> added fourth to third place in list using add(2)");
        title = this.locationButton("<D> third by add(2)", Color.black, "Components added in sequence <A>,<B>,<C>,<D> using add(2) to set <D> third in list");
        main.add(this.buildLayout(title, RUST, new FlowLayout(), a, 0, b, 1, c, 2, d, 2));
        this.add((Component)main, "Center");
        this.display = new List(3, false);
        this.display.setForeground(Color.white);
        this.display.add("Click on a button to see its construction");
        this.add((Component)this.display, "South");
    }

    public String getHelpText() {
        return "A test to verify Rudolph's implementation of the Container.add(Component, position) form in a FlowLayout :\n\nThe form add(component) by default adds a component on the back of the component list for the specific layout,The form add(component, pos) adds the component at the desired position in the internal component list. As the FlowLayout manager uses its internal list of elements to calculate which element to come on which position, you can change the layout consideranbly by specifying a distinctive position in the add(Component, position) form just as you can define the layout by the order the add(component) commands are received\n\nThis test shows three rows of two panels. All panels try to place four elements <A> to <D> in a 1-row 4-column GridLayout. Of each row, the left panel will specify the layout by using four calls to add(element) in a distinctive order. The rigth panel will add the elements in fixed order <A>,<B>,<C> and <D> but use the form add(element, position) to specify a distinctive position in the internal layout list \n=> the topleft panel will add the elements in order <A>,<B>,<C> and <D> using the simple add(element), the topright panel will also add the elements in order <A>,<B>,<C> and <D>, using the form add(elements,-1) to add all elements to the end of the list by default.\n\n=> the center left panel will add the elements in inverse order <D>,<C>,<B>,<A> (using add(element) ), the center right panel will also add the elements in order <A>,<B>,<C> and <D>, but use the form add(elements,0) to add every element to start of the list, thus creating an internal list <D>,<C>,<B>,<A>.\n\n=> the bottomleft panel will add the elements in order <A>,<B>,<D>,<C> (using add(element) ), the bottomright panel will create an internal list of that form by adding the elements in order <A>+<B>+<C>+<D>, using add(element, positon)  with positions 0,1 and 2 for the <A>,<B> and <C>-elements and 2 to add the <D>-element on third position, (moving the <C> element one position up)\n\nIN ALL OF THESE CASES YOU SHOULD SEE THE RIGHT SIDE PANELS DISPLAYING COMPLETELY THE SAME IMAGES AS THEIR CORRESPONDING LEFT ONES";
    }
}

