/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.layout.CardLayoutPositions;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CardLayoutOverlay
extends CardLayoutPositions
implements ActionListener {
    private Button next;
    private int current;
    private TextField showing;
    private Button buttonOne;
    private Button buttonTwo;
    private CardLayout layout1;
    private CardLayout layout2;
    private CardLayout layout3;
    private CardLayout layout4;
    private CardLayout layout5;
    private CardLayout layout6;
    private Panel panel1;
    private Panel panel2;
    private Panel panel3;
    private Panel panel4;
    private Panel panel5;
    private Panel panel6;
    private static final String CARDONE = "card <ONE>";
    private static final String CARDTWO = "card <TWO>";

    public CardLayoutOverlay() {
        this.setBackground(Color.black);
        this.setForeground(Color.yellow);
        this.setLayout(new BorderLayout());
        Panel buttons = new Panel(new GridLayout(8, 1));
        buttons.add(new Label());
        this.next = new Button("Next panel");
        this.next.addActionListener(this);
        this.next.setEnabled(true);
        buttons.add(this.next);
        buttons.add(new Label("Showing Panel"));
        this.showing = new TextField(" 0 of 0");
        buttons.add(this.showing);
        buttons.add(new Label());
        this.buttonOne = new Button(CARDONE);
        this.buttonOne.addActionListener(this);
        buttons.add(this.buttonOne);
        this.buttonTwo = new Button(CARDTWO);
        this.buttonTwo.addActionListener(this);
        buttons.add(this.buttonTwo);
        this.add((Component)buttons, "West");
        Panel main = new Panel(new GridLayout(3, 2));
        this.layout1 = new CardLayout();
        this.panel1 = new Panel(this.layout1);
        Button a = this.locationButton(CARDONE, Color.red, "Red card <ONE> added first using add()");
        Button b = this.locationButton(CARDONE, Color.green, "Green card <ONE> added second using add()");
        Button c = this.locationButton(CARDTWO, Color.blue, "Blue card <TWO> added third using add()");
        Button d = this.locationButton(CARDTWO, Color.yellow, "Yellow card <TWO> added last using add()");
        Button title = this.locationButton("Reference layout add()", Color.black, "Layout built in sequence <A>,<B>,<C>,<D> using add()");
        main.add(this.buildLayout(title, this.panel1, a, CARDONE, b, CARDONE, c, CARDTWO, d, CARDTWO));
        this.layout2 = new CardLayout();
        this.panel2 = new Panel(this.layout2);
        a = this.locationButton(CARDONE, Color.red, "Red card <ONE> added first to last place in list using add(-1)");
        b = this.locationButton(CARDONE, Color.green, "Green card <ONE> added second to last place in list using add(-1)");
        c = this.locationButton(CARDTWO, Color.blue, "Blue card <TWO> added third to last place in list using add(-1)");
        d = this.locationButton(CARDTWO, Color.yellow, "Yellow card <TWO> added last to last place in list using add()");
        title = this.locationButton("positioned default by add(-1)", Color.black, "Components added in sequence <A>,<B>,<C>,<D> using add(-1)");
        main.add(this.buildLayout(title, this.panel2, a, CARDONE, -1, b, CARDONE, -1, c, CARDTWO, -1, d, CARDTWO, -1));
        this.layout3 = new CardLayout();
        this.panel3 = new Panel(this.layout3);
        a = this.locationButton(CARDONE, Color.red, "Red card <ONE> added last using add()");
        b = this.locationButton(CARDONE, Color.green, "Green card <ONE> added third using add()");
        c = this.locationButton(CARDTWO, Color.blue, "Blue card <ONE> added second using add()");
        d = this.locationButton(CARDTWO, Color.yellow, "Yellow card <TWO> added first using add()");
        title = this.locationButton("Inverse layout", Color.black, "Layout built in sequence <D>,<C>,<B>,<A> using add()");
        main.add(this.buildLayout(title, this.panel3, d, CARDTWO, c, CARDTWO, b, CARDONE, a, CARDONE));
        this.layout4 = new CardLayout();
        this.panel4 = new Panel(this.layout4);
        a = this.locationButton(CARDONE, Color.red, "Red card <ONE> added first using add(0)");
        b = this.locationButton(CARDONE, Color.green, "Green card <ONE> added second to first place in list using add(0)");
        c = this.locationButton(CARDTWO, Color.blue, "Blue card <TWO> added third to first place in list using add(0)");
        d = this.locationButton(CARDTWO, Color.yellow, "Yellow card <TWO> added fourth to first place in list using add(0)");
        title = this.locationButton("Positioned first by add(0)", Color.black, "Components added in sequence <A>,<B>,<C>,<D>/new added first in list using add(0)");
        main.add(this.buildLayout(title, this.panel4, a, CARDONE, 0, b, CARDONE, 0, c, CARDTWO, 0, d, CARDTWO, 0));
        this.layout5 = new CardLayout();
        this.panel5 = new Panel(this.layout5);
        a = this.locationButton(CARDONE, Color.red, "Red card <ONE> added first using add()");
        b = this.locationButton(CARDONE, Color.green, "Green card <ONE> added second using add()");
        c = this.locationButton(CARDTWO, Color.blue, "Blue card <TWO> added fourth using add()");
        d = this.locationButton(CARDTWO, Color.yellow, "Yellow card <TWO> added third by add() sequence");
        title = this.locationButton("<A>,<B>,<D>,<C> by adding order", Color.black, "Layout built in sequence <A>,<B>,<D>,<C> using add()");
        main.add(this.buildLayout(title, this.panel5, a, CARDONE, b, CARDONE, d, CARDTWO, c, CARDTWO));
        this.layout6 = new CardLayout();
        this.panel6 = new Panel(this.layout6);
        a = this.locationButton(CARDONE, Color.red, "Red card <ONE> added first to first place in list using add(0)");
        b = this.locationButton(CARDONE, Color.green, "Green card <ONE> added second to second place in list using add(1)");
        c = this.locationButton(CARDTWO, Color.blue, "Blue card <TWO> added third to third in list using add(2), later moved up by <D>");
        d = this.locationButton(CARDTWO, Color.yellow, "Yellow card <TWO> deliberately added fourth to third place in list using add(2)");
        title = this.locationButton("<D> third by add(2)", Color.black, "Components added in sequence <A>,<B>,<C>,<D> using add(2) to set <D> third in list");
        main.add(this.buildLayout(title, this.panel6, a, CARDONE, 0, b, CARDONE, 1, c, CARDTWO, 2, d, CARDTWO, 2));
        this.add((Component)main, "Center");
        this.display = new List(2, false);
        this.display.setForeground(Color.white);
        this.display.add("Click on an item to get more info");
        this.add((Component)this.display, "South");
        this.layout1.first(this.panel1);
        this.layout2.first(this.panel2);
        this.layout3.first(this.panel3);
        this.layout4.first(this.panel4);
        this.layout5.first(this.panel5);
        this.layout6.first(this.panel6);
        this.current = 1;
        this.showing.setText(" " + this.current + " of " + this.panel1.getComponentCount());
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        String command = evt.getActionCommand();
        int count = this.panel1.getComponentCount();
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        if (src == this.next) {
            if (this.current < count) {
                this.layout1.next(this.panel1);
                this.layout2.next(this.panel2);
                this.layout3.next(this.panel3);
                this.layout4.next(this.panel4);
                this.layout5.next(this.panel5);
                this.layout6.next(this.panel6);
                ++this.current;
                this.showing.setText(" " + this.current + " of " + count);
                this.display.add("CardLayout.next() to next panel no." + this.current, 0);
                if (this.current == count) {
                    this.next.setLabel("First panel");
                }
            } else {
                this.layout1.first(this.panel1);
                this.layout2.first(this.panel2);
                this.layout3.first(this.panel3);
                this.layout4.first(this.panel4);
                this.layout5.first(this.panel5);
                this.layout6.first(this.panel6);
                this.current = 1;
                this.showing.setText(" " + this.current + " of " + count);
                this.display.add("CardLayout.first() to first panel", 0);
                this.next.setLabel("Next panel");
            }
        } else if (command.equals(CARDONE) || command.equals(CARDTWO)) {
            this.layout1.show(this.panel1, command);
            this.layout2.show(this.panel2, command);
            this.layout3.show(this.panel3, command);
            this.layout4.show(this.panel4, command);
            this.layout5.show(this.panel5, command);
            this.layout6.show(this.panel6, command);
            this.showing.setText(command + " of " + count);
            this.display.add("Showing panel " + command, 0);
            this.current = count;
            this.next.setLabel("first panel");
        } else {
            this.display.add(command, 0);
        }
    }

    public String getHelpText() {
        return "A test to verify Rudolph's implementation of the Container.add(Component, name, position) form in a CardLayout :\n\nThis time, the cardlayout will store elements under a different position, but under the same name. This will still allow you to access all elements added by using the CardLayout.first(), -.next(), -.previous() and -.last() functions, but when calling the elements by name the layout will always return the element that was added first.\nAgain, this test shows three rows of two panels. Again to each of them are added our four elements <A>,<B>,<C> and.<D>\n<A> and <B> are added under the name of [card <ONE>] , <C> and <D> under the name of[card <TWO>]\nUsing the [card <ONE>]/[card <TWO>] buttons, you can directly access the (first) element [card <ONE>] or [card <TWO>] by means of CardLayout.show(element name)\n\nUsing the <first/next > button, you can loop through each elements panels in order of appearance\n\nAs in all other position tests, the elements are added in order <A>+<B>+<C>+<D>, order <D>+<C>+<B>+<A> and order <A>+<B>+<D>+<C>respectingly, the left side by changing the order in which the elements are added to the list (using add(element, name)), the right one by specifying the order in the add(element, name, position) form\n\nADDING AN ELEMENT UNDER A NAME, CARDLAYOUT LOOKS AT THE LAST ELEMENT ARRIVING, NOT AT ITS POSITION IN LIST LIKE THIS, [card <ONE>] WILL SHOW THE GREEN PANEL IN ALL SITUATIONS BUT 3 WHICH WILL SHOW THE RED ONE\n[card <TWO>] WILL SHOW THE YELLOW PANEL IN ALL BUT 3 AND 5 WHICH SHOW THE BLUE ONE\nUSING THE NEXT BUTTON, FOR ALL OF THE ROWS, THE LEFT PANELS AND THEIR CORRESPONDING RIGHT PANELS SHOULD LOOK EXACTLY THE SAME";
    }
}

