/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class BorderSizeDefs
extends VisualTestImpl {
    private static final int LAMPWIDTH = 20;
    private static final int LAMPHEIGHT = 20;
    private List display;

    public BorderSizeDefs() {
        int gray = 48;
        this.setLayout(new BorderLayout());
        this.setForeground(Color.white);
        this.setBackground(new Color(gray, gray, gray));
        gray += 32;
        this.display = new List(2, false);
        this.display.add("Observer ImageUpdate() dispayed here");
        this.add((Component)this.display, "South");
        Panel layouts = new Panel(new GridLayout(1, 4));
        Panel none = new Panel(new BorderLayout());
        none.setBackground(Color.white);
        none.add((Component)new FillComponent("No Size definitions, NORTH", 20, 20, new Color(gray, gray, gray)), "North");
        none.add((Component)new FillComponent("No Size definitions, SOUTH", 20, 20, new Color(gray += 16, gray, gray)), "South");
        none.add((Component)new FillComponent("No Size definitions, EAST", 20, 20, new Color(gray += 16, gray, gray)), "East");
        none.add((Component)new FillComponent("No Size definitions, WEST", 20, 20, new Color(gray += 16, gray, gray)), "West");
        none.add((Component)new FillComponent("No Size definitions, CENTER", 20, 20, new Color(gray += 16, gray, gray)), "Center");
        layouts.add(none);
        Panel min = new Panel(new BorderLayout());
        min.setBackground(Color.black);
        min.add((Component)new MinFillComponent("Minimum size defined, NORTH", 20, 20, new Color(gray += 16, gray, gray)), "North");
        min.add((Component)new MinFillComponent("Minimum size defined, SOUTH", 20, 20, new Color(gray += 16, gray, gray)), "South");
        min.add((Component)new MinFillComponent("Minimum size defined, EAST", 20, 20, new Color(gray += 16, gray, gray)), "East");
        min.add((Component)new MinFillComponent("Minimum size defined, WEST", 20, 20, new Color(gray += 16, gray, gray)), "West");
        min.add((Component)new MinFillComponent("Minimum size defined, CENTER", 20, 20, new Color(gray += 16, gray, gray)), "Center");
        layouts.add(min);
        Panel pref = new Panel(new BorderLayout());
        pref.setBackground(Color.black);
        pref.add((Component)new PrefFillComponent("Preferred size defined, NORTH", 20, 20, new Color(gray += 16, gray, gray)), "North");
        pref.add((Component)new PrefFillComponent("Preferred size defined, SOUTH", 20, 20, new Color(gray -= 16, gray, gray)), "South");
        pref.add((Component)new PrefFillComponent("Preferred size defined, EAST", 20, 20, new Color(gray -= 16, gray, gray)), "East");
        pref.add((Component)new PrefFillComponent("Preferred size defined, WEST", 20, 20, new Color(gray -= 16, gray, gray)), "West");
        pref.add((Component)new PrefFillComponent("Preferred size defined, CENTER", 20, 20, new Color(gray -= 16, gray, gray)), "Center");
        layouts.add(pref);
        Panel max = new Panel(new BorderLayout());
        max.setBackground(Color.white);
        max.add((Component)new MaxFillComponent("Maximum size defined, NORTH", 20, 20, new Color(gray -= 16, gray, gray)), "North");
        max.add((Component)new MaxFillComponent("Maximum size defined,SOUTH ", 20, 20, new Color(gray -= 16, gray, gray)), "South");
        max.add((Component)new MaxFillComponent("Maximum size defined, EAST", 20, 20, new Color(gray -= 16, gray, gray)), "East");
        max.add((Component)new MaxFillComponent("Maximum size defined, WEST", 20, 20, new Color(gray -= 16, gray, gray)), "West");
        max.add((Component)new MaxFillComponent("Maximum size defined, CENTER", 20, 20, new Color(gray -= 16, gray, gray)), "Center");
        gray -= 16;
        layouts.add(max);
        this.add((Component)layouts, "Center");
    }

    private void displayMessage(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        System.out.println(text);
        this.display.add(text, 0);
    }

    public String getHelpText() {
        return "WHAT IT DOES: \n The screen is devided into four panels, onto each panel are added five components respectingly on the locations BorderLayout.NORTH, BorderLayout.SOUTH, BorderLayout.EAST, BorderLayout.WEST and BorderLayout.CENTER\nIn the first panel, the components are defines as-is without defiinitions of their minimum, maximum or preferred sizeIn the second panel, each component has a minimum size : Component.getMinimumSize() for that panel returns the size of the inner rectangle drawn in that component.\nIn the third panel, for each of the components, Component.getPreferredSize() returns the size of the inner rectangle for that component\nIn the fourth panel, each component returns the size of the inner rectangle as Component.getMaximumSize()\n\nWHAT YOU SHOULD SEE:\nIn the first , second and fourth panel, as no preferred sizes are defined, the north, south east and west components are considered of having a size zero, and therefore are not drawn. The center component occupies all remaining space: in this case the complete panel\nThe third panel should show a complete BorderLayout figure with the north and south component exactly as high as their inner rectangle and the east and west conponents just as wide as theirs";
    }

    static /* synthetic */ void access$200(BorderSizeDefs x0, String x1) {
        x0.displayMessage(x1);
    }

    class MaxFillComponent
    extends FillComponent {
        public MaxFillComponent(String parent, int width, int height, Color back) {
            super(parent, width, height, back);
        }

        public Dimension getMaximumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }
    }

    class PrefFillComponent
    extends FillComponent {
        public PrefFillComponent(String parent, int width, int height, Color back) {
            super(parent, width, height, back);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }
    }

    class MinFillComponent
    extends FillComponent {
        public MinFillComponent(String parent, int width, int height, Color back) {
            super(parent, width, height, back);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }
    }

    class FillComponent
    extends Component {
        private Dimension bounds;
        protected Rectangle innerRect;
        private int middle;
        private String name;
        private Color background;

        public FillComponent(String parent, int width, int height, Color back) {
            this.background = back;
            this.name = parent;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ FillComponent this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent evt) {
                    BorderSizeDefs.access$200(FillComponent.access$100(this.this$1), FillComponent.access$000(this.this$1));
                }
            });
            this.bounds = new Dimension();
            this.innerRect = new Rectangle(0, 0, width, height);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (!this.bounds.equals(this.getSize())) {
                this.bounds.setSize(this.getSize());
                this.innerRect.setLocation((this.bounds.width - this.innerRect.width) / 2, (this.bounds.height - this.innerRect.height) / 2);
                this.middle = this.getSize().height / 2;
            }
            g.setColor(this.background);
            g.fillRect(1, 1, this.bounds.width - 1, this.bounds.height - 1);
            g.setColor(this.getBackground());
            g.drawRect(this.innerRect.x + 2, this.innerRect.y + 2, this.innerRect.width - 4, this.innerRect.height - 4);
            g.drawLine(this.innerRect.x, this.innerRect.y, this.innerRect.x + this.innerRect.width, this.innerRect.y + this.innerRect.height);
            g.drawLine(this.innerRect.x, this.innerRect.y + this.innerRect.height, this.innerRect.x + this.innerRect.width, this.innerRect.y);
        }

        static /* synthetic */ String access$000(FillComponent x0) {
            return x0.name;
        }

        static /* synthetic */ BorderSizeDefs access$100(FillComponent x0) {
            return x0.BorderSizeDefs.this;
        }
    }
}

