/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.WindowEventDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class WindowEventTest
extends VisualTestImpl
implements ActionListener,
WindowListener {
    private Window leftWindow = null;
    private Window rightWindow;
    private Button buildLeft;
    private Button killLeft;
    private Button showLeft;
    private Button hideLeft;
    private Button frontLeft;
    private Button backLeft;
    private Button focusLeft;
    private Label leftAnchor;
    private Label rightAnchor;
    private Button buildRight;
    private Button killRight;
    private Button showRight;
    private Button hideRight;
    private Button frontRight;
    private Button backRight;
    private Button focusRight;
    private List display;

    public WindowEventTest() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(128, 32, 128));
        this.setForeground(Color.white);
        this.display = new List(3, false);
        this.display.add("Dialog outcome dispayed here");
        this.add((Component)this.display, "South");
        Panel anchors = new Panel(new GridLayout(1, 4));
        Panel leftbuttons = new Panel(new GridLayout(8, 1));
        leftbuttons.setBackground(new Color(80, 32, 32));
        leftbuttons.add(new Label("Left Window:"));
        this.buildLeft = new Button("[ ] build window");
        this.buildLeft.setBackground(new Color(96, 32, 48));
        this.buildLeft.addActionListener(this);
        leftbuttons.add(this.buildLeft);
        this.killLeft = new Button("[x] dispose window");
        this.killLeft.setBackground(new Color(112, 32, 64));
        this.killLeft.addActionListener(this);
        leftbuttons.add(this.killLeft);
        this.showLeft = new Button("<= show window =>");
        this.showLeft.setBackground(new Color(128, 32, 80));
        this.showLeft.addActionListener(this);
        leftbuttons.add(this.showLeft);
        this.hideLeft = new Button("=> hide window <=");
        this.hideLeft.setBackground(new Color(144, 32, 96));
        this.hideLeft.addActionListener(this);
        leftbuttons.add(this.hideLeft);
        this.frontLeft = new Button("=> to front =>");
        this.frontLeft.setBackground(new Color(160, 32, 112));
        this.frontLeft.addActionListener(this);
        leftbuttons.add(this.frontLeft);
        this.backLeft = new Button("<= to back <=");
        this.backLeft.setBackground(new Color(176, 32, 128));
        this.backLeft.addActionListener(this);
        leftbuttons.add(this.backLeft);
        this.focusLeft = new Button("request focus");
        this.focusLeft.setBackground(new Color(192, 32, 144));
        this.focusLeft.addActionListener(this);
        leftbuttons.add(this.focusLeft);
        anchors.add(leftbuttons);
        this.leftAnchor = new Label("Left window area");
        this.leftAnchor.setBackground(new Color(224, 0, 144));
        anchors.add(this.leftAnchor);
        this.rightAnchor = new Label("Right window area");
        this.rightAnchor.setBackground(new Color(144, 0, 224));
        anchors.add(this.rightAnchor);
        Panel rightbuttons = new Panel(new GridLayout(8, 1));
        rightbuttons.setBackground(new Color(32, 32, 80));
        rightbuttons.add(new Label("Right Window:"));
        this.buildRight = new Button("[ ] build window");
        this.buildRight.setBackground(new Color(48, 32, 96));
        this.buildRight.addActionListener(this);
        rightbuttons.add(this.buildRight);
        this.killRight = new Button("[X] dispose window");
        this.killRight.setBackground(new Color(64, 32, 112));
        this.killRight.addActionListener(this);
        rightbuttons.add(this.killRight);
        this.showRight = new Button("<= show window =>");
        this.showRight.setBackground(new Color(80, 32, 128));
        this.showRight.addActionListener(this);
        rightbuttons.add(this.showRight);
        this.hideRight = new Button("=> hide window <=");
        this.hideRight.setBackground(new Color(96, 32, 144));
        this.hideRight.addActionListener(this);
        rightbuttons.add(this.hideRight);
        this.frontRight = new Button("=> to front =>");
        this.frontRight.setBackground(new Color(112, 32, 160));
        this.frontRight.addActionListener(this);
        rightbuttons.add(this.frontRight);
        this.backRight = new Button("<= to back <=");
        this.backRight.setBackground(new Color(128, 32, 176));
        this.backRight.addActionListener(this);
        rightbuttons.add(this.backRight);
        this.focusRight = new Button("request focus");
        this.focusRight.setBackground(new Color(144, 32, 192));
        this.focusRight.addActionListener(this);
        rightbuttons.add(this.focusRight);
        anchors.add(rightbuttons);
        this.add((Component)anchors, "Center");
    }

    public void stop(Panel p) {
        if (this.leftWindow != null) {
            this.leftWindow.dispose();
            this.leftWindow = null;
        }
        if (this.rightWindow != null) {
            this.rightWindow.dispose();
            this.rightWindow = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        if (source == this.buildLeft && this.leftWindow == null) {
            this.displayText("... building new Left window");
            this.leftWindow = this.buildWindow("the <RED> window", Color.red, this.leftAnchor.getLocationOnScreen());
        } else if (source == this.buildLeft) {
            this.displayText("!! skipped build of left window !!", "!! Left window was already constructed !!");
        } else if (source == this.killLeft && this.leftWindow != null) {
            this.displayText("... initiating Left-window.dispose()");
            this.leftWindow.dispose();
            this.leftWindow = null;
        } else if (source == this.killLeft) {
            this.displayText("!! skipped Left-window.dispose() !!", "!! Left window is not built yet !!");
        } else if (source == this.showLeft && this.leftWindow != null) {
            this.displayText("... initiating Left-window.setVisible(true)");
            this.leftWindow.setVisible(true);
        } else if (source == this.showLeft) {
            this.displayText("!! skipped Left-window.setVisible() !!", "!! Left window is not built yet !!");
        } else if (source == this.hideLeft && this.leftWindow != null) {
            this.displayText("... initiating Left-window.setVisible(false)");
            this.leftWindow.setVisible(false);
        } else if (source == this.hideLeft) {
            this.displayText("!! skipped Left-window.setVisible() !!", "!! Left window is not built yet !!");
        } else if (source == this.frontLeft && this.leftWindow != null) {
            this.displayText("... initiating Left-window.toFront()");
            this.leftWindow.toFront();
        } else if (source == this.frontLeft) {
            this.displayText("!! skipped Left-window.toFront() !!", "!! Left window is not built yet !!");
        } else if (source == this.backLeft && this.leftWindow != null) {
            this.displayText("... initiating Left-window.toBack()");
            this.leftWindow.toBack();
        } else if (source == this.backLeft) {
            this.displayText("!! skipped Left-window.toBack() !!", "!! Left window is not built yet !!");
        } else if (source == this.focusLeft && this.leftWindow != null) {
            this.displayText("... initiating Left-window.requestFocus()");
            this.leftWindow.requestFocus();
        } else if (source == this.focusLeft) {
            this.displayText("!! skipped Left-window.requestFocus() !!", "!! Left window is not built yet !!");
        } else if (source == this.buildRight && this.rightWindow == null) {
            this.displayText("... building new right window");
            this.rightWindow = this.buildWindow("the <BLUE> window", Color.blue, this.rightAnchor.getLocationOnScreen());
        } else if (source == this.buildRight) {
            this.displayText("!! skipped build of right window !!", "!! Right window was already constructed !!");
        } else if (source == this.killRight && this.rightWindow != null) {
            this.displayText("... initiating Right-window.dispose()");
            this.rightWindow.dispose();
            this.rightWindow = null;
        } else if (source == this.killRight) {
            this.displayText("!! skipped Right-window.dispose() !!", "!! Right window is not built yet !!");
        } else if (source == this.showRight && this.rightWindow != null) {
            this.displayText("... initiating Right-window.setVisible(true)");
            this.rightWindow.setVisible(true);
        } else if (source == this.showRight) {
            this.displayText("!! skipped Right-window.show() !!", "!! Right window is not built yet !!");
        } else if (source == this.hideRight && this.rightWindow != null) {
            this.displayText("... initiating Right-window.setVisible(false)");
            this.rightWindow.setVisible(false);
        } else if (source == this.hideRight) {
            this.displayText("!! skipped Right-window.setVisible(false) !!", "!! Right window is not built yet !!");
        } else if (source == this.frontRight && this.rightWindow != null) {
            this.displayText("... initiating Right-window.toFront()");
            this.rightWindow.toFront();
        } else if (source == this.frontRight) {
            this.displayText("!! skipped Right-window.toFront() !!", "!! Right window is not built yet !!");
        } else if (source == this.backRight && this.rightWindow != null) {
            this.displayText("... initiating Right-window.toBack()");
            this.rightWindow.toBack();
        } else if (source == this.backRight) {
            this.displayText("!! skipped Right-window.toBack() !!", "!! Right window is not built yet !!");
        } else if (source == this.focusRight && this.rightWindow != null) {
            this.displayText("... initiating Right-window.requestFocus()");
            this.rightWindow.requestFocus();
        } else if (source == this.focusRight) {
            this.displayText("!! skipped Right-window.requestFocus() !!", "!! Right window is not built yet !!");
        }
    }

    public void windowActivated(WindowEvent evt) {
        this.displayText("Window activated: " + WindowEventDisplay.displayWindowShortcut(evt));
    }

    public void windowDeactivated(WindowEvent evt) {
        this.displayText("Window deactivated: " + WindowEventDisplay.displayWindowShortcut(evt));
    }

    public void windowIconified(WindowEvent evt) {
        this.displayText("Window iconified: " + WindowEventDisplay.displayWindowShortcut(evt));
    }

    public void windowDeiconified(WindowEvent evt) {
        this.displayText("Window de-iconified: " + WindowEventDisplay.displayWindowShortcut(evt));
    }

    public void windowOpened(WindowEvent evt) {
        this.displayText("Window opened: " + WindowEventDisplay.displayWindowShortcut(evt));
    }

    public void windowClosing(WindowEvent evt) {
        this.displayText("Window closing: " + WindowEventDisplay.displayWindowShortcut(evt));
    }

    public void windowClosed(WindowEvent evt) {
        this.displayText("Window closed: " + WindowEventDisplay.displayWindowShortcut(evt));
    }

    private void displayText(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(text, 0);
        System.out.println(text);
    }

    private void displayText(String line1, String line2) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(line2, 0);
        this.display.add(line1, 0);
        System.out.println(line1);
        System.out.println(line2);
    }

    private Window buildWindow(String text, Color textcolor, Point anchor) {
        Window target = null;
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
        } else {
            WindowEventDisplay contents = new WindowEventDisplay(text, new Color(198, 198, 128), textcolor, 150, 75);
            target = new Window(vtframe);
            target.setName(text);
            target.addWindowListener(this);
            target.setLayout(new FlowLayout());
            target.add(contents);
            target.pack();
            target.setLocation(anchor.x, anchor.y);
            this.displayText("Build new window " + target);
        }
        return target;
    }

    public String getHelpText() {
        return "The aim: test the throwing and the correct layout of WwindowEvents to a WindowListener:\n\nUsing the buttons on the screen, this tests builds, shows and hides one of two possible Windows, brings it to back and to frontAll events done will be logged in the event list on the bottom of the screen. All WindowEvents sent by one of the two test windows will be displayed there just as well \n\n There are two rows of buttons, one for each of the two windows. The left buttons relate to the left, red window, the right buttons to the right, blue one.\nThe left, red window is shown with its upper left corner aligned to the upper left corner of the left inner anchor panel, the right, blue window is shown with its upper left corner aligned to that of the inner right anchor panel\nthe  buttons:\n-> <build> constructs a new window. the window isn't shown yet. (Use <show> to do so )\n-> <dispose> disposes and deletes the window\n-> <show> shows the window  calling setVisible(true)\n-> <hide> calls setVisible(false) to hide the window again\n-> <to front> calls Window.toFront() to bring this window on top of all others\n   (in this case, over the other window, if present)\n-> <to back> calls Window.toBack(), to place this window below all others\n   (in this case, below the other window, if present)\n-> <request focus> to request focus for the window\n";
    }

    public static void main(String[] args) {
        new WindowEventTest();
    }
}

