/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TextEventKeyboard
extends VisualTestImpl
implements TextListener {
    private NamedTextField visibleField;
    private NamedTextField maskedField;
    private NamedTextField crossedField;
    private NamedTextArea area;
    private List display;

    public TextEventKeyboard() {
        this.setForeground(Color.white);
        this.setFont(new Font("courR14", 0, 14));
        int step = 25;
        int green = 100;
        int shade = 80;
        this.setLayout(new BorderLayout());
        Panel fields = new Panel(new GridLayout(4, 2));
        Label l1 = new Label("Normal text field");
        l1.setBackground(new Color(shade, green, shade));
        fields.add(l1);
        this.visibleField = new NamedTextField("<VISIBLE FIELD>");
        this.visibleField.addTextListener(this);
        this.visibleField.setBackground(new Color(shade, green, shade));
        fields.add(this.visibleField);
        Label l2 = new Label("masked (stars)");
        l2.setBackground(new Color(shade, green += step, shade));
        fields.add(l2);
        this.maskedField = new NamedTextField("<MASKED BY [*]>");
        this.maskedField.setEchoChar('*');
        this.maskedField.addTextListener(this);
        this.maskedField.setBackground(new Color(shade, green, shade));
        fields.add(this.maskedField);
        Label l3 = new Label("masked (points)");
        l3.setBackground(new Color(shade, green += step, shade));
        fields.add(l3);
        this.crossedField = new NamedTextField("<MASKED BY [.]>");
        this.crossedField.addTextListener(this);
        this.crossedField.setEchoChar('.');
        this.crossedField.setBackground(new Color(shade, green, shade));
        fields.add(this.crossedField);
        Label l4 = new Label("Text Area:");
        l4.setBackground(new Color(shade, green += step, shade));
        fields.add(l4);
        Label l5 = new Label();
        l5.setBackground(new Color(shade, green, shade));
        fields.add(l5);
        this.add((Component)fields, "North");
        this.area = new NamedTextArea("<TextArea>");
        this.area.addTextListener(this);
        this.area.setFont(new Font("courR14", 0, 14));
        this.area.setBackground(new Color(shade, green += step, shade));
        this.add((Component)this.area, "Center");
        this.display = new List(2, false);
        this.display.setBackground(new Color(shade, green, shade));
        this.display.setFont(new Font("courR14", 0, 14));
        this.display.add("Your ActionEvents displayed HERE");
        this.add((Component)this.display, "South");
    }

    public void textValueChanged(TextEvent evt) {
        if (this.display.getItemCount() > 20) {
            this.display.removeAll();
        }
        TextComponent source = (TextComponent)evt.getSource();
        String contents = source.getText();
        this.display.add(source + " : [" + contents + "] len=" + contents.length(), 0);
    }

    public String getHelpText() {
        return "The aim: test the throwing of TextEvents in TextAreas and TextFields by keyboard input:\n\nThe test: \nChange the text in the three TextFields and the TextArea and see the TextEvent thrown that gives this field or area's new length \n\nSee that the second TextField masks all new characters into stars and the third TextField masks all new characters into plusses";
    }

    class NamedTextField
    extends TextField {
        private String name;

        public NamedTextField(String name) {
            super("???");
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    class NamedTextArea
    extends TextArea {
        private String name;

        public NamedTextArea(String name) {
            super("???", 5, 30, 1);
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

