/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import com.acunia.wonka.test.awt.event.MouseGeneratorComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.List;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MouseListenerOverride
extends VisualTestImpl
implements MouseListener,
CollectsEvents {
    private List display;
    private GridMouseGenerator trigger;

    public MouseListenerOverride() {
        this.setLayout(new BorderLayout());
        this.trigger = new GridMouseGenerator("<MouseGenerator>", MouseGeneratorComponent.DARKGREEN, MouseGeneratorComponent.DUSTGREEN, this);
        this.trigger.addMouseListener(this);
        this.add((Component)this.trigger, "Center");
        this.display = new List(6, false);
        this.display.add("See your mouse events here");
        this.add((Component)this.display, "South");
    }

    public void mouseClicked(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "<MouseListenerOverride>"));
    }

    public void mouseEntered(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "<MouseListenerOverride>"));
    }

    public void mouseExited(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "<MouseListenerOverride>"));
    }

    public void mousePressed(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "<MouseListenerOverride>"));
    }

    public void mouseReleased(MouseEvent event) {
        this.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, "<MouseListenerOverride>"));
    }

    public void displayMessage(String[] message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        if (message.length > 2) {
            this.display.add("..... " + message[2], 0);
        }
        if (message.length > 1) {
            this.display.add("..... " + message[1], 0);
        }
        if (message.length > 0) {
            this.display.add(message[0], 0);
        }
    }

    public String getHelpText() {
        return " A test on overriding the mouse listener interface: \n The panel shows a mouse event fields and a list. Just as in the previous tests, the list wil display the mouse events thrown. However, this time the event field's mouse listener is overridden such that it shows the mouse movements on the screen, but rather then disposing them there, calculates the mouse position into grid coordinates and then forwards the event to the assigned listener. (in this case the main test class). \n CONSEQUENTLY ANY MOUSE ACTION IN THE LEFT PANEL WILL RESULT IN THE RIGHT PANEL DISPLAYING THE RESULT OF THIS ACTION\n Items to test:\n --------------\n=> reaction to mouse events, display of the right event ID, multiple displays of events as in the MouseEvent class\n=> Source and catcher object: the event must be originated by the mouse event field and catched by the test application\n=> Mouse coordinates: the mouse coordinates must be displained in grid coordinates ranging from -12 to +12 horizontally and -3 to +3 vertically .\n\n The mouse reacts to mouse events (no mouse-motion events) in the following way:\n=> Mouse released: the point is set to the nearest grid intersection, no lines are drawn\n=> Mouse clicked: the drawing color shifts to the next color of the rainbow\n=> mouse entered: the point is moved to the nearest intersection\n=> mouse exited: the point is moved to the nearest intersection, grid lines are shown and a line is drawn from the point to the actual mouse position";
    }

    public String toString() {
        return "MouseEventTest";
    }

    class GridMouseGenerator
    extends MouseGeneratorComponent {
        MouseListener ml = null;

        public GridMouseGenerator(String componentname, Color back, Color front, CollectsEvents parentinstance) {
            super(componentname, back, front, parentinstance);
        }

        public void addMouseListener(MouseListener newlistener) {
            this.ml = newlistener;
            super.addMouseListener(this);
        }

        protected MouseEvent eventToGrid(MouseEvent event) {
            return new MouseEvent(this, event.getID(), System.currentTimeMillis(), 16, this.gridPoint.x, -this.gridPoint.y, 1, false);
        }

        public void mouseClicked(MouseEvent event) {
            if (this.ml == this) {
                this.parent.displayMessage(GridMouseGenerator.displayMouseEvent(this.eventToGrid(event), this.name));
            } else {
                this.ml.mouseClicked(this.eventToGrid(event));
            }
            this.currentColor = this.currentColor > 0 ? --this.currentColor : colors.length - 1;
            this.repaint();
        }

        public void mouseEntered(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            if (this.ml == this) {
                this.parent.displayMessage(GridMouseGenerator.displayMouseEvent(this.eventToGrid(event), this.name));
            } else {
                this.ml.mouseEntered(this.eventToGrid(event));
            }
            this.connected = false;
            this.repaint();
        }

        public void mouseExited(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            if (this.ml == this) {
                this.parent.displayMessage(GridMouseGenerator.displayMouseEvent(this.eventToGrid(event), this.name));
            } else {
                this.ml.mouseExited(this.eventToGrid(event));
            }
            this.connected = true;
            this.repaint();
        }

        public void mousePressed(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            if (this.ml == this) {
                this.parent.displayMessage(GridMouseGenerator.displayMouseEvent(this.eventToGrid(event), this.name));
            } else {
                this.ml.mousePressed(this.eventToGrid(event));
            }
            this.connected = true;
            this.repaint();
        }

        public void mouseReleased(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            if (this.ml == this) {
                this.parent.displayMessage(GridMouseGenerator.displayMouseEvent(this.eventToGrid(event), this.name));
            } else {
                this.ml.mouseReleased(this.eventToGrid(event));
            }
            this.connected = false;
            this.repaint();
        }
    }
}

