/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import com.acunia.wonka.test.awt.event.MouseGeneratorComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.MouseEvent;

public class MouseListenerCrossed
extends VisualTestImpl
implements CollectsEvents {
    private List display;
    private MouseGeneratorNoExit trigger1 = new MouseGeneratorNoExit("<COPPER>", MouseGeneratorComponent.COPPER, MouseGeneratorComponent.DARKSAND, this);
    private MouseGeneratorNoExit trigger2 = new MouseGeneratorNoExit("<DARK>", MouseGeneratorComponent.DARKSAND, MouseGeneratorComponent.COPPER, this);

    public MouseListenerCrossed() {
        this.trigger1.addMouseListener(this.trigger2);
        this.trigger2.addMouseListener(this.trigger1);
        this.trigger1.addMouseMotionListener(this.trigger2);
        this.trigger2.addMouseMotionListener(this.trigger1);
        this.setLayout(new BorderLayout());
        Panel p = new Panel(new GridLayout(1, 2));
        p.add(this.trigger1);
        p.add(this.trigger2);
        this.add((Component)p, "Center");
        this.display = new List(6, false);
        this.display.add("See your mouse events here");
        this.add((Component)this.display, "South");
    }

    public void displayMessage(String[] message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        if (message.length > 2) {
            this.display.add("..... " + message[2], 0);
        }
        if (message.length > 1) {
            this.display.add("..... " + message[1], 0);
        }
        if (message.length > 0) {
            this.display.add(message[0], 0);
        }
    }

    public String getHelpText() {
        return " A test on remote controll: \n The panel consists out of two mouse event fields and a list. Just as in the previous tests, the list will display the mouse events thrown. However, this time the mouse listeners of the two panels are linked <crossed> (The events of the left panel are sent to the right and vice versa). \n CONSEQUENTLY ANY MOUSE ACTION IN THE LEFT PANEL WILL RESULT IN THE RIGHT PANEL DISPLAYING THE RESULT OF THIS ACTION AND ANY MOUSE ACTION IN THE RIGHT PANEL WILL BE DISPLAYED IN THE LEFT All mouse event fields have a MouseListener and therefor react to the mouse-pressed, mouse-released, mouse-clicked\n Items to test:\n --------------\n=> Clicking and dragging the mouse in the left field should make the point in the right field move just as if the mouse would be positioned on this exact location in the right field and vice versa\n=> In the list you should see that a mouse event thrown by the right field is catched by the left one and vice versa\n=> Check the coordinates to see if the mouse listener really displays the coordinated according to the field the mouse is in \n\nPs: the behavior of the event fields to the panels is:\n=> Mouse pressed: the point is set to the nearest grid intersection. the point is drawn in the current drawing color. Also drawn are grid lines from the point to the horizontal and vertical axis.\n    Furthermore, a line is drawn between the 'grid' position of the point and the actual mouse position\n=> Mouse released: the point is set to the nearest grid intersection, no lines are drawn\n=> Mouse clicked: the drawing color shifts to the next color of the rainbow\n=> Mouse moved: the point should swap to the next grid intersection as soon as the mouse position is nearer to that position as to the current\n=> Mouse dragged: a line is drawn to the mouse position, as soon as the position is nearer to the next grid, the point is moved to that grid=> mouse entered / mouse exited: A mouse-entered/mouse-exited event is thrown, but no painting is done (this is different from the standard field behavior of the other tests)";
    }

    public String toString() {
        return "MouseEventTest";
    }

    class MouseGeneratorNoExit
    extends MouseGeneratorComponent {
        public MouseGeneratorNoExit(String componentname, Color back, Color front, CollectsEvents parentinstance) {
            super(componentname, back, front, parentinstance);
        }

        public void mouseEntered(MouseEvent event) {
            this.parent.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, this.name));
        }

        public void mouseExited(MouseEvent event) {
            this.parent.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, this.name));
        }
    }
}

