/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.event.CollectsEvents;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseGeneratorComponent
extends Component
implements MouseListener,
MouseMotionListener,
CollectsEvents {
    static final String[] colornames = new String[]{"Purple", "Indigo", "Lightblue", "Green", "Yellow", "Orange", "Red"};
    static final Color[] colors = new Color[]{new Color(128, 0, 128), new Color(0, 0, 128), new Color(96, 96, 255), Color.green, Color.yellow, Color.orange, Color.red};
    static final int GRIDWIDTH = 15;
    static final int GRIDHEIGHT = 15;
    static final Color COPPER = new Color(200, 200, 120);
    static final Color DARKSAND = new Color(96, 96, 48);
    static final Color DUSTGREEN = new Color(128, 192, 128);
    static final Color DARKGREEN = new Color(64, 96, 64);
    protected int currentColor;
    protected Color background;
    protected Color foreground;
    protected String name;
    protected Point screenPoint;
    protected Point mousePoint;
    protected Point gridPoint;
    protected Dimension frame;
    protected Point offset;
    protected Point bounds;
    protected Rectangle inside;
    protected boolean connected;
    protected CollectsEvents parent;

    public Dimension getMinimumSize() {
        return new Dimension(70, 50);
    }

    public Dimension getPreferredSize() {
        return new Dimension(70, 50);
    }

    private final void calculateGrid() {
        this.offset.setLocation(this.frame.width / 2, this.frame.height / 2);
        this.frame.width -= 2;
        this.frame.height -= 2;
        this.bounds.setLocation((this.offset.x - 5) / 15, (this.offset.y - 5) / 15);
        this.inside.setBounds(this.offset.x - this.bounds.x * 15, this.offset.y - this.bounds.y * 15, this.bounds.x * 15 * 2, this.bounds.y * 15 * 2);
        this.screenPoint.setLocation(this.offset);
        this.gridPoint.setLocation(0, 0);
    }

    protected Point screenToGrid(Point screen) {
        Point grid = new Point();
        grid.x = screen.x < this.inside.x ? -this.bounds.x : (screen.x < this.offset.x ? (screen.x - this.offset.x - 7) / 15 : (screen.x < this.inside.x + this.inside.width ? (screen.x - this.offset.x + 7) / 15 : this.bounds.x));
        grid.y = screen.y < this.inside.y ? -this.bounds.y : (screen.y < this.offset.y ? (screen.y - this.offset.y - 7) / 15 : (screen.y < this.inside.y + this.inside.height ? (screen.y - this.offset.y + 7) / 15 : this.bounds.y));
        return grid;
    }

    protected Point gridToScreen(Point grid) {
        return new Point(this.offset.x + grid.x * 15, this.offset.y + grid.y * 15);
    }

    protected void mouseAction(MouseEvent event) {
        this.parent.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, this.name));
        this.gridPoint = this.screenToGrid(event.getPoint());
        this.screenPoint = this.gridToScreen(this.gridPoint);
        this.mousePoint = event.getPoint();
    }

    public void mouseClicked(MouseEvent event) {
        this.parent.displayMessage(MouseGeneratorComponent.displayMouseEvent(event, this.name));
        this.currentColor = this.currentColor > 0 ? --this.currentColor : colors.length - 1;
        this.repaint();
    }

    public void mouseEntered(MouseEvent event) {
        this.mouseAction(event);
        this.connected = false;
        this.repaint();
    }

    public void mouseExited(MouseEvent event) {
        this.mouseAction(event);
        this.connected = true;
        this.repaint();
    }

    public void mousePressed(MouseEvent event) {
        this.mouseAction(event);
        this.connected = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent event) {
        this.mouseAction(event);
        this.connected = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent event) {
        this.mouseAction(event);
        this.connected = true;
        this.repaint();
    }

    public void mouseMoved(MouseEvent event) {
        this.mouseAction(event);
        this.connected = false;
        this.repaint();
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        if (this.frame.width == 0 && this.frame.height == 0) {
            this.frame.setSize(this.getSize());
            this.calculateGrid();
        }
        g.setColor(this.background);
        g.fillRect(1, 1, this.frame.width, this.frame.height);
        g.setColor(this.foreground);
        g.drawRect(this.inside.x, this.inside.y, this.inside.width, this.inside.height);
        g.drawString(this.name, 5, 20);
        g.drawLine(this.inside.x, this.offset.y, this.inside.x + this.inside.width, this.offset.y);
        g.drawLine(this.offset.x, this.inside.y, this.offset.x, this.inside.y + this.inside.height);
        if (this.connected) {
            g.drawLine(this.screenPoint.x, this.screenPoint.y, this.mousePoint.x, this.mousePoint.y);
        }
        g.setColor(colors[this.currentColor]);
        int x0 = this.offset.x;
        int x1 = this.offset.x;
        int y0 = this.offset.y - 5;
        int y1 = this.offset.y + 5;
        int i = 1;
        while (i < this.bounds.x) {
            g.drawLine(x0 += 15, y0, x0, y1);
            g.drawLine(x1 -= 15, y0, x1, y1);
            ++i;
        }
        x0 = this.offset.x - 5;
        x1 = this.offset.x + 5;
        y0 = this.offset.y;
        y1 = this.offset.y;
        i = 1;
        while (i < this.bounds.y) {
            g.drawLine(x0, y0 += 15, x1, y0);
            g.drawLine(x0, y1 -= 15, x1, y1);
            ++i;
        }
        g.drawLine(this.screenPoint.x + 3, this.screenPoint.y, this.screenPoint.x, this.screenPoint.y - 3);
        g.drawLine(this.screenPoint.x + 3, this.screenPoint.y, this.screenPoint.x, this.screenPoint.y + 3);
        g.drawLine(this.screenPoint.x - 3, this.screenPoint.y, this.screenPoint.x, this.screenPoint.y - 3);
        g.drawLine(this.screenPoint.x - 3, this.screenPoint.y, this.screenPoint.x, this.screenPoint.y + 3);
        if (this.connected) {
            g.drawLine(this.screenPoint.x, this.offset.y, this.screenPoint.x, this.screenPoint.y);
            g.drawLine(this.offset.x, this.screenPoint.y, this.screenPoint.x, this.screenPoint.y);
        }
    }

    public void displayMessage(String[] messagestrings) {
    }

    public String getHelpText() {
        return this.getHelpText(true, true);
    }

    public String getHelpText(boolean tracksmouse, boolean tracksmotions) {
        String display = "=> the test shows an x/y grid with ruler marks on it. Next to this it shows a 'point', currently at the center of the axis  \n";
        if (tracksmouse) {
            display = display + "\nReaction to the mouse events:\n=> Mouse pressed: the point is set to the nearest grid intersection. the point is drawn in the current drawing color. Also drawn are grid lines from the point to the horizontal and vertical axis.\n    Furthermore, a line is drawn between the 'grid' position of the point and the actual mouse position\n=> Mouse released: the point is set to the nearest grid intersection, no lines are drawn\n=> Mouse clicked: the drawing color shifts to the next color of the rainbow\n=> mouse entered: the point is moved to the nearest intersection\n=> mouse exited: the point is moved to the nearest intersection, grid lines are shown and a line is drawn from the point to the actual mouse position";
        }
        if (tracksmotions) {
            display = display + "\nReaction to the mouse motion events:\n=> Mouse moved: the point should swap to the next grid intersection as soon as the mouse position is nearer to that position as to the current\n=> Mouse dragged: a line is drawn to the mouse position, as soon as the position is nearer to the next grid, the point is moved to that grid furthermore, grid lines are drawn to the axes ";
        }
        return display;
    }

    public String toString() {
        return this.name;
    }

    static String[] displayMouseEvent(MouseEvent evt) {
        String[] data = new String[4];
        data[0] = "Generated by " + evt.getSource();
        int id = evt.getID();
        data[1] = "at " + evt.getWhen() + " action " + id;
        data[1] = id == 504 ? data[1] + " : <Mouse entered>" : (id == 505 ? data[1] + " : <Mouse exited>" : (id == 501 ? data[1] + " : <Mouse pressed>" : (id == 502 ? data[1] + " : <Mouse released>" : (id == 500 ? data[1] + " : <Mouse clicked>" : (id == 503 ? data[1] + " : <Mouse moved>" : (id == 506 ? data[1] + " : <Mouse dragged>" : data[1] + " : UNKNOWN ID"))))));
        data[2] = "At position (" + evt.getX() + ',' + evt.getY() + ") clicked " + evt.getClickCount() + " times";
        id = evt.getModifiers();
        data[3] = "Mouse modifiers = (" + id + ") :";
        if ((id & 0x1C) == 0) {
            data[3] = data[3] + " No Button detected";
        }
        if ((id & 0x10) != 0) {
            data[3] = data[3] + " Button1(left)";
        }
        if ((id & 8) != 0) {
            data[3] = data[3] + " Button2(right)";
        }
        if ((id & 4) != 0) {
            data[3] = data[3] + " Button3(middle)";
        }
        data[3] = evt.isPopupTrigger() ? data[3] + " ,Event is popup trigger" : data[3] + " ,Event is no popup trigger";
        return data;
    }

    static String[] displayMouseEvent(MouseEvent evt, String catcher) {
        String[] data = MouseGeneratorComponent.displayMouseEvent(evt);
        data[0] = data[0] + " catched by " + catcher;
        return data;
    }

    public MouseGeneratorComponent(String componentname, Color back, Color front, CollectsEvents parentinstance) {
        this.name = componentname;
        this.background = back;
        this.foreground = front;
        this.screenPoint = new Point();
        this.mousePoint = new Point();
        this.gridPoint = new Point();
        this.offset = new Point();
        this.bounds = new Point();
        this.frame = new Dimension();
        this.inside = new Rectangle();
        this.connected = false;
        this.currentColor = colors.length - 1;
        this.parent = parentinstance;
    }

    public MouseGeneratorComponent(String componentname, CollectsEvents parentinstance) {
        this(componentname, Color.white, Color.black, parentinstance);
    }
}

