/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.AWTEventDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class FocusEventTest
extends VisualTestImpl
implements ActionListener,
FocusListener {
    private Button[] request;
    private Checkbox[] transversable;
    private FocusDisplay[] display;
    private List eventList;
    static final int ELEMENTS = 4;

    public FocusEventTest() {
        this.setForeground(new Color(32, 80, 32));
        this.setBackground(new Color(64, 128, 64));
        int step = 25;
        this.request = new Button[4];
        this.transversable = new Checkbox[4];
        this.display = new FocusDisplay[4];
        this.setLayout(new BorderLayout());
        Panel buttons = new Panel(new GridLayout(5, 1));
        buttons.add(new Label("Display Focus", 1));
        int green = 155;
        int rcomp = 100;
        int bcomp = 100;
        for (int i = 0; i < 4; ++i) {
            this.request[i] = new NoTransferButton("request", "request_" + i);
            this.request[i].setBackground(new Color(rcomp, green, bcomp));
            this.request[i].addActionListener(this);
            buttons.add(this.request[i]);
            green += step;
            bcomp += step;
            rcomp += step;
        }
        this.add((Component)buttons, "West");
        Panel boxes = new Panel(new GridLayout(5, 1));
        boxes.add(new Label("is Traversable?", 1));
        rcomp = 100;
        green = 155 + step;
        bcomp = 100 + step;
        for (int i = 0; i < 4; ++i) {
            this.transversable[i] = new NoTransferCheckbox("traversable", "checkbox_" + i);
            this.transversable[i].setBackground(new Color(rcomp, green, bcomp));
            boxes.add(this.transversable[i]);
            rcomp += step;
            green += step;
            bcomp += step;
        }
        this.add((Component)boxes, "East");
        Panel displays = new Panel(new GridLayout(5, 1));
        displays.add(new Label("Focus displays", 1));
        rcomp = 100 + step;
        green = 155;
        bcomp = 100;
        for (int i = 0; i < 4; ++i) {
            this.display[i] = new FocusDisplay("Display_" + i, this.transversable[i], new Color(rcomp, green, bcomp), this.getForeground());
            this.display[i].addFocusListener(this);
            displays.add(this.display[i]);
            rcomp += step;
            green += step;
            bcomp += step;
        }
        this.add((Component)displays, "Center");
        this.eventList = new NoTransferList(5);
        this.eventList.setForeground(Color.white);
        this.eventList.add("Your ActionEvents displayed HERE");
        this.eventList.add(".");
        this.eventList.add(".");
        this.eventList.add(".");
        this.eventList.add(".");
        this.eventList.add(".");
        this.add((Component)this.eventList, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        boolean found = false;
        for (int i = 0; i < 4 && !found; ++i) {
            if (source != this.request[i]) continue;
            this.display[i].requestFocus();
            this.displayEventMessage("requested focus for " + this.display[i]);
            found = true;
        }
    }

    public void focusGained(FocusEvent evt) {
        if (evt.getSource() instanceof FocusDisplay) {
            ((FocusDisplay)evt.getSource()).setFocus(true);
        }
        this.displayEventMessage(this.displayEventShortcut(evt));
    }

    public void focusLost(FocusEvent evt) {
        if (evt.getSource() instanceof FocusDisplay) {
            ((FocusDisplay)evt.getSource()).setFocus(false);
        }
        this.displayEventMessage(this.displayEventShortcut(evt));
    }

    private void displayEventMessage(String message) {
        if (this.eventList.getItemCount() > 60) {
            this.eventList.removeAll();
            this.eventList.add(".");
            this.eventList.add(".");
            this.eventList.add(".");
            this.eventList.add(".");
            this.eventList.add(".");
        }
        this.eventList.add(message, 0);
    }

    private String displayEventShortcut(FocusEvent evt) {
        Object source = evt.getSource();
        String line = source == null ? " From source() == NULL " : "From " + source;
        int id = evt.getID();
        line = id == 1004 ? line + " <FOCUS GAINED>, temporary: " : (id == 1005 ? line + " <FOCUS lost>, temporary: " : line + " unknown event (" + id + "), temporary: ");
        return line + evt.isTemporary();
    }

    public String getHelpText() {
        return "The aim: test the throwing and the correct layout of FocusEvents:\n\nThe test: The upper part of the screen consists out of 4 rows of each a focus-request button, a focus listener display and a focus traversable checkbox.\nThe listener display is linked to a focus listener so thatwhen it gains or looses focus, it will change color and display a FocusEvent message in the list below\nThe request buttons send a requestFocus() call on behalf of their listeners. The checkboxes set the focusTraversable property of their listeners to true or false while clicking on <transfer> bos of a listener makes that listener throw a transferFocus() request\n(The buttons, checkboxes and list are overridden so their focusTraversable property is always FALSE)\n\nItems to test:\n- focus gained event: When pressing a display, this display should become selected, the framework will receive and display a FocusEvent on its behalf and the display itself should change color to indicate that it is selected.\n- focus lost event: When pressing another item, pressing the list or pressing one of the VisualTestengine buttons, you should loose focus to the original display: the display changes back to its original color and a  focusLost vent should be displayed in the list\n- Requesting focus: pushing a <request> button makes the adjecent display call a requestFocus() command. Directly afterwardsthe framework should give focus to this display and throw a focusGained() event to note this\n   (the list displays this event and the display changes color)\n)- Traversing focus: Clicking the <transfer> rectangle on a display should force a transferFocus() request: The display will loose focus(focusLostEvent on the list) and the next traversable element should get the focus.\n   (If this is a display just as well, its focusGained event will be shown just as well)- Key traversing: the focus should equally be transferred to the next traversable element by pressing the <tab>-key\n- <next traversable element>: A focus is transferred to the next Component that is transversable, eg. its Component.isTraversable() function returns true. the buttons, checkboxes and list of this test have all been made untraversable, so the focus will wander between the TestEngine buttons on the right and the display panels. Using the checkboxes you can make a display untraversable and see it being <jumped over> in the transversable sequences\n   (also note the traversable request messages in the event list for each component which traversability is checked)\n";
    }

    class FocusDisplay
    extends AWTEventDisplay
    implements MouseListener {
        private boolean hasFocus;
        private Checkbox transferFlag;
        private Rectangle transferBox;

        public FocusDisplay(String title, Checkbox indicator, Color back, Color front) {
            super(title, back, front);
            this.transferFlag = indicator;
            this.hasFocus = false;
            this.addMouseListener(this);
            this.transferBox = new Rectangle();
        }

        public boolean isFocusTraversable() {
            boolean flag = this.transferFlag.getState();
            FocusEventTest.this.displayEventMessage("checked focus traversable on <" + this.message + "> : " + flag);
            return flag;
        }

        public void setFocus(boolean focus) {
            this.hasFocus = focus;
            this.repaint();
        }

        public String toString() {
            return this.message;
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.transferBox.contains(evt.getX(), evt.getY())) {
                FocusEventTest.this.displayEventMessage("<" + this.message + "> : transferred focus");
                this.transferFocus();
            }
        }

        public void update(Graphics g) {
            if (this.frame.width <= 0) {
                this.frame.setSize(this.getSize().width - 2, this.getSize().height - 2);
                this.inside.setBounds(3, 3, this.frame.width - 5, this.frame.height - 5);
                this.transferBox.setBounds(this.frame.width - 45, 5, 40, this.frame.height - 10);
            }
            g.setColor(this.hasFocus ? this.foreground : this.background);
            g.fillRect(1, 1, this.frame.width, this.frame.height);
            g.setColor(this.hasFocus ? this.background : this.foreground);
            g.drawRect(this.inside.x, this.inside.y, this.inside.width, this.inside.height);
            g.drawRect(this.transferBox.x, this.transferBox.y, this.transferBox.width, this.transferBox.height);
            g.drawString(this.message, 20, this.inside.height);
            g.drawString("transfer", this.transferBox.x + 3, this.inside.height - 2);
        }
    }

    class NoTransferList
    extends List {
        public NoTransferList(int preferred) {
            super(preferred, false);
        }

        public boolean isFocusTraversable() {
            FocusEventTest.this.displayEventMessage("isFocusTraversable event list false by def.");
            return false;
        }
    }

    class NoTransferCheckbox
    extends Checkbox {
        private String name;

        public NoTransferCheckbox(String label, String name) {
            super(label, true);
            this.name = name;
        }

        public boolean isFocusTraversable() {
            FocusEventTest.this.displayEventMessage("isFocusTraversable Checkbox <" + this.name + "> false by def.");
            return false;
        }
    }

    class NoTransferButton
    extends Button {
        private String name;

        public NoTransferButton(String label, String name) {
            super(label);
            this.name = name;
        }

        public boolean isFocusTraversable() {
            FocusEventTest.this.displayEventMessage("isFocusTraversable Button <" + this.name + "> false by def.");
            return false;
        }
    }
}

