/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.ActionDisplay;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import com.acunia.wonka.test.awt.event.MouseGeneratorComponent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ActionMulticastTest
extends VisualTestImpl
implements ActionListener,
CollectsEvents {
    private Button[] add;
    private Button[] remove;
    private ActionDisplay[] display;
    private ActionGeneratorComponent actionGenerator;
    static final int LISTENERS = 5;

    public ActionMulticastTest() {
        this.setForeground(new Color(80, 32, 40));
        this.setBackground(new Color(160, 64, 96));
        int step = 20;
        int red = 155;
        int blue = 155;
        this.setLayout(new BorderLayout());
        this.actionGenerator = new ActionGeneratorComponent("<Action Slider>", this.getBackground(), this.getForeground(), this);
        this.add((Component)this.actionGenerator, "Center");
        Panel listeners = new Panel(new GridLayout(5, 1));
        Panel[] row = new Panel[5];
        this.add = new Button[5];
        this.display = new ActionDisplay[5];
        this.remove = new Button[5];
        for (int i = 0; i < 5; ++i) {
            row[i] = new Panel(new BorderLayout());
            this.display[i] = new ActionDisplay("Press <add> to add a listener to this panel", new Color(red, 64, blue), this.getForeground());
            row[i].add((Component)this.display[i], "Center");
            this.add[i] = new Button("Add");
            this.add[i].setBackground(new Color(red += step, 64, blue));
            this.add[i].addActionListener(this);
            row[i].add((Component)this.add[i], "West");
            this.remove[i] = new Button("Remove");
            this.remove[i].setBackground(new Color(red, 64, blue += step));
            this.remove[i].addActionListener(this);
            row[i].add((Component)this.remove[i], "East");
            listeners.add(row[i]);
        }
        this.add((Component)listeners, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        boolean found = false;
        Object source = evt.getSource();
        for (int i = 0; i < 5 && !found; ++i) {
            if (source == this.add[i]) {
                this.actionGenerator.addActionListener(this.display[i]);
                this.display[i].displayMessage("Listener added. press <remove> to remove it again");
                found = true;
                continue;
            }
            if (source != this.remove[i]) continue;
            this.actionGenerator.removeActionListener(this.display[i]);
            this.display[i].displayMessage("Listener removed. press <add> to add it again");
            found = true;
        }
    }

    public void displayMessage(String[] messagestrings) {
    }

    public String getHelpText() {
        return "The aim: test the throwing of ItemEvents through the AWTEventMulticaster functions:\n\nThe screen consists out of one black event field and 5 yellow ItemDisplay panels. Each of this panels is flanked by an <add> and a <remove> button.\nThe event field throws an ItemEvent every time the mouse is pressed or released inside it. with the <add> and <remove> buttons, you can add an ItemListener to a panel in order to get the ItemEvents displayed on that panel, or remove the listener again again\n.Adding and removing is done by calls to the static AWTEventMulticaster.Add()and -remove() functions\n\n Items to test : \n -------------\n => Pressing <add> for a panel and subsequently clicking in the event field to check if the Item event is displayed on the newly selected panel, as well as on all other previously selected panels\n => Pressing <remove> for a panel and subsequently clicking in the event field to check if the Item event is no longer displayed on that panel, nor on the panels previously deselected, yet remains displayed on all other panels still selected\n => Pressing <add> for the same panel over and over again to see that the panel is not added twice\n => Pressing <remove> for the same panel over and over again, or pressing <remove> on a panel to which no listener is added yet to check that a panel is not removed twice\n \n ps. as the Add and remove routines have a slightly different algorithm for the first and second listener then for all subsequent listeners, specially check the behavior when \n    - adding the first panel, adding the second panel, adding the third panel\n    - removing the third-last panel, removing the second-last panel, removing the last panel\n    - giving a remove-command when no panels are selected";
    }

    class ActionGeneratorComponent
    extends MouseGeneratorComponent
    implements MouseListener {
        transient ActionListener multiListener;

        public ActionGeneratorComponent(String componentname, Color back, Color front, CollectsEvents parentinstance) {
            super(componentname, back, front, parentinstance);
            this.addMouseListener(this);
            this.multiListener = null;
        }

        public void addActionListener(ActionListener newlistener) {
            this.multiListener = AWTEventMulticaster.add(this.multiListener, newlistener);
        }

        public void removeActionListener(ActionListener oldlistener) {
            this.multiListener = AWTEventMulticaster.remove(this.multiListener, oldlistener);
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
            this.currentColor = this.currentColor > 0 ? --this.currentColor : colors.length - 1;
            this.repaint();
        }

        public void mousePressed(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            this.gridPoint.y = -this.gridPoint.y;
            this.connected = true;
            if (this.multiListener != null) {
                this.multiListener.actionPerformed(new ActionEvent(this.gridPoint, 1001, colornames[this.currentColor]));
            }
            this.repaint();
        }

        public void mouseReleased(MouseEvent event) {
            this.gridPoint = this.screenToGrid(event.getPoint());
            this.screenPoint = this.gridToScreen(this.gridPoint);
            this.mousePoint = event.getPoint();
            this.gridPoint.y = -this.gridPoint.y;
            this.connected = false;
            if (this.multiListener != null) {
                this.multiListener.actionPerformed(new ActionEvent(this.gridPoint, 1001, colornames[this.currentColor]));
            }
            this.repaint();
        }
    }
}

