/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.dnd;

import java.awt.TextField;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringBufferInputStream;

class DragText
extends TextField
implements Transferable,
DragGestureListener,
DragSourceListener {
    private static DataFlavor[] dataFlavors = new DataFlavor[]{DragText.createDataFlavor(), DataFlavor.plainTextFlavor, DataFlavor.stringFlavor};
    private transient int dropAction;

    private static DataFlavor createDataFlavor() {
        try {
            return new DataFlavor("text/plain; charset=iso8859-1", "String");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    DragText(String txt) {
        super(txt);
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this, 1, this);
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        System.out.println("DragText.dragGestureRecognized");
        try {
            dge.startDrag(null, this, null);
        }
        catch (InvalidDnDOperationException idndoe) {
            System.out.println("InvalidDnDOperationException: " + idndoe.getMessage());
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        System.out.println("DragText.dragEnter");
        dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
    }

    public void dragOver(DragSourceDragEvent dsde) {
        System.out.println("DragText.dragOver");
        Thread.dumpStack();
    }

    public void dragGestureChanged(DragSourceDragEvent dsde) {
        System.out.println("DragText.dragGestureChanged");
        Thread.dumpStack();
    }

    public void dragExit(DragSourceEvent dse) {
        System.out.println("DragText.dragExit");
        dse.getDragSourceContext().setCursor(null);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        System.out.println("DragText.dragDropEnd");
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        System.out.println("DragText.dropActionChanged");
    }

    public DataFlavor[] getTransferDataFlavors() {
        System.out.println("DragText.getTransferDataFlavors");
        return dataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        System.out.println("DragText.isDataFlavorSupported");
        for (int i = 0; i < dataFlavors.length; ++i) {
            if (!dataFlavors[i].equals(df)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        System.out.println("DragText.getTransferData");
        if (!this.isDataFlavorSupported(df)) {
            throw new UnsupportedFlavorException(df);
        }
        String originalText = this.getText();
        if (DataFlavor.stringFlavor.equals(df)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(originalText);
            }
            catch (Exception e) {
                throw new IOException();
            }
            return new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        }
        StringBufferInputStream sbis = new StringBufferInputStream(originalText);
        return sbis;
    }
}

