/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Window;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WindowUpdate
extends VisualTestImpl
implements ActionListener {
    private static final Color[] COLORS = new Color[]{new Color(128, 0, 128), new Color(0, 0, 128), new Color(96, 96, 255), Color.green, Color.yellow, Color.orange, Color.red};
    private static final Color DARKRED = new Color(96, 48, 48);
    private static final Color LIGHTRED = new Color(192, 96, 96);
    private static final Color DARKGREEN = new Color(48, 96, 48);
    private static final Color LIGHTGREEN = new Color(96, 192, 96);
    private static final Color DARKBLUE = new Color(48, 48, 96);
    private static final Color LIGHTBLUE = new Color(96, 96, 192);
    private static final int WINWIDTH = 70;
    private static final int WINHEIGHT = 50;
    private static final int WINSTEP = 15;
    private Button leftOne;
    private Button rightOne;
    private Button upOne;
    private Button downOne;
    private Button frontOne;
    private Button repaintOne;
    private Button leftTwo;
    private Button rightTwo;
    private Button upTwo;
    private Button downTwo;
    private Button frontTwo;
    private Button repaintTwo;
    private Button repaintMain;
    private Button repaintBottom;
    private Window one = null;
    private InnerPaintComponent onePanel = new InnerPaintComponent("Red window", LIGHTRED, DARKRED);
    private int framexOne;
    private int frameyOne;
    private Window two = null;
    private InnerPaintComponent twoPanel = new InnerPaintComponent("Blue window", LIGHTBLUE, DARKBLUE);
    private int framexTwo;
    private int frameyTwo;
    private InnerPaintComponent mainPanel;
    private int mainWidth;
    private int mainHeight;
    private int mainLeft;
    private int mainRight;
    private int mainTop;
    private int mainBottom;
    private List display;

    public WindowUpdate() {
        this.setBackground(new Color(192, 192, 96));
        this.setLayout(new BorderLayout());
        Panel top = new Panel(new FlowLayout());
        top.add(new Label("Main component"));
        this.repaintMain = new Button("repaint() main");
        this.repaintMain.setBackground(LIGHTGREEN);
        this.repaintMain.addActionListener(this);
        top.add(this.repaintMain);
        this.repaintBottom = new Button("repaint() bottom half");
        this.repaintBottom.setForeground(Color.white);
        this.repaintBottom.setBackground(DARKGREEN);
        this.repaintBottom.addActionListener(this);
        top.add(this.repaintBottom);
        this.add((Component)top, "North");
        Panel onebuttons = new Panel(new GridLayout(8, 1));
        onebuttons.setBackground(LIGHTRED);
        onebuttons.add(new Label("RED WINDOW"));
        this.frontOne = new Button("to front");
        this.frontOne.addActionListener(this);
        onebuttons.add(this.frontOne);
        this.repaintOne = new Button("repaint()");
        this.repaintOne.setForeground(Color.white);
        this.repaintOne.setBackground(DARKRED);
        this.repaintOne.addActionListener(this);
        onebuttons.add(this.repaintOne);
        onebuttons.add(new Label());
        this.leftOne = new Button("left =>");
        this.leftOne.addActionListener(this);
        onebuttons.add(this.leftOne);
        this.rightOne = new Button("<= right");
        this.rightOne.addActionListener(this);
        onebuttons.add(this.rightOne);
        this.upOne = new Button("up =^");
        this.upOne.addActionListener(this);
        onebuttons.add(this.upOne);
        this.downOne = new Button("down =v");
        this.downOne.addActionListener(this);
        onebuttons.add(this.downOne);
        this.add((Component)onebuttons, "West");
        Panel twobuttons = new Panel(new GridLayout(8, 1));
        twobuttons.setBackground(LIGHTBLUE);
        twobuttons.add(new Label("BLUE WINDOW"));
        this.frontTwo = new Button("to front");
        this.frontTwo.addActionListener(this);
        twobuttons.add(this.frontTwo);
        this.repaintTwo = new Button("repaint()");
        this.repaintTwo.setForeground(Color.white);
        this.repaintTwo.setBackground(DARKBLUE);
        this.repaintTwo.addActionListener(this);
        twobuttons.add(this.repaintTwo);
        twobuttons.add(new Label());
        this.leftTwo = new Button("left =>");
        this.leftTwo.addActionListener(this);
        twobuttons.add(this.leftTwo);
        this.rightTwo = new Button("<= right");
        this.rightTwo.addActionListener(this);
        twobuttons.add(this.rightTwo);
        this.upTwo = new Button("up =^");
        this.upTwo.addActionListener(this);
        twobuttons.add(this.upTwo);
        this.downTwo = new Button("down =v");
        this.downTwo.addActionListener(this);
        twobuttons.add(this.downTwo);
        this.add((Component)twobuttons, "East");
        this.mainPanel = new InnerPaintComponent("Main panel", LIGHTGREEN, DARKGREEN);
        this.add((Component)this.mainPanel, "Center");
        this.display = new List(3, false);
        this.add((Component)this.display, "South");
    }

    public void checkWindowOne() {
        if (this.one == null) {
            if (this.vt == null) {
                this.displayMessage("Skipped windows for lack of VT instance");
            } else {
                Frame vtframe = this.vt.getFrame();
                if (vtframe == null) {
                    this.displayMessage("Skipped Windows for lack of vt.getFrame()");
                } else {
                    this.getMainBounds();
                    this.framexOne = this.mainLeft + this.mainWidth / 2 - 35 - 20;
                    this.frameyOne = this.mainTop + this.mainHeight / 2 - 25 - 20;
                    this.one = new Window(vtframe);
                    this.one.add(this.onePanel);
                    this.one.pack();
                    this.one.setLocation(this.framexOne, this.frameyOne);
                    this.one.setVisible(true);
                    this.displayMessage("Built window one");
                }
            }
        }
    }

    public void checkWindowTwo() {
        if (this.two == null) {
            if (this.vt == null) {
                this.displayMessage("Skipped windows for lack of VT instance");
            } else {
                Frame vtframe = this.vt.getFrame();
                if (vtframe == null) {
                    this.displayMessage("Skipped Windows for lack of vt.getFrame()");
                } else {
                    this.getMainBounds();
                    this.framexTwo = this.mainLeft + this.mainWidth / 2 - 35 + 20;
                    this.frameyTwo = this.mainTop + this.mainHeight / 2 - 25 + 20;
                    this.two = new Window(vtframe);
                    this.two.add(this.twoPanel);
                    this.two.pack();
                    this.two.setLocation(this.framexTwo, this.frameyTwo);
                    this.two.setVisible(true);
                    this.displayMessage("Built window two");
                }
            }
        }
    }

    public void getMainBounds() {
        Rectangle bounds = this.mainPanel.getBounds();
        Point offset = this.mainPanel.getLocationOnScreen();
        this.mainWidth = bounds.width;
        this.mainHeight = bounds.height;
        this.mainLeft = offset.x;
        this.mainRight = offset.x + this.mainWidth - 70;
        this.mainTop = offset.y;
        this.mainBottom = offset.y + this.mainHeight - 50;
    }

    public void actionPerformed(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        if (source == this.repaintMain) {
            this.mainPanel.repaint();
        } else if (source == this.repaintBottom) {
            this.mainPanel.repaint(0, this.mainHeight / 2, this.mainWidth, this.mainHeight / 2);
        } else if (source == this.rightOne) {
            this.checkWindowOne();
            this.framexOne = this.framexOne > this.mainLeft + 15 ? this.framexOne - 15 : this.mainLeft;
            this.one.setLocation(this.framexOne, this.frameyOne);
        } else if (source == this.leftOne) {
            this.checkWindowOne();
            this.framexOne = this.framexOne < this.mainRight - 15 ? this.framexOne + 15 : this.mainRight;
            this.one.setLocation(this.framexOne, this.frameyOne);
        } else if (source == this.upOne) {
            this.checkWindowOne();
            this.frameyOne = this.frameyOne > this.mainTop + 15 ? this.frameyOne - 15 : this.mainTop;
            this.one.setLocation(this.framexOne, this.frameyOne);
        } else if (source == this.downOne) {
            this.checkWindowOne();
            this.frameyOne = this.frameyOne < this.mainBottom - 15 ? this.frameyOne + 15 : this.mainBottom;
            this.one.setLocation(this.framexOne, this.frameyOne);
        } else if (source == this.frontOne) {
            this.checkWindowOne();
            this.one.toFront();
        } else if (source == this.repaintOne) {
            this.checkWindowOne();
            this.onePanel.repaint();
        } else if (source == this.rightTwo) {
            this.checkWindowTwo();
            this.framexTwo = this.framexTwo > this.mainLeft + 15 ? this.framexTwo - 15 : this.mainLeft;
            this.two.setLocation(this.framexTwo, this.frameyTwo);
        } else if (source == this.leftTwo) {
            this.checkWindowTwo();
            this.framexTwo = this.framexTwo < this.mainRight - 15 ? this.framexTwo + 15 : this.mainRight;
            this.two.setLocation(this.framexTwo, this.frameyTwo);
        } else if (source == this.upTwo) {
            this.checkWindowTwo();
            this.frameyTwo = this.frameyTwo > this.mainTop + 15 ? this.frameyTwo - 15 : this.mainTop;
            this.two.setLocation(this.framexTwo, this.frameyTwo);
        } else if (source == this.downTwo) {
            this.checkWindowTwo();
            this.frameyTwo = this.frameyTwo < this.mainBottom - 15 ? this.frameyTwo + 15 : this.mainBottom;
            this.two.setLocation(this.framexTwo, this.frameyTwo);
        } else if (source == this.frontTwo) {
            this.checkWindowTwo();
            this.two.toFront();
        } else if (source == this.repaintTwo) {
            this.checkWindowTwo();
            this.twoPanel.repaint();
        }
    }

    private void displayMessage(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(message, 0);
        System.out.println(message);
    }

    public String getHelpText() {
        return "A test on the interaction between the update() and paint() commands for systems with overlaying windows in different virtual engines\n Two windows will be shown on a central panel. Both windows and panel only consists out of one basic paint component. To refresh the content of the component, a paint() and an update() function are implemented, both behaving slightly different:\n=> the paint() function gets the graphics clipping bounds (Graphics.getClipBounds()) and repaints the area inside this clipping bounds in a light color (it also draws a white line around the clipping rectangle). Then it displays a message <Executed paint()> in the display list below\n=> the update() function also gets the graphics clipping bounds but repaints the area inside this clipping bounds in a darker color and displays an <Executed update()> message. (it also draws a white line around the clipping rectangle) \n(If the clipping bound is <NULL>, it is being replaced by the complete screen)\n\nMove the windows over the screen, bring them to front and to back, repaint them, repaint the screen andwatch when a paint() and when an update() is called for what area. Play around with different virtual engines and note the differences";
    }

    public void stop(Panel p) {
        if (this.one != null) {
            this.one.dispose();
            this.one = null;
        }
        if (this.two != null) {
            this.two.dispose();
            this.two = null;
        }
    }

    class InnerPaintComponent
    extends Panel {
        private int updateCount;
        private int paintCount;
        private String name;
        private Color paintColor;
        private Color updateColor;

        public InnerPaintComponent(String componentname, Color paint, Color update) {
            this.name = componentname;
            this.paintCount = 0;
            this.updateCount = 0;
            this.paintColor = paint;
            this.updateColor = update;
        }

        public Dimension getPreferredSize() {
            return new Dimension(70, 50);
        }

        public void paint(Graphics g) {
            ++this.paintCount;
            WindowUpdate.this.displayMessage(this.name + ": Received call to paint(), total paints = " + this.paintCount);
            Rectangle bounds = this.paintArea(g.getClipBounds(), this.paintColor, g);
            WindowUpdate.this.displayMessage(this.name + ": Executed paint() for bounds (" + bounds.x + ", " + bounds.y + ", " + bounds.width + ", " + bounds.height + ")");
        }

        public void update(Graphics g) {
            ++this.updateCount;
            WindowUpdate.this.displayMessage(this.name + ": Received call to update(), total updates = " + this.updateCount);
            Rectangle bounds = this.paintArea(g.getClipBounds(), this.updateColor, g);
            WindowUpdate.this.displayMessage(this.name + ": Executed update() for bounds (" + bounds.x + ", " + bounds.y + ", " + bounds.width + ", " + bounds.height + ")");
        }

        private Rectangle paintArea(Rectangle bounds, Color background, Graphics g) {
            if (bounds == null) {
                bounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
                WindowUpdate.this.displayMessage("NULL bounds: Reverting to full screen (0, 0, " + bounds.width + ", " + bounds.height + ")");
            }
            g.setColor(background);
            g.fillRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            g.setColor(Color.white);
            g.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            g.drawString(this.name, 3, 14);
            g.setColor(COLORS[this.updateCount % COLORS.length]);
            g.drawString("Updates " + this.updateCount, 3, 28);
            g.setColor(COLORS[this.paintCount % COLORS.length]);
            g.drawString("Paints = " + this.paintCount, 3, 42);
            return bounds;
        }
    }
}

