/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Window;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ShowWindowTest
extends VisualTestImpl
implements ActionListener {
    private Window firstWindow = null;
    private Button showFirst;
    private Button hideFirst;
    private Window secondWindow = null;
    private Button showSecond;
    private Button hideSecond;
    private Window thirdWindow = null;
    private Button showThird;
    private Button hideThird;
    private Window fourthWindow = null;
    private Button showFourth;
    private Button hideFourth;
    private List display;

    public ShowWindowTest() {
        this.setLayout(new BorderLayout());
        this.display = new List(3, false);
        this.display.add("Dialog outcome dispayed here");
        this.add((Component)this.display, "South");
        Panel buttons = new Panel(new GridLayout(6, 2));
        buttons.add(new Label("first (red) Window:"));
        buttons.add(new Label("second (blue) Window:"));
        this.showFirst = new Button("show Window");
        this.showFirst.addActionListener(this);
        buttons.add(this.showFirst);
        this.showSecond = new Button("show Window");
        this.showSecond.addActionListener(this);
        buttons.add(this.showSecond);
        this.hideFirst = new Button("hide Window");
        this.hideFirst.addActionListener(this);
        buttons.add(this.hideFirst);
        this.hideSecond = new Button("hide Window");
        this.hideSecond.addActionListener(this);
        buttons.add(this.hideSecond);
        buttons.add(new Label("third (green) Window:"));
        buttons.add(new Label("fourth (black) Window:"));
        this.showThird = new Button("show Window");
        this.showThird.addActionListener(this);
        buttons.add(this.showThird);
        this.showFourth = new Button("show Window");
        this.showFourth.addActionListener(this);
        buttons.add(this.showFourth);
        this.hideThird = new Button("hide Window");
        this.hideThird.addActionListener(this);
        buttons.add(this.hideThird);
        this.hideFourth = new Button("hide Window");
        this.hideFourth.addActionListener(this);
        buttons.add(this.hideFourth);
        this.add((Component)buttons, "Center");
    }

    public void stop(Panel p) {
        if (this.firstWindow != null) {
            this.firstWindow.dispose();
            this.firstWindow = null;
        }
        if (this.secondWindow != null) {
            this.secondWindow.dispose();
            this.secondWindow = null;
        }
        if (this.thirdWindow != null) {
            this.thirdWindow.dispose();
            this.thirdWindow = null;
        }
        if (this.fourthWindow != null) {
            this.fourthWindow.dispose();
            this.fourthWindow = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        if (source == this.showFirst) {
            if (this.checkFirst()) {
                this.firstWindow.show();
                this.displayText("first (red) Window shown");
            }
        } else if (source == this.hideFirst) {
            if (this.checkFirst()) {
                this.firstWindow.setVisible(false);
                this.displayText("first (red) Window hidden");
            }
        } else if (source == this.showSecond) {
            if (this.checkSecond()) {
                this.secondWindow.show();
                this.displayText("second (blue) Window shown");
            }
        } else if (source == this.hideSecond) {
            if (this.checkSecond()) {
                this.secondWindow.setVisible(false);
                this.displayText("second (blue) Window hidden");
            }
        } else if (source == this.showThird) {
            if (this.checkThird()) {
                this.thirdWindow.show();
                this.displayText("third (green) Window shown");
            }
        } else if (source == this.hideThird) {
            if (this.checkThird()) {
                this.thirdWindow.setVisible(false);
                this.displayText("third (green) Window hidden");
            }
        } else if (source == this.showFourth) {
            if (this.checkFourth()) {
                this.fourthWindow.show();
                this.displayText("fourth (black) Window shown");
            }
        } else if (source == this.hideFourth && this.checkFourth()) {
            this.fourthWindow.setVisible(false);
            this.displayText("fourth (black) Window hidden");
        }
    }

    private void displayText(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(text, 0);
        System.out.println(text);
    }

    private boolean checkFirst() {
        this.displayText("Checking first Window: " + this.firstWindow);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.firstWindow == null) {
            this.firstWindow = new Window(vtframe);
            this.firstWindow.setLayout(new FlowLayout());
            this.firstWindow.setBackground(Color.red);
            this.firstWindow.setForeground(Color.white);
            this.firstWindow.add(new Label("The first (red) Window", 1));
            this.firstWindow.pack();
            this.displayText("Build first Window " + this.firstWindow);
            return true;
        }
        return true;
    }

    private boolean checkSecond() {
        this.displayText("Checking second Window: " + this.secondWindow);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.secondWindow == null) {
            this.secondWindow = new Window(vtframe);
            this.secondWindow.setLayout(new FlowLayout());
            this.secondWindow.setBackground(Color.blue);
            this.secondWindow.setForeground(Color.white);
            this.secondWindow.add(new Label("The second (blue) Window", 1));
            this.secondWindow.pack();
            this.displayText("Build second Window " + this.secondWindow);
            return true;
        }
        return true;
    }

    private boolean checkThird() {
        this.displayText("Checking third Window: " + this.thirdWindow);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.thirdWindow == null) {
            this.thirdWindow = new Window(vtframe);
            this.thirdWindow.setLayout(new FlowLayout());
            this.thirdWindow.setBackground(Color.green);
            this.thirdWindow.setForeground(Color.white);
            this.thirdWindow.add(new Label("The third (green) Window", 1));
            this.thirdWindow.pack();
            this.displayText("Build third Window " + this.thirdWindow);
            return true;
        }
        return true;
    }

    private boolean checkFourth() {
        this.displayText("Checking fourth Window: " + this.fourthWindow);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.fourthWindow == null) {
            this.fourthWindow = new Window(vtframe);
            this.fourthWindow.setLayout(new FlowLayout());
            this.fourthWindow.setBackground(Color.black);
            this.fourthWindow.setForeground(Color.white);
            this.fourthWindow.add(new Label("The fourth (black) Window", 1));
            this.fourthWindow.pack();
            this.displayText("Build fourth Window " + this.fourthWindow);
            return true;
        }
        return true;
    }

    public String getHelpText() {
        return "Test on the construction and behavior of the java.awt.Window class:\nThere are four windows. Each group of buttons allow to show or to hide them. (As the main Wonka frame vt.getFrame() is not available at first startup, the windows will be constructed the first time one of the buttons is pressed)\nCheck that the windows are attached to the right frame and shown/hidden on command as they are supposed to.\n\nCURRENT ISSUE:\n In some cases, the windows are attached to the underlying frame and painted over by the test, or even drawn on a different panel alltogether. Probably this has something to do with the order of displaying.";
    }

    public static void main(String[] args) {
        new ShowWindowTest();
    }
}

