/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.TextArea;

import com.acunia.wonka.test.awt.VisualTest;
import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Writer;

public class TextAreaTest
extends VisualTestImpl
implements VisualTest,
ActionListener {
    private Button[] scrollbars;
    private Button fixwidth;
    private Button varwidth;
    private boolean isFixedWidth;
    private Button up;
    private Button down;
    private Panel areaPanel;
    private CardLayout areaCardLayout;
    private TextArea[] areas;
    private int currentArea;
    private TextField theField;
    private String[] labels = new String[]{"BOTH BARS", "VERTICAL", "HORIZONTAL", "NO BARS"};
    private String areaText = new String("I) Here Comes Charly\n====================\n\nThese two very old people are the father and mother of Mr Bucket. Their names are Grandpa Joe and Grandma Josephine.\nAnd these two very old people are the father and mother of Mrs Bucket. Their names are Grandpa George and Grandma Georgina.\nThis is Mr Bucket. This is Mrs Bucket.\nMr and Mrs Bucket have a small boy whose name is Charly Bucket.\n\nThis is Charly.\nHow d'you do? And how d'you do?. And how d'you do again? he is pleased to meet you.");
    private Font cour14 = new Font("courR14", 0, 14);
    private Font helv14 = new Font("helvR14", 0, 14);
    private String logString;

    public TextAreaTest() {
        this(0, true);
    }

    public TextAreaTest(int scrollbarmode, boolean fixed) {
        int i;
        this.setBackground(new Color(255, 220, 150));
        this.setForeground(new Color(64, 64, 192));
        this.setLayout(new BorderLayout());
        this.currentArea = scrollbarmode < 0 ? 0 : (scrollbarmode > 3 ? 3 : scrollbarmode);
        this.isFixedWidth = fixed;
        Panel buttonrow = new Panel(new GridLayout(1, 6));
        this.scrollbars = new Button[4];
        for (i = 0; i < 4; ++i) {
            this.scrollbars[i] = new Button(this.labels[i]);
            this.scrollbars[i].addActionListener(this);
            buttonrow.add(this.scrollbars[i]);
        }
        this.fixwidth = new Button("Courier");
        this.fixwidth.addActionListener(this);
        buttonrow.add(this.fixwidth);
        this.varwidth = new Button("Helvetica");
        this.varwidth.addActionListener(this);
        buttonrow.add(this.varwidth);
        this.add((Component)buttonrow, "North");
        this.areaCardLayout = new CardLayout();
        this.areaPanel = new Panel(this.areaCardLayout);
        this.areas = new TextArea[4];
        for (i = 0; i < 4; ++i) {
            this.areas[i] = new TextArea("", 10, 20, i);
            this.areaPanel.add((Component)this.areas[i], this.labels[i]);
        }
        this.currentArea = 0;
        this.areas[this.currentArea].setText(this.areaText);
        this.areas[this.currentArea].setFont(this.isFixedWidth ? this.cour14 : this.helv14);
        this.areaCardLayout.show(this.areaPanel, this.labels[this.currentArea]);
        this.add((Component)this.areaPanel, "Center");
        this.down = new Button("DOWN");
        this.down.addActionListener(this);
        this.add((Component)this.down, "East");
        this.up = new Button("UP");
        this.up.addActionListener(this);
        this.add((Component)this.up, "West");
        this.theField = new TextField();
        this.add((Component)this.theField, "South");
        this.logString = new String();
        this.setSize(399, 199);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        int newarea = -1;
        for (int i = 0; i < 4 && newarea < 0; ++i) {
            if (e.getSource() != this.scrollbars[i]) continue;
            newarea = i;
        }
        int cursor = this.areas[this.currentArea].getCaretPosition();
        if (newarea >= 0 && newarea != this.currentArea) {
            this.logString = this.logString + "\n\n       ============================";
            String text = this.areas[this.currentArea].getText();
            int start = this.areas[this.currentArea].getSelectionStart();
            int stop = this.areas[this.currentArea].getSelectionEnd();
            this.logString = this.logString + ".......old TextArea(" + this.currentArea + "):found positions start=" + start + ", stop=" + stop + ", cursor=" + cursor;
            this.logString = this.logString + ".......new TextArea(" + newarea + "):setting data ";
            this.areas[newarea].setFont(this.isFixedWidth ? this.cour14 : this.helv14);
            this.areas[newarea].setText(text);
            this.areas[newarea].setSelectionStart(start);
            this.areas[newarea].setSelectionEnd(stop);
            this.areas[newarea].setCaretPosition(cursor);
            this.areaCardLayout.show(this.areaPanel, this.labels[newarea]);
            this.currentArea = newarea;
            this.logString = this.logString + "       =======  TextArea(" + newarea + "):  d o n e    ====== \n";
        } else if (e.getSource() == this.fixwidth) {
            this.areas[this.currentArea].setFont(this.cour14);
            this.isFixedWidth = true;
        } else if (e.getSource() == this.varwidth) {
            this.areas[this.currentArea].setFont(this.helv14);
            this.isFixedWidth = false;
        } else if (e.getSource() == this.up) {
            this.areas[this.currentArea].setCaretPosition(cursor > 20 ? cursor - 20 : 0);
            this.theField.setText("From position " + cursor + " moved cursor 20 chars up ");
        } else if (e.getSource() == this.down) {
            this.areas[this.currentArea].setCaretPosition(cursor + 20);
            this.theField.setText("From position " + cursor + " moved cursor 20 chars down ");
        }
    }

    public Panel getPanel() {
        return this;
    }

    public String getTitle() {
        return "TextAreaTest";
    }

    public String getHelpText() {
        String help = "All-in-one test for java.awt.TextArea, it displays a series of buttons, a textfield and a central textarea. The textarea displays a multi-line text.\n";
        help = help + "You can do the following tests:\n";
        help = help + "\n=> Changing the textArea layout using the upper row buttons : \n";
        help = help + "   A textarea can have a horizontal scrollbar, a vertical scrollbar, both or none of them. All of that defines their visibility and the way it reacts on certain commande. furthermore the text can have different fonts\n";
        help = help + "   The buttons allow you to switch between the differnt textarea types and choose either a fixed or variable width font:\n";
        help = help + "   - (BOTH BARS) switches to a TextArea with horizontal and vertical bars (Text scrolls horizontally and vertically)\n";
        help = help + "   - (VERTICAL) switches to a TextArea with only one vertical bar (Text is wrapped to viewport and scrolls vertically)\n";
        help = help + "   - (HORIZONTAL) switches to a TextArea with only one horizontal bar (Text scrolls horizontally, can move vertically through mouse scrolling)\n";
        help = help + "   - (NO BARS) switches to a TextArea without bars. The text is wrapped to the viewport width. It can move vertically through mouse scrolling\n";
        help = help + "   - (Courier) Displays the text area text in a 14pt Courier font (Fixed width)\n";
        help = help + "   - (Helvetica) Displays the text area text in a 14pt Helvetica font (Fixed width)\n";
        help = help + "\n=> Textarea scrolling and selecting : \n";
        help = help + "   You can use the scrollbars to scroll the text area of a textarea. Furthermore you can select a part of the displayed text and change the visible area by dragging a selection of text across the area border\n";
        help = help + "   - Scrollbar scrolling: by clicking or moving the scrollbars, you can move the visible area of the text\n";
        help = help + "   - Selecting text: by clicking inside the text area, you place the 'text cursor' between the two closest characters of the text. By dragging the mouse over a part of the text, you select this part.\n";
        help = help + "   - horizontal mouse scrolling: by dragging the mouse from inside the text area over the bottom of the area, the text in the  area moves up to keep the selection in the viewport, likewise when dragging the mouse over the top of the area, the text moves down  for textareas without a vertical bar, this is the only means of viewing the text above or under the current viewport\n";
        help = help + "   - vertical mouse scrolling: If the text is not line-wrapped (a horizontal scrollbar is present), dragging the mouse  over the left border moves the text right and dragging the mouse over the right border moves the text left, similar to the  horizontal mouse scrolling\n";
        help = help + "\n=> Inserting and replacing text: \n";
        help = help + "   - the button (DOWN) displays the currently selected text in the TextField on the bottom of the screen. (if no selection is made, pressing the button clears the textfield)\n";
        help = help + "   - if a selection is made, the button (UP) replaces the selected text with the contents of the TextField below (if the textfield is empty, the selection is deleted). If no selection is made, pressing the button inserts the contents of the textfiels into the textarea's cursor position\n";
        return help;
    }

    public void log(Panel p, Writer w) throws IOException {
        w.write(this.logString);
        this.logString = "";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        int preference = 0;
        boolean fixed = true;
        if (args.length > 0) {
            if (args[0].startsWith("n") || args[0].startsWith("N")) {
                preference = 3;
            } else if (args[0].startsWith("h") || args[0].startsWith("H")) {
                preference = 2;
            } else if (args[0].startsWith("v") || args[0].startsWith("V")) {
                preference = 1;
            }
        }
        if (args.length > 1 && !args[1].startsWith("f") && !args[1].startsWith("F")) {
            fixed = false;
        }
        new TextAreaTest(preference, fixed);
    }
}

