/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Scrollbar;

import com.acunia.wonka.test.awt.VisualTest;
import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.io.Writer;

public class ScrollbarTest
extends VisualTestImpl
implements AdjustmentListener,
VisualTest {
    Panel card = new Panel();
    Scrollbar sh1 = new Scrollbar(0);
    Scrollbar sh2 = new Scrollbar(0);
    Scrollbar sv1 = new Scrollbar(1);
    Scrollbar sv2 = new Scrollbar(1);
    String logtest;

    public ScrollbarTest() {
        this.card.setLayout(new CardLayout());
        this.setLayout(new BorderLayout());
        this.sh1.addAdjustmentListener(this);
        this.add((Component)this.sh1, "North");
        this.sh2.addAdjustmentListener(this);
        this.add((Component)this.sh2, "South");
        this.sv1.addAdjustmentListener(this);
        this.add((Component)this.sv1, "East");
        this.sv2.addAdjustmentListener(this);
        this.add((Component)this.sv2, "West");
        this.add((Component)this.card, "Center");
        this.card.setBackground(Color.green);
        this.logtest = new String();
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        String eventtype;
        Object source = evt.getSource();
        Scrollbar changed = (Scrollbar)evt.getAdjustable();
        Scrollbar mirror = this.getMirror(changed);
        switch (evt.getAdjustmentType()) {
            case 2: {
                eventtype = "UNIT_DECREMENT (left/upper button pressed)";
                break;
            }
            case 3: {
                eventtype = "BLOCK_DECREMENT (clicked scrollbar left of/above scrollbox)";
                break;
            }
            case 5: {
                eventtype = "TRACK (dragged scrollbox)";
                break;
            }
            case 4: {
                eventtype = "BLOCK_INCREMENT (clicked scrollbar right of/under scrollbox)";
                break;
            }
            case 1: {
                eventtype = "UNIT_INCREMENT (right/lower button pressed)";
                break;
            }
            default: {
                eventtype = "Unknown command (if this occurs, shoot the Wonka inplementation programmer)";
            }
        }
        this.logtest = this.logtest + " Settings for Scrollbar <" + this.getName(changed) + "> : \n";
        this.logtest = this.logtest + " => Event type : " + eventtype + " value : " + evt.getValue() + "\n";
        this.logtest = this.logtest + " Current value:" + evt.getValue();
        this.logtest = this.logtest + " mirrorred to" + this.getName(mirror) + "\n\n";
        mirror.setValues(changed.getValue(), changed.getVisibleAmount(), changed.getMinimum(), changed.getMaximum());
    }

    private Scrollbar getMirror(Scrollbar source) {
        Scrollbar mirror = this.sv2;
        if (source == this.sv2) {
            mirror = this.sv1;
        } else if (source == this.sh1) {
            mirror = this.sh2;
        } else if (source == this.sh2) {
            mirror = this.sh1;
        }
        return mirror;
    }

    private String getName(Scrollbar source) {
        String name = "sv1";
        if (source == this.sv2) {
            name = "sv2";
        } else if (source == this.sh1) {
            name = "sh1";
        } else if (source == this.sh2) {
            name = "sh2";
        }
        return name;
    }

    public String getTitle() {
        return "ScrollbarTest";
    }

    public String getHelpText() {
        return this.getTitle() + ":\nShould display a BorderLayout containing two horizontal and two vertical scrollbars.\n" + "The bars are coupled  so that every change in one of the bars results in an equal change of its counterpiece.";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public void log(Panel p, Writer w, boolean b) throws IOException {
        w.write(this.logtest);
        this.logtest = "";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        new ScrollbarTest();
    }
}

